/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.navigation;

import com.atlassian.jira.functest.framework.AbstractNavigationUtil;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;

public class ManageFiltersNavigation
extends AbstractNavigationUtil
implements FilterNavigation {
    public ManageFiltersNavigation(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData);
    }

    public void addFavourite(int id) {
        this.tester.gotoPage("secure/AddFavourite.jspa?entityId=" + id + "&entityType=SearchRequest");
    }

    public void removeFavourite(int id) {
        this.tester.gotoPage("secure/RemoveFavourite.jspa?entityId=" + id + "&entityType=SearchRequest");
    }

    public void goToDefault() {
        this.favouriteFilters();
    }

    public void manageSubscriptions(int filterId) {
        this.tester.gotoPage("secure/ViewSubscriptions.jspa?filterId=" + filterId);
    }

    public void favouriteFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=favourites");
    }

    public void myFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=my");
    }

    public void allFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=search&pressedSearchButton=true&searchName=&searchOwner=&Search=");
    }

    public void popularFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=popular");
    }

    public void searchFilters() {
        this.tester.gotoPage("secure/ManageFilters.jspa?filterView=search");
    }

    public long createFilter(String filterName, String filterDesc) {
        SharedEntityInfo info = new SharedEntityInfo(filterName, filterDesc, true, null);
        NavigatorSearch search = new NavigatorSearch(Collections.emptyList());
        return this.getNavigation().issueNavigator().createNewAndSaveAsFilter(info, search);
    }

    public void deleteFilter(int id) {
        this.tester.gotoPage("secure/DeleteFilter!delete.jspa?filterId=" + id);
    }

    public void findFilters(String filterName, String authorUsername) {
        this.tester.getDialog().setFormParameter("searchName", filterName);
        this.tester.getDialog().setFormParameter("searchOwnerUserName", authorUsername);
        this.tester.submit("Search");
    }

    public List sanitiseSearchFilterItems(List expectedItems) {
        return expectedItems;
    }

    public List sanitiseFavouriteFilterItems(List expectedItems) {
        return expectedItems;
    }

    public String getActionBaseUrl() {
        return "ManageFilters.jspa";
    }

    public FilterNavigation projects() {
        throw new UnsupportedOperationException("The projects view is unique to the filterpickerpopup implementation");
    }
}

