/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.locator.AbstractLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableCellLocator
extends AbstractLocator {
    private final int row;
    private final int col;
    private TableCell tableCell;

    public TableCellLocator(WebTester tester, String tableId, int row, int col) {
        super(tester);
        if (tableId == null) {
            throw new IllegalArgumentException("The tableId must not be null");
        }
        this.row = row;
        this.col = col;
        WebTable table = new TableLocator(tester, tableId).getTable();
        if (table == null) {
            Assert.fail((String)("No table with id '" + tableId + "' could be found!"));
        }
        XPathLocator delegateXpathLocator = new XPathLocator(tester, "//table[@id='" + tableId + "']//tr");
        Node[] rowNodes = delegateXpathLocator.getNodes();
        NodeList tdList = rowNodes[row].getChildNodes();
        int colCount = 0;
        for (int i = 0; i < tdList.getLength(); ++i) {
            Node tdNode = tdList.item(i);
            if (tdNode != null && ("th".equals(tdNode.getNodeName()) || "td".equals(tdNode.getNodeName()))) {
                ++colCount;
            }
            if (colCount != col + 1) continue;
            this.nodes = new Node[]{tdNode};
            break;
        }
        if (this.nodes == null || this.nodes.length == 0) {
            Assert.fail((String)("Table with id '" + tableId + "' does not have a cell at row '" + row + "' and column '" + col + "'"));
        }
        this.tableCell = table.getTableCell(row, col);
    }

    public TableCell getTableCell() {
        return this.tableCell;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String toString() {
        return "TableCellLocator{col=" + this.col + ", row=" + this.row + '}';
    }
}

