/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.locator;

import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.LocatorIterator;
import com.atlassian.jira.functest.framework.util.dom.DomKit;
import com.atlassian.jira.functest.framework.util.dom.SneakyDomExtractor;
import com.meterware.httpunit.WebResponse;
import java.util.Iterator;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractLocator
implements Locator {
    protected WebTester tester;
    protected WebResponse originalWebResponse;
    protected Node[] nodes;

    protected AbstractLocator() {
        this.nodes = null;
    }

    protected AbstractLocator(WebTester tester) {
        if (tester == null) {
            throw new IllegalArgumentException("The WebTester must not be null");
        }
        this.tester = tester;
        this.nodes = null;
    }

    public Node getNode() {
        Node[] nodes = this.getNodes();
        if (nodes.length == 0) {
            return null;
        }
        return DomKit.betterNode(nodes[0]);
    }

    public Iterator iterator() {
        return new LocatorIterator(this);
    }

    public boolean hasNodes() {
        return this.getNodes().length > 0;
    }

    protected Document getDOM(WebTester tester) {
        return SneakyDomExtractor.getDOM(tester);
    }

    public String getText() {
        return this.getNodesTextImpl(this.getNodes(), LocatorTextOperation.COLLAPSED_TEXT);
    }

    public String getText(Node node) {
        return this.getNodeTextImpl(node, LocatorTextOperation.COLLAPSED_TEXT);
    }

    public String getRawText() {
        return this.getNodesTextImpl(this.getNodes(), LocatorTextOperation.RAW_TEXT);
    }

    public String getRawText(Node node) {
        return this.getNodeTextImpl(node, LocatorTextOperation.RAW_TEXT);
    }

    public String getHTML() {
        return this.getNodesTextImpl(this.getNodes(), LocatorTextOperation.HTML_TEXT);
    }

    public String getHTML(Node node) {
        return this.getNodeTextImpl(node, LocatorTextOperation.HTML_TEXT);
    }

    protected String getNodeTextImpl(Node node, LocatorTextOperation textOperation) {
        if (!AbstractLocator.containsNode(this, node)) {
            throw new IllegalArgumentException("The node provided must be one contained in a call to Locator.getNodes()");
        }
        if (textOperation == LocatorTextOperation.HTML_TEXT) {
            return DomKit.getHTML(node);
        }
        if (textOperation == LocatorTextOperation.RAW_TEXT) {
            return DomKit.getRawText(node);
        }
        return DomKit.getCollapsedText(node);
    }

    protected String getNodesTextImpl(Node[] nodes, LocatorTextOperation textOperation) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nodes.length; ++i) {
            sb.append(this.getNodeTextImpl(nodes[i], textOperation));
        }
        return sb.toString();
    }

    protected static boolean containsNode(Locator locator, Node node) {
        Node[] nodes = locator.getNodes();
        boolean found = false;
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] != node) continue;
            found = true;
            break;
        }
        return found;
    }

    protected void checkDocumentState(Document currentDocument, Document originalDocument) {
        if (currentDocument != originalDocument) {
            this.throwStateException();
        }
    }

    protected void checkWebResponseState(WebResponse currentWebResponse, WebResponse originalWebResponse) {
        if (currentWebResponse != originalWebResponse) {
            this.throwStateException();
        }
    }

    private void throwStateException() {
        throw new IllegalStateException("The underlying WebTester has changed/moved and a call was made to this Locator " + this.toString());
    }

    protected WebResponse getWebResponse(WebTester tester) {
        WebResponse webResponse = null;
        if (tester.getDialog() != null) {
            webResponse = tester.getDialog().getResponse();
        }
        return webResponse;
    }

    protected synchronized String toStringImpl(String concreteImplementationName) {
        StringBuffer sb = new StringBuffer(concreteImplementationName);
        sb.append(" : ");
        if (this.nodes != null) {
            sb.append(this.nodes.length);
            sb.append(" node(s)");
            String text = this.getText();
            if (text != null) {
                text = StringUtils.abbreviate((String)text, (int)40);
            }
            sb.append(" - '").append(text).append("'");
        }
        return sb.toString();
    }

    protected static interface LocatorTextOperation {
        public static final LocatorTextOperation COLLAPSED_TEXT = new LocatorTextOperation(){};
        public static final LocatorTextOperation RAW_TEXT = new LocatorTextOperation(){};
        public static final LocatorTextOperation HTML_TEXT = new LocatorTextOperation(){};
    }
}

