/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import junit.framework.AssertionFailedError;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewIssueAssertions {
    private final WebTester tester;
    private final Assertions assertions;
    private final TextAssertions textAssertions;
    private static final String NONE = "None";

    public ViewIssueAssertions(WebTester tester, Assertions assertions) {
        this.tester = tester;
        this.assertions = assertions;
        this.textAssertions = assertions.getTextAssertions();
    }

    public void assertOnViewIssuePage(String issueKey) {
        this.assertions.assertNodeExists("//ul[@id='issuedetails']");
        this.assertions.getLinkAssertions().assertLinkPresentWithExactText("//div[@class='item-header']", issueKey);
    }

    public void assertAsignee(String userFullName) {
        IdLocator locator = new IdLocator(this.tester, "assignee-val");
        this.textAssertions.assertTextPresent(locator, userFullName);
    }

    public void assertOutwardLinkPresent(String issueKey) {
        if (!this.getOutwardLinks().contains(issueKey)) {
            this.fail("Outward link to '" + issueKey + "' is not present.");
        }
    }

    public void assertOutwardLinkNotPresent(String issueKey) {
        if (this.getOutwardLinks().contains(issueKey)) {
            this.fail("Outward link to '" + issueKey + "' is present.");
        }
    }

    public List<String> getOutwardLinks() {
        WebTable outwardLinks_table = this.tester.getDialog().getWebTableBySummaryOrId("outwardLinks_table");
        return this.getLinkKeys(outwardLinks_table);
    }

    public void assertInwardLinkPresent(String issueKey) {
        if (!this.getInwardLinks().contains(issueKey)) {
            this.fail("Inward link to '" + issueKey + "' is not present.");
        }
    }

    public void assertInwardLinkNotPresent(String issueKey) {
        if (this.getInwardLinks().contains(issueKey)) {
            this.fail("Inward link to '" + issueKey + "' is present.");
        }
    }

    public List<String> getInwardLinks() {
        WebTable inwardLinks_table = this.tester.getDialog().getWebTableBySummaryOrId("inwardLinks_table");
        return this.getLinkKeys(inwardLinks_table);
    }

    private List<String> getLinkKeys(WebTable linksTable) {
        ArrayList<String> links = new ArrayList<String>();
        if (linksTable == null) {
            return links;
        }
        int rowCount = linksTable.getRowCount();
        for (int row = 1; row < rowCount; ++row) {
            String text = linksTable.getCellAsText(row, 0).trim();
            if (text.startsWith("|")) {
                text = text.substring(1).trim();
            }
            StringTokenizer st = new StringTokenizer(text);
            links.add(st.nextToken());
        }
        return links;
    }

    private void fail(String message) {
        throw new AssertionFailedError(message);
    }

    public void assertAffectsVersions(String expected) {
        IdLocator locator = new IdLocator(this.tester, "versions-val");
        this.textAssertions.assertTextPresent(locator, expected);
    }

    public void assertAffectsVersionsNone() {
        this.assertAffectsVersions(NONE);
    }

    public String getAffectsVersionsText() {
        IdLocator locator = new IdLocator(this.tester, "versions-val");
        return locator.getRawText();
    }

    public void assertFixVersions(String expected) {
        IdLocator locator = new IdLocator(this.tester, "fixfor-val");
        this.textAssertions.assertTextPresent(locator, expected);
    }

    public void assertCustomFieldValue(String fieldId, String expected) {
        IdLocator locator = new IdLocator(this.tester, fieldId + "-val");
        this.textAssertions.assertTextPresent(locator, expected);
    }

    public void assertFixVersionsNone() {
        this.assertAffectsVersions(NONE);
    }

    public String getFixVersionsText() {
        IdLocator locator = new IdLocator(this.tester, "fixfor-val");
        return locator.getRawText();
    }

    public void assertComponents(String expected) {
        IdLocator locator = new IdLocator(this.tester, "components-val");
        this.textAssertions.assertTextPresent(locator, expected);
    }

    public void assertComponentsNone() {
        this.assertComponents(NONE);
    }

    public String getComponentsText() {
        IdLocator locator = new IdLocator(this.tester, "components-val");
        return locator.getRawText();
    }

    public void assertEnvironmentEquals(String expected) {
        IdLocator locator = new IdLocator(this.tester, "environment-val");
        if (StringUtils.isEmpty((String)expected)) {
            if (locator.getNodes().length != 0) {
                this.fail("Environment should not exist");
            }
        } else {
            this.textAssertions.assertTextPresent(locator, expected);
        }
    }

    public void assertTimeTrackingInfo(String original, String remaining, String logged) {
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "timetrackingmodule"), "Estimated", original, "Remaining", remaining, "Logged", logged);
    }

    private String getTableValueForLabel(String tableId, String label) {
        WebTable webTable = this.tester.getDialog().getWebTableBySummaryOrId(tableId);
        if (webTable == null) {
            return null;
        }
        for (int row = 0; row < webTable.getRowCount(); ++row) {
            String thisLabel = webTable.getCellAsText(row, 0);
            if (thisLabel == null || !thisLabel.trim().startsWith(label)) continue;
            return TextKit.collapseWhitespace(webTable.getCellAsText(row, 1));
        }
        return null;
    }
}

