/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.webtests.table.SimpleCell;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebTable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableAssertions
extends AbstractFuncTestUtil {
    private static ContainsChecker containsChecker = new ContainsChecker();
    private static EqualsChecker equalsChecker = new EqualsChecker();
    private static StrictWhitespaceContainsChecker strictWhitespaceContainsChecker = new StrictWhitespaceContainsChecker();

    public TableAssertions(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    public void assertTableContainsRowOnce(WebTable webTable, Object[] expectedRow) {
        this.assertTableContainsRowOnce(webTable, expectedRow, false);
    }

    public void assertTableContainsRowOnce(WebTable webTable, Object[] expectedRow, boolean exactCellSearching) {
        int numRows = this.countNumRows(webTable, expectedRow, exactCellSearching);
        if (numRows == 0) {
            Assert.fail((String)("Did not find expected row in table. Expected row = " + this.rowToString(expectedRow)));
        }
        if (numRows > 1) {
            Assert.fail((String)("Expected to find one copy of the row in table, but found " + numRows + ". Expected row = " + this.rowToString(expectedRow)));
        }
    }

    public void assertTableContainsRow(WebTable webTable, String[] expectedRow) {
        int numRows = this.countNumRows(webTable, expectedRow);
        if (numRows == 0) {
            Assert.fail((String)("Did not find expected row in table. Expected row = " + this.rowToString(expectedRow)));
        }
    }

    public void assertTableContainsRowCount(WebTable webTable, String[] expectedRow, int expectedCount) {
        int numRows = this.countNumRows(webTable, expectedRow);
        if (numRows != expectedCount) {
            Assert.fail((String)("Expected " + expectedCount + " row entries in table but found " + numRows + ". Expected row = " + this.rowToString(expectedRow)));
        }
    }

    public void assertTableRowEquals(WebTable table, int row, Object[] expectedRow) {
        Assert.assertTrue((String)("Expected row '" + this.rowToString(expectedRow) + "' does not match '" + this.getTableRowAsList(table, row) + "' (row '" + row + "' of table '" + table.getID() + "')"), (boolean)this.tableRowEquals(table, row, Arrays.asList(expectedRow), strictWhitespaceContainsChecker));
    }

    public void assertTableCellHasText(WebTable webTable, int row, int column, String text) {
        Assert.assertNotNull((Object)webTable);
        boolean hasText = containsChecker.check(webTable, row, column, text);
        String actualText = webTable.getCellAsText(row, column);
        Assert.assertTrue((String)("expected to find [" + text + "], somewhere in [" + actualText + "] but obviously couldn't."), (boolean)hasText);
    }

    private int countNumRows(WebTable webTable, Object[] expectedRow) {
        return this.countNumRows(webTable, expectedRow, false);
    }

    private int countNumRows(WebTable webTable, Object[] expectedRow, boolean exactCellSearching) {
        int count = 0;
        for (int i = 0; i < webTable.getRowCount(); ++i) {
            if (!this.tableRowEquals(webTable, i, Arrays.asList(expectedRow), exactCellSearching)) continue;
            ++count;
        }
        return count;
    }

    private boolean tableRowEquals(WebTable table, int row, List expectedRow, boolean strictCellCheck) {
        TableCellChecker checker = strictCellCheck ? equalsChecker : containsChecker;
        return this.tableRowEquals(table, row, expectedRow, checker);
    }

    private boolean tableRowEquals(WebTable table, int row, List expectedRow, TableCellChecker tableCellChecker) {
        if (expectedRow.isEmpty()) {
            this.log("expected row is empty");
            return false;
        }
        int maxCol = table.getColumnCount();
        for (int col = 0; col < expectedRow.size() && col < maxCol; ++col) {
            Object expectedCell = expectedRow.get(col);
            if (expectedCell == null) continue;
            if (expectedCell instanceof SimpleCell) {
                SimpleCell simpleCell = (SimpleCell)expectedCell;
                if (simpleCell.equals(table, row, col)) continue;
                String cellContent = simpleCell.getCellAsText(table, row, col);
                this.log("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]");
                return false;
            }
            if (tableCellChecker.check(table, row, col, expectedCell.toString())) continue;
            String cellContent = table.getCellAsText(row, col).trim();
            this.log("table '" + table.getID() + "' row '" + row + "' does not match expected row because cell [" + row + ", " + col + "] = [" + cellContent + "] does not match [" + expectedCell.toString() + "]");
            return false;
        }
        return true;
    }

    private String rowToString(Object[] row) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < row.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('\"');
            sb.append(row[i]);
            sb.append('\"');
        }
        return sb.toString();
    }

    private List<String> getTableRowAsList(WebTable table, int row) {
        ArrayList<String> tableRow = new ArrayList<String>();
        int maxCol = table.getColumnCount();
        for (int col = 0; col < maxCol; ++col) {
            tableRow.add(table.getCellAsText(row, col).trim());
        }
        return tableRow;
    }

    private static final class ContainsChecker
    implements TableCellChecker {
        private ContainsChecker() {
        }

        public boolean check(WebTable table, int row, int col, String text) {
            return TextKit.containsCollapseWhiteSpace(text, table.getCellAsText(row, col));
        }
    }

    private static final class StrictWhitespaceContainsChecker
    implements TableCellChecker {
        private StrictWhitespaceContainsChecker() {
        }

        public boolean check(WebTable table, int row, int col, String text) {
            String cellContent = table.getCellAsText(row, col);
            if ("".equals(text)) {
                return "".equals(cellContent.trim());
            }
            return cellContent.contains(text);
        }
    }

    private static final class EqualsChecker
    implements TableCellChecker {
        private EqualsChecker() {
        }

        public boolean check(WebTable table, int row, int col, String text) {
            return TextKit.equalsCollapseWhiteSpace(text, table.getCellAsText(row, col));
        }
    }

    static interface TableCellChecker {
        public boolean check(WebTable var1, int var2, int var3, String var4);
    }
}

