/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.assertions.LabelAssertions;
import com.atlassian.jira.functest.framework.labels.Labels;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import junit.framework.Assert;
import net.sourceforge.jwebunit.WebTester;

public class LabelAssertionsImpl
extends AbstractFuncTestUtil
implements LabelAssertions {
    private static final String FIELDID_LABELS = "labels";

    public LabelAssertionsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    private void assertLabelsExist(Labels labels, String issueId, String fieldId) {
        Assert.assertTrue((String)("Labels should exist but can't find labels for issue - " + issueId + ", field - " + fieldId), (labels != null ? 1 : 0) != 0);
    }

    public void assertLabelsExist(String issueId, String fieldId) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        this.assertLabelsExist(labels, issueId, fieldId);
    }

    public void assertLabelsDontExist(String issueId, String fieldId) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        Assert.assertTrue((String)("Labels should not exist but found labels for issue - " + issueId + ", field - " + fieldId), (labels == null ? 1 : 0) != 0);
    }

    public void assertLabelsEmpty(Labels labels) {
        Assert.assertTrue((String)("Labels should be empty but contains: " + labels.toString()), (boolean)labels.getLabelValues().isEmpty());
    }

    public void assertLabels(String issueId, String fieldId, Labels expectedLabels) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        this.assertLabelsExist(labels, issueId, fieldId);
        Assert.assertEquals((Object)expectedLabels, (Object)labels);
    }

    public void assertSystemLabels(String issueId, Labels expectedLabels) {
        this.assertLabels(issueId, FIELDID_LABELS, expectedLabels);
    }

    public void assertLabelsContain(String issueId, String fieldId, Labels expectedLabels) {
        Labels labels = Labels.parseLabels(this.tester, issueId, fieldId);
        this.assertLabelsExist(labels, issueId, fieldId);
        Assert.assertEquals((boolean)expectedLabels.isEditable(), (boolean)labels.isEditable());
        Assert.assertEquals((boolean)expectedLabels.isLinked(), (boolean)labels.isLinked());
        Assert.assertEquals((boolean)expectedLabels.isLozenges(), (boolean)labels.isLozenges());
        Assert.assertTrue((boolean)labels.getLabelValues().containsAll(expectedLabels.getLabelValues()));
    }
}

