/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.assertions;

import com.atlassian.jira.functest.framework.assertions.HTMLAssertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.util.NotNull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang.StringEscapeUtils;

public class HTMLAssertionsImpl
implements HTMLAssertions {
    public void assertContains(String original, String expected) {
        new TextAssertionsImpl().assertTextPresent(HTMLAssertionsImpl.unescape(original), expected);
    }

    public void assertResponseContains(WebTester tester, String expected) {
        this.assertContains(HTMLAssertionsImpl.getResponseText(tester), expected);
    }

    static String unescape(@NotNull String escapedText) {
        return StringEscapeUtils.unescapeHtml((String)escapedText);
    }

    static String getResponseText(@NotNull WebTester tester) {
        try {
            return tester.getDialog().getResponse().getText();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class WriterStream
    extends OutputStream {
        private final Writer writer;

        WriterStream(@NotNull Writer writer) {
            this.writer = writer;
        }

        public void write(int b) throws IOException {
            this.writer.write(b);
        }

        public void flush() throws IOException {
            this.writer.flush();
        }
    }
}

