/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.AbstractFuncTestUtil;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import net.sourceforge.jwebunit.WebTester;

public class TimeTrackingImpl
extends AbstractFuncTestUtil
implements TimeTracking {
    public TimeTrackingImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        super(tester, environmentData, 2);
    }

    public void enable(TimeTracking.Mode mode) {
        this.log("Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            if (mode.equals((Object)TimeTracking.Mode.LEGACY)) {
                this.tester.checkCheckbox("legacyMode", "true");
            } else {
                this.tester.uncheckCheckbox("legacyMode");
            }
            this.tester.submit("Activate");
        } else {
            this.log("Time tracking already activated.");
        }
    }

    public void switchMode(TimeTracking.Mode mode) {
        this.disable();
        this.enable(mode);
    }

    public void enable(TimeTracking.Format format) {
        this.log("Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            this.tester.checkCheckbox("timeTrackingFormat", format.toString().toLowerCase());
            this.tester.submit("Activate");
        } else {
            this.log("Time tracking already activated.");
        }
    }

    public void enable(String hoursPerDay, String daysPerWeek, String format, String defaultUnit, TimeTracking.Mode mode) {
        this.log("Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            this.tester.setFormElement("hoursPerDay", hoursPerDay);
            this.tester.setFormElement("daysPerWeek", daysPerWeek);
            this.tester.checkCheckbox("timeTrackingFormat", format);
            this.tester.selectOption("defaultUnit", defaultUnit);
            if (mode.equals((Object)TimeTracking.Mode.LEGACY)) {
                this.tester.checkCheckbox("legacyMode", "true");
            } else {
                this.tester.uncheckCheckbox("legacyMode");
            }
            this.tester.submit("Activate");
            this.tester.assertTextPresent(String.format("The current default unit for time tracking is <b>%s</b>.", defaultUnit));
        } else {
            this.log("Time tracking already activated.");
        }
    }

    private void enable(boolean copyCommentEnabled) {
        this.log("Activating time tracking");
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.tester.getDialog().hasSubmitButton("Activate")) {
            if (copyCommentEnabled) {
                this.tester.checkCheckbox("copyComment", "true");
            } else {
                this.tester.uncheckCheckbox("copyComment");
            }
            this.tester.submit("Activate");
        } else {
            this.log("Time tracking already activated.");
        }
    }

    public void disable() {
        this.log("Deactivating time tracking.");
        this.submitAtPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa", "Deactivate", "time tracking already deactivated");
    }

    protected Navigation getNavigation() {
        return this.getFuncTestHelperFactory().getNavigation();
    }

    public boolean isIn(TimeTracking.Mode mode) {
        this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        if (this.isEnabled()) {
            return TimeTracking.Mode.MODERN == mode ^ this.tester.getDialog().isTextInResponse("Legacy mode is currently <b>ON</b>.");
        }
        return false;
    }

    public void disableCopyingOfComments() {
        if (this.isEnabled()) {
            this.disable();
        }
        this.enable(false);
        this.getFuncTestHelperFactory().getTextAssertions().assertTextSequence(new WebPageLocator(this.tester), "Copying of comments to work description is currently", "disabled", "For the users you wish");
    }

    private boolean isEnabled() {
        if (!this.getNavigation().getCurrentPage().equals("/secure/admin/jira/TimeTrackingAdmin!default.jspa")) {
            this.tester.gotoPage("/secure/admin/jira/TimeTrackingAdmin!default.jspa");
        }
        return this.tester.getDialog().hasSubmitButton("Deactivate");
    }
}

