/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.TestSuiteBuilder;
import com.atlassian.jira.functest.framework.log.FuncTestOut;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.util.LocalTestEnvironmentData;
import com.atlassian.jira.webtests.util.TestClassUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FuncTestSuite
implements Test {
    private final Set<Class<? extends TestCase>> funcTests = new LinkedHashSet<Class<? extends TestCase>>();
    private final Set<Class<? extends TestCase>> bundledPlugins2Tests = new LinkedHashSet<Class<? extends TestCase>>();

    public Test createTest() {
        return this.createTest(new LocalTestEnvironmentData());
    }

    public Test createTest(JIRAEnvironmentData environment) {
        Set<Class<? extends TestCase>> tests = this.getTests(environment);
        TestSuiteBuilder builder = FuncTestSuite.createFuncTestBuilder();
        builder.addTests(tests);
        return builder.build();
    }

    public Set<Class<? extends TestCase>> getTests(JIRAEnvironmentData environmentData) {
        Set<Class<? extends TestCase>> tests;
        if (environmentData.isAllTests()) {
            tests = new LinkedHashSet<Class<? extends TestCase>>();
            tests.addAll(this.getFuncTests());
            tests.addAll(this.getBundledPlugins2Tests());
        } else {
            tests = environmentData.isBundledPluginsOnly() ? this.getBundledPlugins2Tests() : this.getFuncTests();
        }
        return tests;
    }

    private static TestSuiteBuilder createFuncTestBuilder() {
        String b = System.getProperty("atlassian.test.suite.numbatches");
        String n = System.getProperty("atlassian.test.suite.batch");
        if (b != null && n != null) {
            String batchInfo = "Batch " + n + " of " + b;
            try {
                int numBatches = Integer.parseInt(b);
                int batch = Integer.parseInt(n);
                if (batch > 0 && batch <= numBatches) {
                    FuncTestOut.out.println(batchInfo);
                    return new TestSuiteBuilder(batch, numBatches);
                }
                FuncTestOut.out.println("Batch mode FAIL. Batch information looks wrong-arse: " + batchInfo);
            }
            catch (NumberFormatException e) {
                FuncTestOut.err.println("Batch mode FAIL. Batch information cannot be properly interpreted: " + batchInfo);
                e.printStackTrace(FuncTestOut.err);
            }
        }
        return new TestSuiteBuilder();
    }

    public Set<Class<? extends TestCase>> getFuncTests() {
        return new LinkedHashSet<Class<? extends TestCase>>(this.funcTests);
    }

    public Set<Class<? extends TestCase>> getBundledPlugins2Tests() {
        return new LinkedHashSet<Class<? extends TestCase>>(this.bundledPlugins2Tests);
    }

    public FuncTestSuite addBundledPlugins2Only(Class<? extends TestCase> testCaseClass) {
        this.assertItsATest(testCaseClass);
        this.bundledPlugins2Tests.add(testCaseClass);
        return this;
    }

    public FuncTestSuite addTest(Class<? extends TestCase> testCaseClass) {
        this.assertItsATest(testCaseClass);
        this.funcTests.add(testCaseClass);
        return this;
    }

    public FuncTestSuite addTests(Collection<Class<? extends TestCase>> testCaseClasses) {
        for (Class<? extends TestCase> testCaseClass : testCaseClasses) {
            this.addTest(testCaseClass);
        }
        return this;
    }

    public FuncTestSuite addTestsInPackage(String packageName, boolean recursive, Class<? extends TestCase> ... ignore) {
        List<Class<? extends TestCase>> cases = TestClassUtils.getTestClasses(packageName, recursive);
        cases.removeAll(Arrays.asList(ignore));
        Collections.sort(cases, new Comparator<Class<? extends TestCase>>(){

            @Override
            public int compare(Class<? extends TestCase> o1, Class<? extends TestCase> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.addTests(cases);
        return this;
    }

    public FuncTestSuite addTestsInPackageBundledPluginsOnly(String packageName, boolean recursive, Class<? extends TestCase> ... ignore) {
        List<Class<? extends TestCase>> cases = TestClassUtils.getTestClasses(packageName, recursive);
        cases.removeAll(Arrays.asList(ignore));
        Collections.sort(cases, new Comparator<Class<? extends TestCase>>(){

            @Override
            public int compare(Class<? extends TestCase> o1, Class<? extends TestCase> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Class<? extends TestCase> aCase : cases) {
            this.addBundledPlugins2Only(aCase);
        }
        return this;
    }

    public FuncTestSuite addTestSuite(FuncTestSuite funcTestSuite) {
        Set<Class<? extends TestCase>> tests = funcTestSuite.getFuncTests();
        for (Class<? extends TestCase> testCaseClass : tests) {
            this.addTest(testCaseClass);
        }
        tests = funcTestSuite.getBundledPlugins2Tests();
        for (Class<? extends TestCase> testCaseClass : tests) {
            this.addBundledPlugins2Only(testCaseClass);
        }
        return this;
    }

    private void assertItsATest(Class testCaseClass) {
        if (!Test.class.isAssignableFrom(testCaseClass)) {
            throw new IllegalArgumentException("The class must be an instanceof of junit.framework.Test to be added - " + testCaseClass);
        }
    }

    public int countTestCases() {
        return this.createTest().countTestCases();
    }

    public void run(TestResult result) {
        this.createTest().run(result);
    }
}

