/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.webtests.AbstractTestWorkflowNameEditing;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.NotCell;
import com.atlassian.jira.webtests.table.OrCell;
import com.atlassian.jira.webtests.table.TextCell;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestWorkflowNameEditingEnterprise
extends AbstractTestWorkflowNameEditing {
    public TestWorkflowNameEditingEnterprise(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestWorkflowNameEditingEnterprise.xml");
    }

    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testListWorkflowsOperationLinkVisibility() throws SAXException {
        this.gotoWorkFlow();
        WebTable workflowsTable = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestWorkflowNameEditingEnterprise.assertEquals((int)5, (int)workflowsTable.getRowCount());
        this.assertTableRowEquals(workflowsTable, 0, new Object[]{"Name", "Description", "Status", "Schemes", "Number of steps", "Operations"});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{new TextCell("jira", "(Read-only System Workflow)"), "The default JIRA workflow.", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new TextCell("Used by projects with no associated workflow scheme and by workflow schemes with unassigned issue types.")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=jira", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"Active workflow", "This workflow is active", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10000", "Active Scheme")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Active+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Active+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Active+workflow", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable with no scheme", "this workflow does not have any scheme or project", "Inactive", "", "1", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Edit"), new LinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Delete"))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable workflow", "This workflow is editable as it is inactive", "Inactive", new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), "2", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Edit"), new NotCell(new TextCell("Delete")))});
    }

    public void testEditInactiveWorkflowWithNoScheme() throws SAXException {
        this.gotoWorkFlow();
        WebTable workflowsTable = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestWorkflowNameEditingEnterprise.assertEquals((int)5, (int)workflowsTable.getRowCount());
        this.assertTableRowEquals(workflowsTable, 0, new Object[]{"Name", "Description", "Status", "Schemes", "Number of steps", "Operations"});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{new TextCell("jira", "(Read-only System Workflow)"), "The default JIRA workflow.", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new TextCell("Used by projects with no associated workflow scheme and by workflow schemes with unassigned issue types.")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=jira", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"Active workflow", "This workflow is active", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10000", "Active Scheme")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Active+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Active+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Active+workflow", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable workflow", "This workflow is editable as it is inactive", "Inactive", new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), "2", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Edit"), new NotCell(new TextCell("Delete")))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable with no scheme", "this workflow does not have any scheme or project", "Inactive", "", "1", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Edit"), new LinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Delete"))});
        this.clickLink("edit_live_editable with no scheme");
        this.setWorkingForm("jiraform");
        this.assertFormElementWithNameHasValue("newWorkflowName", "editable with no scheme");
        this.assertFormElementWithNameHasValue("description", "this workflow does not have any scheme or project");
        this.setFormElement("newWorkflowName", "edited with no scheme");
        this.setFormElement("description", "description has been edited");
        this.submit("Edit");
        workflowsTable = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestWorkflowNameEditingEnterprise.assertEquals((int)5, (int)workflowsTable.getRowCount());
        this.assertTableRowEquals(workflowsTable, 0, new Object[]{"Name", "Description", "Status", "Schemes", "Number of steps", "Operations"});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{new TextCell("jira", "(Read-only System Workflow)"), "The default JIRA workflow.", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new TextCell("Used by projects with no associated workflow scheme and by workflow schemes with unassigned issue types.")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=jira", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"Active workflow", "This workflow is active", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10000", "Active Scheme")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Active+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Active+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Active+workflow", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable workflow", "This workflow is editable as it is inactive", "Inactive", new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), "2", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Edit"), new NotCell(new TextCell("Delete")))});
        this.assertTableHasNoMatchingRow(workflowsTable, 1, new Object[]{"editable with no scheme", "this workflow does not have any scheme or project", "Inactive", "", "1", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Edit"), new LinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Delete"))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"edited with no scheme", "description has been edited", "Inactive", "", "1", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=edited+with+no+scheme", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=edited+with+no+scheme", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=edited+with+no+scheme", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=edited+with+no+scheme", "Edit"), new LinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=edited+with+no+scheme", "Delete"))});
    }

    public void testEditInactiveWorkflowWithScheme() throws SAXException {
        this.gotoPage("/secure/admin/EditWorkflowSchemeEntities!default.jspa?schemeId=10001");
        this.assertLinkWithTextUrlContains("editable workflow", new String[]{"secure/admin/workflows/ViewWorkflowSteps.jspa", "workflowMode=live", "workflowName=editable+workflow"});
        this.assertTextNotPresent("edited with a scheme");
        this.gotoWorkFlow();
        WebTable workflowsTable = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestWorkflowNameEditingEnterprise.assertEquals((int)5, (int)workflowsTable.getRowCount());
        this.assertTableRowEquals(workflowsTable, 0, new Object[]{"Name", "Description", "Status", "Schemes", "Number of steps", "Operations"});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{new TextCell("jira", "(Read-only System Workflow)"), "The default JIRA workflow.", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new TextCell("Used by projects with no associated workflow scheme and by workflow schemes with unassigned issue types.")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=jira", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"Active workflow", "This workflow is active", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10000", "Active Scheme")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Active+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Active+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Active+workflow", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable with no scheme", "this workflow does not have any scheme or project", "Inactive", "", "1", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Edit"), new LinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Delete"))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable workflow", "This workflow is editable as it is inactive", "Inactive", new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), "2", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Edit"), new NotCell(new TextCell("Delete")))});
        this.clickLink("edit_live_editable workflow");
        this.setWorkingForm("jiraform");
        this.assertFormElementWithNameHasValue("newWorkflowName", "editable workflow");
        this.assertFormElementWithNameHasValue("description", "This workflow is editable as it is inactive");
        this.setFormElement("newWorkflowName", "edited with a scheme");
        this.setFormElement("description", "description is edited");
        this.submit("Edit");
        workflowsTable = this.getDialog().getResponse().getTableWithID("workflows_table");
        TestWorkflowNameEditingEnterprise.assertEquals((int)5, (int)workflowsTable.getRowCount());
        this.assertTableRowEquals(workflowsTable, 0, new Object[]{"Name", "Description", "Status", "Schemes", "Number of steps", "Operations"});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{new TextCell("jira", "(Read-only System Workflow)"), "The default JIRA workflow.", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new TextCell("Used by projects with no associated workflow scheme and by workflow schemes with unassigned issue types.")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=jira", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"Active workflow", "This workflow is active", "Active", new AndCell(new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10000", "Active Scheme")), "5", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Active+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Active+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Active+workflow", "Copy"), new NotCell(new OrCell(new TextCell("Edit"), new TextCell("Delete"))))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"editable with no scheme", "this workflow does not have any scheme or project", "Inactive", "", "1", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Edit"), new LinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=editable+with+no+scheme", "Delete"))});
        this.assertTableHasNoMatchingRow(workflowsTable, 1, new Object[]{"editable workflow", "This workflow is editable as it is inactive", "Inactive", new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), "2", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=editable+workflow", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=editable+workflow", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=editable+workflow", "Edit"), new NotCell(new TextCell("Delete")))});
        this.assertTableHasMatchingRowFrom(workflowsTable, 1, new Object[]{"edited with a scheme", "description is edited", "Inactive", new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10001", "scheme with editable flow"), "2", new AndCell(new LinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=edited+with+a+scheme", "Steps"), new LinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=edited+with+a+scheme", "XML"), new LinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=edited+with+a+scheme", "Copy"), new LinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=edited+with+a+scheme", "Edit"), new NotCell(new TextCell("Delete")))});
        this.gotoPage("/secure/admin/EditWorkflowSchemeEntities!default.jspa?schemeId=10001");
        this.assertLinkWithTextUrlContains("edited with a scheme", new String[]{"secure/admin/workflows/ViewWorkflowSteps.jspa", "workflowMode=live", "workflowName=edited+with+a+scheme"});
        this.assertTextNotPresent("editable workflow");
        this.gotoPage("/secure/admin/EditWorkflowSchemeEntities!default.jspa?schemeId=10010");
        this.assertLinkWithTextUrlContains("edited with a scheme", new String[]{"secure/admin/workflows/ViewWorkflowSteps.jspa", "workflowMode=live", "workflowName=edited+with+a+scheme"});
        this.assertTextNotPresent("editable workflow");
        this.associateWorkFlowSchemeToProject("monkey", "scheme with editable flow");
        this.waitForSuccessfulWorkflowSchemeMigration("monkey", "scheme with editable flow");
        this.associateWorkFlowSchemeToProject("neanderthal", "scheme with renamed workflow");
        this.waitForSuccessfulWorkflowSchemeMigration("neanderthal", "scheme with renamed workflow");
        this.assertAddingIssueForModifiedWorkflow("monkey", "MKY", "New Feature", "MONKEY new feature issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("monkey", "MKY", "Task", "MONKEY task issue of the workflow that was renamed");
        this.assertAddingIssueForUnModifiedWorkflow("monkey", "MKY", "Bug", "MONKEY bug issue of the workflow that was NOT renamed");
        this.assertAddingIssueForUnModifiedWorkflow("monkey", "MKY", "Improvement", "MONKEY improvement issue of the workflow that was NOT renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "NDT", "Bug", "NEO bug issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "NDT", "Improvement", "NEO improvement issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "NDT", "New Feature", "NEO new feature issue of the workflow that was renamed");
        this.assertAddingIssueForModifiedWorkflow("neanderthal", "NDT", "Task", "NEO task issue of the workflow that was renamed");
    }

    private void assertAddingIssueForUnModifiedWorkflow(String project, String projectKey, String issueType, String summary) {
        this.addIssue(project, projectKey, issueType, summary);
        this.assertTextNotPresent("RESOLVE WITH EDITED WORKFLOW");
        this.assertLinkPresentWithText("Start Progress");
        this.assertLinkPresentWithText("Resolve Issue");
        this.assertLinkPresentWithText("Close Issue");
        this.assertTextPresent("Open");
        this.assertTextNotPresent("In Progress");
        this.clickLink("action_id_4");
        this.assertTextPresent("In Progress");
        this.assertTextNotPresent("Open");
    }

    private void assertAddingIssueForModifiedWorkflow(String project, String projectKey, String issueType, String summary) {
        this.addIssue(project, projectKey, issueType, summary);
        this.assertLinkPresentWithText("RESOLVE WITH EDITED WORKFLOW");
        this.assertTextPresent("Open");
        this.assertTextNotPresent("Resolved");
        this.clickLink("action_id_11");
        this.assertTextPresent("Resolved");
        this.assertTextNotPresent("Open");
    }
}

