/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestWorkFlowSchemes
extends JIRAWebTest {
    private static final String TAB_NAME = "Tab for Testing";
    private static final String CUSTOM_FIELD_NAME = "Approval Rating";
    private static final String CUSTOM_FIELD_NAME_TWO = "Animal";
    String customFieldId;
    String customFieldId2;
    private static final String UNSHOWN_STATUS = "Unshown Status";

    public TestWorkFlowSchemes(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testWorkFlowSchemes() {
        this.restoreBlankInstance();
        if (this.workflowSchemeExists("New Workflow Scheme")) {
            this.associateWorkFlowSchemeToProject("homosapien", "Default");
            this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Default");
            this.associateWorkFlowSchemeToProject("monkey", "Default");
            this.waitForSuccessfulWorkflowSchemeMigration("monkey", "Default");
            this.deleteWorkFlowScheme("New Workflow Scheme");
        }
        if (this.workflowExists("New Workflow For Testing")) {
            this.deleteWorkFlow("New Workflow For Testing");
        }
        if (this.workflowExists("Copied Workflow")) {
            this.deleteWorkFlow("Copied Workflow");
        }
        if (this.linkedStatusExists("Approved")) {
            this.deleteLinkedStatus("10000");
        }
        this.resetFields();
        this.removeAllFieldScreens();
        this.removeAllCustomFields();
        this.customFieldId = this.addCustomField("textfield", CUSTOM_FIELD_NAME);
        this.customFieldId2 = this.addCustomField("textfield", CUSTOM_FIELD_NAME_TWO);
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", "test 1", "Minor", null, null, null, "Administrator", "test environment 1", "test description for workflow schemes", null, null, null);
        this.addScreen("Test Workflow Screen", "");
        this.addFieldToFieldScreen("Test Workflow Screen", CUSTOM_FIELD_NAME);
        this.addTabToScreen("Test Workflow Screen", TAB_NAME);
        this.addFieldToFieldScreenTab("Test Workflow Screen", TAB_NAME, CUSTOM_FIELD_NAME_TWO, "");
        this.workflowAddScheme();
        this.workflowAddDuplicateScheme();
        this.workflowAddInvalidScheme();
        this.workflowAddWorkflow();
        this.workflowCopyWorkflow();
        this.workflowAddDuplicateWorkflow();
        this.workflowAddInvalidWorkflow();
        this.workflowAddLinkedStatus();
        this.workflowAddDuplicateLinkedStatus();
        this.workflowAddInvalidLinkedStatus();
        this.workflowAddStep();
        this.workflowAddTransition();
        this.workflowAddDuplicateTransition();
        this.workflowAddInvalidTransition();
        this.gotoWorkFlowScheme();
        this.clickLink("workflowscheme_10000");
        this.assertTextPresent("On this page you can edit the workflows for the \"New Workflow Scheme\" workflow scheme.");
        this.assertTextNotPresent("The \"New Workflow Scheme\" workflow scheme is active therefore you cannot edit its workflows.");
        this.workflowAssignWorkflowSchemeToIssueType();
        this.workflowAssociateWorkflowSchemeToProject();
        this.gotoWorkFlowScheme();
        this.clickLink("workflowscheme_10000");
        this.assertTextNotPresent("On this page you can edit the workflows for the \"New Workflow Scheme\" workflow scheme.");
        this.assertTextPresent("The \"New Workflow Scheme\" workflow scheme is active therefore you cannot edit its workflows.");
        this.workflowPerformAction(issueKey);
        this._testNoActiveStatus();
        this.associateWorkFlowSchemeToProject("homosapien", "Default");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "Default");
        this.workflowDeleteScheme();
        this.workflowDeleteTransition();
        this.workflowDeleteStep();
        this.workflowDeleteLinkedStatus();
        this.workflowDeleteWorkflow();
        this.deleteIssue(issueKey);
        this.removeAllFieldScreens();
        this.removeAllCustomFields();
    }

    private void _testNoActiveStatus() {
        TestWorkFlowSchemes.logSection("Workflow Schemes: Non-active status should not be displayed if it's not active");
        this.addLinkedStatus(UNSHOWN_STATUS, "This status should not be shown in the issue navigator");
        this.assertTextPresent(UNSHOWN_STATUS);
        this.displayAllIssues();
        this.assertTextPresent("Approved");
        this.assertTextNotPresent(UNSHOWN_STATUS);
        this.deleteLinkedStatus("10001");
        this.assertTextNotPresent(UNSHOWN_STATUS);
    }

    public void workflowAddScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Create a workflow scheme");
        this.addWorkFlowScheme("New Workflow Scheme", "New workflow scheme for testing");
        this.assertTextPresent("Workflow Schemes");
        this.assertTextPresent("New Workflow Scheme");
    }

    public void workflowDeleteScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Delete a workflow scheme");
        this.deleteWorkFlowScheme("New Workflow Scheme");
        this.assertTextPresent("Workflow Schemes");
        this.assertTextNotPresent("New Workflow Scheme");
    }

    public void workflowAddDuplicateScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow scheme with a duplicate name");
        this.addWorkFlowScheme("New Workflow Scheme", "");
        this.assertTextPresent("Add Workflow Scheme");
        this.assertTextPresent("A Scheme with this name already exists.");
    }

    public void workflowAddInvalidScheme() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow scheme with a invalid name");
        this.addWorkFlowScheme("", "");
        this.assertTextPresent("Add Workflow Scheme");
        this.assertTextPresent("Please specify a name for this Scheme.");
    }

    public void workflowAddWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Create a workflow");
        this.addWorkFlow("New Workflow For Testing", "New workflow for testing");
        this.assertTextPresent("New Workflow For Testing");
    }

    public void workflowDeleteWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Delete a workflow");
        this.deleteWorkFlow("New Workflow For Testing");
        this.assertTextNotPresent("New Workflow For Testing");
        this.deleteWorkFlow("Copied Workflow");
        this.assertTextNotPresent("Copied Workflow");
    }

    public void workflowCopyWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Copy a workflow");
        this.copyWorkFlow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.assertTextPresent("Copied Workflow");
    }

    public void workflowAddDuplicateWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow with a duplicate name");
        this.addWorkFlow("Copied Workflow", "");
        this.assertTextPresent("A workflow with this name already exists.");
    }

    public void workflowAddInvalidWorkflow() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a workflow with an invalid name");
        this.addWorkFlow("", "");
        this.assertTextPresent("You must specify a workflow name.");
    }

    public void workflowAddLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Schemes: Add a linked status");
        this.addLinkedStatus("Approved", "The resolution of this issue has been approved");
        this.assertTextPresent("Approved");
    }

    public void workflowDeleteLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Schemes: Delete a linked status");
        this.deleteLinkedStatus("10000");
        this.assertTextNotPresent("Approved");
    }

    public void workflowAddDuplicateLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a linked status with a duplicate name");
        this.addLinkedStatus("Approved", "");
        this.assertTextPresent("A status with that name already exists.");
    }

    public void workflowAddInvalidLinkedStatus() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a linked status with a invalid name");
        this.addLinkedStatus("", "");
        this.assertTextPresent("You must specify a name for the status to be added.");
    }

    public void workflowAddStep() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a step");
        this.addStep("Copied Workflow", "Approved", "Approved");
        this.assertLinkPresentWithText("Approved");
        this.assertFormElementNotPresent("stepName");
        this.assertFormElementNotPresent("stepStatus");
    }

    public void workflowDeleteStep() {
        TestWorkFlowSchemes.log("Workflow Scheme: delete a step");
        this.deleteStep("Copied Workflow", "Approved");
        this.assertLinkNotPresent("Approved");
        this.assertFormElementPresent("stepName");
        this.assertFormElementPresent("stepStatus");
    }

    public void workflowAddTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a transition to a step");
        this.addTransition("Copied Workflow", "Resolved", "Approve Issue", "", "Approved", "Test Workflow Screen");
        this.assertLinkPresentWithText("Approve Issue");
        this.addTransition("Copied Workflow", "Approved", "Reopen Issue", "", "Open", "Workflow Screen");
        this.addTransition("Copied Workflow", "Approved", "Close Issue", "", "Closed", null);
    }

    public void workflowDeleteTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Delete a transition from a Step");
        this.deleteTransition("Copied Workflow", "Resolved", "Approve Issue");
        this.assertLinkNotPresentWithText("Approve Issue");
        this.deleteTransition("Copied Workflow", "Approved", "Reopen Issue");
        this.deleteTransition("Copied Workflow", "Approved", "Close Issue");
    }

    public void workflowAddDuplicateTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a transition with a duplicate nane");
        this.addTransition("Copied Workflow", "Approved", "Reopen Issue", "", "Open", null);
        this.assertTextPresent("Add Workflow Transition");
        this.assertTextPresent("Transition with this name already exists for Approved step.");
    }

    public void workflowAddInvalidTransition() {
        TestWorkFlowSchemes.log("Workflow Scheme: Add a transition with an invalid name");
        this.addTransition("Copied Workflow", "Approved", "", "", "Open", null);
        this.assertTextPresent("Add Workflow Transition");
        this.assertTextPresent("You must enter a valid name.");
    }

    public void workflowAssignWorkflowSchemeToIssueType() {
        TestWorkFlowSchemes.log("Workflow Scheme: Assign a workflow scheme to an issue type");
        this.assignWorkflowScheme("New Workflow Scheme", "Bug", "Copied Workflow");
        this.assertTextPresent("Edit Workflows for New Workflow Scheme");
        this.assertTextPresent("Copied Workflow");
        this.assertTextPresent("Bug");
    }

    public void workflowActivateWorkflow() {
        this.activateWorkflow("Copied Workflow");
        this.waitForSuccessfulWorkflowActivation("Copied Workflow");
        this.assertLinkPresent("activate_jira");
    }

    public void workflowUnassignWorkflowScheme() {
        TestWorkFlowSchemes.log("Workflow Scheme: Unassign a workflow scheme to an issue type");
        this.unassignWorkflowScheme("New Workflow Scheme", "Bug", "Copied Workflow");
        this.assertTextPresent("Edit Workflows for New Workflow Scheme");
        this.assertTextNotPresent("Copied Workflow");
    }

    public void workflowAssociateWorkflowSchemeToProject() {
        TestWorkFlowSchemes.log("Workflow Scheme; Associate a workflow scheme with a project");
        this.associateWorkFlowSchemeToProject("homosapien", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
        this.assertTextPresent("New Workflow Scheme");
    }

    public void workflowPerformAction(String issueKey) {
        TestWorkFlowSchemes.log("Perform workflow actions using the customised workflow/workflow scheme");
        this.gotoIssue(issueKey);
        this.clickLinkWithText("Resolve Issue");
        this.submit("Resolve");
        this.assertTextPresent("Resolved");
        this.clickLinkWithText("Approve Issue");
        this.setFormElement("customfield_" + this.customFieldId, "High");
        this.clickLinkWithText(TAB_NAME);
        this.setFormElement("customfield_" + this.customFieldId2, "Whale");
        this.submit("Approve Issue");
        this.assertTextPresent("Approved");
        this.clickLinkWithText("Reopen Issue");
        this.submit("Reopen Issue");
        this.assertTextPresent("Open");
    }
}

