/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestWorkFlowActions
extends JIRAWebTest {
    public static final String issueKey = "HSP-1";

    public TestWorkFlowActions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestWorkflowActions.xml");
    }

    public void testWorkFlowActions() {
        this.assignIssue(issueKey);
        this.resolveIssue(issueKey);
        this.closeAndReopenIssue(issueKey);
        this.closeIssueFromOpen(issueKey);
        this.deleteIssue(issueKey);
    }

    public void testInvalidWorkflowAction() throws Exception {
        this.gotoIssue(issueKey);
        this.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=3");
        this.assertTextPresent("Workflow Action Invalid");
        this.assertTextPresent("Reopen Issue");
        this.assertLinkPresent("refreshIssue");
    }

    public void testInvalidWorkflowActionDoesNotBreakThePage() throws Exception {
        this.restoreData("TestWorkflowActionsDodgyWorkflow.xml");
        this.gotoIssue("TST-1");
        this.assertTextPresent("Issue Details");
        this.assertTextPresent("Operations");
        this.assertTextNotPresent("Available Workflow Actions");
    }

    public void testWorkflowWithReturnUrl() {
        this.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=5&returnUrl=%2Fsecure%2FIssueNavigator.jspa%3Freset%3Dtrue%26jqlQuery%3Dproject%2B%253D%2BHSP%26selectedIssueId%3D10000");
        this.submit("Resolve");
        String currentUrl = this.getDialog().getResponse().getURL().toExternalForm();
        TestWorkFlowActions.assertTrue((String)"Did not get redirected to the issue navigator.", (boolean)currentUrl.endsWith("/secure/IssueNavigator.jspa?reset=true&jqlQuery=project+%3D+HSP&selectedIssueId=10000"));
    }

    public void assignIssue(String issueKey) {
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        try {
            this.addUserToGroup("bob", "jira-developers");
        }
        catch (Throwable t) {
            TestWorkFlowActions.log("bob is already part of jira-developers");
        }
        this.assignIssue(issueKey, "issue assigned", "Bob The Builder");
        this.removeUserFromGroup("bob", "jira-developers");
        this.assignIssue(issueKey, "issue assigned", "Administrator");
    }

    public void resolveIssue(String issueKey) {
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Open", (Object)"resolution", (Object)"Unresolved", (Object)"key", (Object)issueKey), null, issueKey);
        this.progressAndResolve("Resolve", issueKey, 5, "issue resolved");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed", (Object)"key", (Object)issueKey), null, issueKey);
    }

    public void closeAndReopenIssue(String issueKey) {
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Resolved", (Object)"resolution", (Object)"Fixed", (Object)"key", (Object)issueKey, (Object)"version", (Object)"New Version 1"), null, issueKey);
        this.progressWorkflow("Close Issue", issueKey, 701, "issue closed");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Closed", (Object)"key", (Object)issueKey), null, issueKey);
        this.progressWorkflow("Reopen Issue", issueKey, 3, "issue reopened");
        this.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"status", (Object)"Reopened", (Object)"key", (Object)issueKey), null, issueKey);
    }

    public void closeIssueFromOpen(String issueKey) {
        this.progressAndResolve("Close Issue", issueKey, 2, "issue resolved and closed");
        this.progressWorkflow("Reopen Issue", issueKey, 3, "issue reopened");
    }
}

