/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TestCustomWorkflow
extends JIRAWebTest {
    public TestCustomWorkflow(String name) {
        super(name);
    }

    public void testConditionsUseUnmodifiedIssue() {
        this.restoreBlankInstance();
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.addUserToGroup("bob", "jira-developers");
        this.copyWorkFlow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.assertTextPresent("Copied Workflow");
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy");
        this.assertTextPresent("Last modified on " + format.format(new Date()) + " by Administrator.");
        this.editTransitionScreen("Copied Workflow", "Start Progress", this.ASSIGN_FIELD_SCREEN_NAME);
        this.addWorkflowPostfunction("Copied Workflow", "In Progress", "Stop Progress", "com.atlassian.jira.plugin.system.workflow:assigntolead-function");
        this.enableWorkflow();
        String key = this.addIssue("homosapien", "HSP", "Bug", "Test Issue");
        this.clickLinkWithText("Start Progress");
        this.selectOption("assignee", "Bob The Builder");
        this.submit();
        TestCustomWorkflow.assertNotNull((Object)this.getDialog().getResponse().getURL());
        TestCustomWorkflow.assertTrue((boolean)this.getDialog().getResponse().getURL().getPath().endsWith("browse/" + key));
        this.assertTableRowsEqual("issuedetails", 2, new String[][]{{"Status:", "In Progress"}});
        this.assertTableRowsEqual("issuedetails", 4, new String[][]{{"Assignee:", "Bob The Builder"}});
        this.logout();
        this.login("bob", "bob_password");
        this.gotoIssue(key);
        this.clickLinkWithText("Stop Progress");
        this.assertTableRowsEqual("issuedetails", 2, new String[][]{{"Status:", "Open"}});
        this.assertTableRowsEqual("issuedetails", 4, new String[][]{{"Assignee:", "Administrator"}});
        this.logout();
        this.login("admin", "admin");
    }

    public void testLastModifiedByAnonymousUser() {
        this.restoreBlankInstance();
        this.grantGlobalPermission(0, "Anyone");
        this.logout();
        this.copyWorkFlow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.assertTextPresent("Copied Workflow");
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy");
        this.assertTextPresent("Last modified on " + format.format(new Date()) + " by an anonymous user.");
    }

    public void testLastModifiedWithFunnyCharacters() {
        this.restoreBlankInstance();
        this.addUser("</meta>user", "meta", "</meta> user lastname", "meta@example.com");
        this.addUserToGroup("</meta>user", "jira-administrators");
        this.logout();
        this.login("</meta>user", "meta");
        this.copyWorkFlow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        this.assertTextPresent("Copied Workflow");
        SimpleDateFormat format = new SimpleDateFormat("dd/MMM/yy");
        this.assertTextPresent("Last modified on " + format.format(new Date()) + " by &lt;/meta&gt; user lastname.");
    }

    private void enableWorkflow() {
        this.addWorkFlowScheme("New Workflow Scheme", "Test workflow scheme.");
        this.assignWorkflowScheme("New Workflow Scheme", "Bug", "Copied Workflow");
        this.associateWorkFlowSchemeToProject("homosapien", "New Workflow Scheme");
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }
}

