/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;

public class TestViewProfile
extends FuncTestCase {
    public static final String PROJECT_MONKEY = "monkey";
    public static final String PROJECT_HOMOSAP = "homosapien";
    public static final String ADMIN_PASSWORD = "admin";
    public static final String ADMIN_USERNAME = "admin";
    public static final String USERNAME_FRED = "fred";
    public static final String PASSWORD_FRED = "fred";

    protected void setUpTest() {
        this.administration.restoreData("TestViewProfile.xml");
    }

    public void testIssueNavigatorLinkEncoding() throws Exception {
        this.tester.gotoPage("/secure/ViewProfile.jspa?name=monkey%2Bman");
        this.text.assertTextNotPresent(this.tester.getDialog().getResponseText(), "=monkey+man");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "=monkey%2Bman");
    }

    public void testEmailVisibility() {
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Email:", "admin@example.com", "Groups:"});
        this.tester.assertLinkPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("emailVisibility", "hide");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Groups:"});
        this.tester.assertTextNotPresent("Email:");
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("emailVisibility", "mask");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Email:", "admin at example dot com", "Groups:"});
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("emailVisibility", "user");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Email:", "admin@example.com", "Groups:"});
        this.tester.assertLinkPresentWithText("admin@example.com");
    }

    public void testAllLinksShow() {
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_personalroadmap");
        this.tester.assertTextPresent(PROJECT_HOMOSAP);
        this.tester.assertTextPresent(PROJECT_MONKEY);
        this.tester.assertLinkNotPresent("view_personalroadmap");
        this.tester.clickLink("view_votes");
        this.tester.assertTextPresent("You are not currently voting for any issues.");
        this.tester.assertLinkNotPresent("view_votes");
        this.tester.clickLink("view_watches");
        this.tester.assertTextPresent("You are not currently watching any issues");
        this.tester.assertLinkNotPresent("view_watches");
        this.tester.clickLink("admin_user");
        this.tester.assertTextPresent("jira-administrators");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_project_roles");
        this.tester.assertTextPresent("View Project Roles for User: Administrator");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_change_password");
        this.tester.assertTextPresent("Enter your new password details below.");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.clickLink("view_dashboard_config");
        this.assertions.getURLAssertions().assertCurrentURLPathEndsWith("secure/ConfigurePortalPages!default.jspa");
        this.tester.clickLink("view_manage_filters");
        this.tester.assertTextPresent("Filters are issue searches that have been saved for re-use. This page allows you to manage all filters created by you");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_nav_columns");
        this.tester.assertTextPresent("The table below shows issue fields in");
        this.tester.assertLinkNotPresent("view_nav_columns");
        this.tester.clickLink("view_user_prefs");
        this.tester.assertTextPresent("These are your current user preferences");
        this.tester.assertLinkNotPresent("view_user_prefs");
        this.tester.clickLink("view_edit_prefs");
        this.tester.assertTextPresent("Update your preferences below to control how");
        this.tester.assertLinkNotPresent("view_edit_prefs");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile");
        this.tester.clickLink("view_edit_profile");
        this.tester.assertTextPresent("Update your details below");
        this.tester.assertLinkNotPresent("view_edit_profile");
    }

    public void testNotOwnProfile() {
        this.tester.gotoPage("/secure/ViewProfile.jspa?name=fred");
        this.tester.assertLinkPresent("view_profile");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertTextNotPresent("Reports");
        this.tester.assertLinkNotPresent("view_personalroadmap");
        this.tester.assertLinkNotPresent("view_votes");
        this.tester.assertLinkNotPresent("view_watches");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.assertLinkNotPresent("view_dashboard_config");
        this.tester.assertLinkNotPresent("view_manage_filters");
        this.tester.assertLinkNotPresent("view_nav_columns");
        this.tester.assertLinkNotPresent("view_user_prefs");
        this.tester.assertLinkNotPresent("view_edit_prefs");
        this.tester.assertLinkNotPresent("view_edit_profile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotLoggedIn() {
        try {
            this.navigation.logout();
            this.tester.gotoPage("/secure/ViewProfile.jspa?name=fred");
            this.tester.assertTextPresent("member my login on this");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    public void testVotingDisabled() {
        this.setGlobalOption("voting", "false");
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("view_votes");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("view_edit_profile");
        this.tester.assertLinkPresent("view_change_password");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("view_personalroadmap");
        this.tester.assertLinkPresent("view_watches");
        this.tester.assertLinkPresent("view_dashboard_config");
        this.tester.assertLinkPresent("view_manage_filters");
        this.tester.assertLinkPresent("view_nav_columns");
        this.tester.assertLinkPresent("view_user_prefs");
        this.tester.assertLinkPresent("view_edit_prefs");
    }

    public void testWatchingDisabled() {
        this.setGlobalOption("watching", "false");
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("view_watches");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("view_edit_profile");
        this.tester.assertLinkPresent("view_change_password");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("view_personalroadmap");
        this.tester.assertLinkPresent("view_votes");
        this.tester.assertLinkPresent("view_dashboard_config");
        this.tester.assertLinkPresent("view_manage_filters");
        this.tester.assertLinkPresent("view_nav_columns");
        this.tester.assertLinkPresent("view_user_prefs");
        this.tester.assertLinkPresent("view_edit_prefs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserNotAdmin() {
        try {
            this.navigation.login("fred", "fred");
            this.navigation.dashboard();
            this.tester.clickLink("view_profile");
            this.tester.assertLinkNotPresent("view_project_roles");
            this.tester.assertLinkNotPresent("admin_user");
            this.tester.assertLinkPresent("view_edit_profile");
            this.tester.assertLinkPresent("view_change_password");
            this.tester.assertLinkPresent("view_personalroadmap");
            this.tester.assertLinkPresent("view_votes");
            this.tester.assertLinkPresent("view_watches");
            this.tester.assertLinkPresent("view_dashboard_config");
            this.tester.assertLinkPresent("view_manage_filters");
            this.tester.assertLinkPresent("view_nav_columns");
            this.tester.assertLinkPresent("view_user_prefs");
            this.tester.assertLinkPresent("view_edit_prefs");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    public void testExternalUserManagementEnabled() {
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("view_edit_profile");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("view_personalroadmap");
        this.tester.assertLinkPresent("view_votes");
        this.tester.assertLinkPresent("view_watches");
        this.tester.assertLinkPresent("view_dashboard_config");
        this.tester.assertLinkPresent("view_manage_filters");
        this.tester.assertLinkPresent("view_nav_columns");
        this.tester.assertLinkPresent("view_user_prefs");
        this.tester.assertLinkPresent("view_edit_prefs");
    }

    public void testExternalPasswordManagementEnabled() {
        this.setGlobalOption("externalPM", "true");
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("view_edit_profile");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("view_personalroadmap");
        this.tester.assertLinkPresent("view_votes");
        this.tester.assertLinkPresent("view_watches");
        this.tester.assertLinkPresent("view_dashboard_config");
        this.tester.assertLinkPresent("view_manage_filters");
        this.tester.assertLinkPresent("view_nav_columns");
        this.tester.assertLinkPresent("view_user_prefs");
        this.tester.assertLinkPresent("view_edit_prefs");
    }

    public void testAssignedOpenIssuesReport() {
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile : Administrator");
        this.tester.assertTextNotPresent("Assigned Open Issues per project");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile : Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per project");
        this.navigation.issue().createIssue(PROJECT_HOMOSAP, "Bug", "First issue");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile : Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile : Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per project");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=admin");
        this.tester.assertTextPresent("User Profile : Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().createIssue(PROJECT_MONKEY, "Bug", "Second issue");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile : Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.assertLinkPresentWithText(PROJECT_MONKEY);
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{PROJECT_HOMOSAP, "1", PROJECT_MONKEY, "1"});
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile : Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per project");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=admin");
        this.tester.assertTextPresent("User Profile : Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.assertLinkPresentWithText(PROJECT_MONKEY);
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{PROJECT_HOMOSAP, "1", PROJECT_MONKEY, "1"});
    }

    private void setGlobalOption(String optionName, String value) {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.setFormElement("title", "jWebTest JIRA installation");
        this.tester.checkCheckbox(optionName, value);
        this.tester.submit("Update");
    }
}

