/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebLink;
import org.xml.sax.SAXException;

public class TestUsernameIsEncoded
extends JIRAWebTest {
    public TestUsernameIsEncoded(String name) {
        super(name);
    }

    public void testUsernamesAreHtmlEncoded() throws SAXException {
        String brokenUsername = "&quot;my &lt;input&gt; name";
        this.restoreData("TestUsernameIsEncoded.xml");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Is my broken-name really bad?");
        this.assertTextPresentBeforeText("Assignee:", "&quot;my &lt;input&gt; name");
        this.assertTextPresentBeforeText("Reporter:", "&quot;my &lt;input&gt; name");
        this.assertTextPresentBeforeText("field1:", "&quot;my &lt;input&gt; name");
        this.assertTextPresentBeforeText("field2:", "&quot;my &lt;input&gt; name");
        WebLink[] webLinks = this.getDialog().getResponse().getLinks();
        int count = 0;
        for (int i = 0; i < webLinks.length; ++i) {
            WebLink webLink = webLinks[i];
            if (webLink.asText().indexOf("\"my <input> name") < 0) continue;
            ++count;
        }
        TestUsernameIsEncoded.assertEquals((int)4, (int)count);
        this.clickLink("edit_issue");
        this.assertTextPresent("Use this form to edit the fields of this issue.");
        this.selectOption("assignee", "\"my <input> name");
        this.assertFormElementEquals("reporter", "broken");
        this.assertFormElementEquals("customfield_10000", "broken");
        this.assertFormElementEquals("customfield_10001", "admin, broken");
    }
}

