/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.apache.commons.lang.StringUtils;

public class TestUserProperties
extends JIRAWebTest {
    protected static final String USER_BOB_BROWSER = "/secure/admin/user/EditUserProperties.jspa?name=bob";
    protected static final String DELETE_PROP = "delete_testprop";

    public TestUserProperties(String name) {
        super(name);
    }

    public void testAddUserProperty() {
        this.restoreBlankInstance();
        this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
        this.assertTextPresent("Bob The Builder");
        this.clickLinkWithText("Edit Properties");
        this.setFormElement("key", "testprop");
        this.setFormElement("value", "testvalue");
        this.submit();
        this.assertTextPresent("Bob The Builder");
        this.assertTextPresentBeforeText("testprop", "testvalue");
    }

    public void testDuplicateProperty() {
        this.gotoPage(USER_BOB_BROWSER);
        this.assertTextPresent("Bob The Builder");
        this.setFormElement("key", "testprop");
        this.setFormElement("value", "testvalue2");
        this.submit();
        this.assertTextPresent("This 'key' already exists for the user.");
    }

    public void testDeleteUserProperty() {
        this.gotoPage(USER_BOB_BROWSER);
        this.clickLink(DELETE_PROP);
        this.assertTextPresent("Delete Property: testprop");
        this.submit("Delete");
        this.assertTextPresent("has no properties");
    }

    public void testInvalidCharactersForProperty() {
        this.gotoPage(USER_BOB_BROWSER);
        this.setFormElement("key", "testprop!");
        this.setFormElement("value", "testvalue");
        this.submit();
        this.assertTextPresent("The 'key' can only contain alphanumeric characters");
    }

    public void testKeyExceedsCharacterLengthCheck() {
        this.gotoPage(USER_BOB_BROWSER);
        this.setFormElement("key", StringUtils.repeat((String)"x", (int)251));
        this.setFormElement("value", "testvalue");
        this.submit();
        this.assertTextPresent("The 'key' length must be less than 200 characters");
    }

    public void testValueExceedCharacterLengthCheck() {
        this.gotoPage(USER_BOB_BROWSER);
        this.setFormElement("key", "testproperty");
        this.setFormElement("value", StringUtils.repeat((String)"x", (int)251));
        this.submit();
        this.assertTextPresent("The 'value' length must be less than 250 characters");
    }

    public void testKeyIsEmptyCheck() {
        this.gotoPage(USER_BOB_BROWSER);
        this.setFormElement("key", "");
        this.setFormElement("value", "testvalue");
        this.submit();
        this.assertTextPresent("The 'key' cannot be empty");
    }

    public void testValueIsEmptyCheck() {
        this.gotoPage(USER_BOB_BROWSER);
        this.setFormElement("key", "testproperty");
        this.setFormElement("value", "");
        this.submit();
        this.assertTextPresent("The 'value' cannot be empty");
    }

    public void testValueIsHtmlEncoded() {
        this.gotoPage(USER_BOB_BROWSER);
        this.setFormElement("key", "testproperty");
        this.setFormElement("value", "<blink>Annoying</blink>");
        this.submit();
        this.assertTextPresent("&lt;blink&gt;Annoying&lt;/blink&gt;");
        this.assertTextNotPresent("<blink>Annoying</blink>");
    }
}

