/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestUserNavigationBarWebFragment
extends JIRAWebTest {
    private static final String IMG_PRINTABLE_VIEW = "/images/icons/print.gif";
    private static final String IMG_HELP = "/images/icons/help_blue.gif";
    private static final String BACK_TO_PREVIOUS_VIEW = "<< Back to previous view";
    private static final String ISSUE_SUMMARY = "test printable";

    public TestUserNavigationBarWebFragment(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestWebFragment.xml");
    }

    public void tearDown() {
        this.login("admin", "admin");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testUserNavigationBarWebFragment() {
        this._testLinkVisibilityWhileLoggedIn();
        this._testLinkVisibilityWhileNotLoggedIn();
    }

    public void testPrintableViewLink() {
        this.login("admin", "admin");
        String issueKey = this.addIssue("homosapien", "HSP", "Bug", ISSUE_SUMMARY);
        this.gotoIssue(issueKey);
        this.assertTextPresent("Issue Details");
        this.assertLinkPresentWithText(issueKey);
        this.gotoPage("/browse/HSP-1?decorator=printable");
        this.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.assertTextPresent("[" + issueKey + "]");
        this.assertLinkPresentWithText(ISSUE_SUMMARY);
        this.gotoPage("/secure/IssueNavigator.jspa?reset=true&sorter/field=issuekey&sorter/order=DESC");
        this.assertTextPresent("Issue Navigator");
        this.gotoPage("/secure/IssueNavigator.jspa?decorator=printable&reset=true&amp;sorter/field=issuekey&amp;sorter/order=DESC");
        this.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.assertTextPresent("Issue Navigator");
        this.assertTextPresent(issueKey);
        this.assertTextPresent(ISSUE_SUMMARY);
        this.gotoPage("/secure/views/securitybreach.jsp");
        this.assertTextPresent("ACCESS DENIED");
        this.gotoPage("/secure/views/securitybreach.jsp?decorator=printable");
        this.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.assertTextPresent("ACCESS DENIED");
    }

    private void _testLinkVisibilityWhileLoggedIn() {
        this.login("admin", "admin");
        this.assertLinkNotPresentWithText("Log In");
        this.assertLinkPresentWithText("Administrator");
        this.assertLinkPresentWithText("Online Help");
        this.assertLinkPresentWithText("Profile");
        this.assertLinkPresentWithText("About JIRA");
        this.assertLinkPresentWithText("Profile");
        this.assertLinkPresentWithText("Log Out");
    }

    private void _testLinkVisibilityWhileNotLoggedIn() {
        this.logout();
        this.beginAt("/secure/Dashboard.jspa");
        this.assertLinkPresentWithText("Log In");
        this.assertLinkNotPresentWithText("Log Out");
        XPathLocator userProfileLink = new XPathLocator(this.tester, "//div[@id='header-top']//ul/li[1]/a");
        TestUserNavigationBarWebFragment.assertNotSame((Object)"Administrator", (Object)userProfileLink.getText());
    }
}

