/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestUserGroupPicker
extends JIRAWebTest {
    private static final String USER_FIELD_NAME = "User field";
    private static final String SUMMARY_FRED = "Issue with user picker fred";
    private static final String SUMMARY_BOTH = "Issue with user picker admin, fred";
    private static final String SUMMARY_ADMIN = "Issue with user picker admin";
    private static final String FRED_USERNAME = "fred";
    private static final String FRED_FULLNAME = "Fred Normal";
    private static final String THREE_ISSUES = "all 3 issue(s)";
    private static final String TWO_ISSUES = "all 2 issue(s)";
    private static final String USER_FIELD_ID = "customfield_10000";

    public TestUserGroupPicker(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        this.grantGlobalPermission(33, "jira-users");
    }

    public void tearDown() {
        this.removeGlobalPermission(33, "jira-users");
        super.tearDown();
    }

    public void testUserGroupPicker() throws Exception {
        this._testCustomFieldSetup();
        this._testCreateIssueWithField();
        this._testSearchingWithField();
    }

    private void _testCustomFieldSetup() {
        TestUserGroupPicker.logSection("Adding Mutli user field and Group searcher");
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.submit("nextBtn");
        this.setFormElement("fieldName", USER_FIELD_NAME);
        this.selectOption("searcher", "User Picker & Group Searcher");
        this.submit("nextBtn");
        this.checkCheckbox("associatedScreens", "1");
        this.submit("Update");
    }

    private void _testCreateIssueWithField() {
        TestUserGroupPicker.logSection("Creating issues with Mutli user field and Group searcher");
        this._testCreateIssueWithUser("admin", "Administrator");
        this._testCreateIssueWithUser(FRED_USERNAME, FRED_FULLNAME);
        this._createIssueWithUser("admin, fred");
        this.assertTextPresentBeforeText(USER_FIELD_NAME, "Administrator");
        this.assertTextPresentBeforeText(USER_FIELD_NAME, FRED_FULLNAME);
        this.assertTextPresentBeforeText("Administrator", FRED_FULLNAME);
    }

    private void _testSearchingWithField() {
        TestUserGroupPicker.logSection("Searching with Group searcher");
        this.displayAllIssues();
        this.assertTextPresent(THREE_ISSUES);
        this.selectOption("customfield_10000Select", "Current User");
        this.submit("show");
        this.assertTextPresent(TWO_ISSUES);
        this.selectOption("customfield_10000Select", "Specify User");
        this.setFormElement(USER_FIELD_ID, "admin");
        this.submit("show");
        this.assertTextPresent(TWO_ISSUES);
        this.assertTextPresent(SUMMARY_BOTH);
        this.assertTextPresent(SUMMARY_ADMIN);
        this.assertTextNotPresent(SUMMARY_FRED);
        this.setFormElement(USER_FIELD_ID, FRED_USERNAME);
        this.submit("show");
        this.assertTextPresent(SUMMARY_FRED);
        this.assertTextPresent(TWO_ISSUES);
        this.assertTextPresent(SUMMARY_BOTH);
        this.selectOption("customfield_10000Select", "Specify Group");
        this.setFormElement(USER_FIELD_ID, "jira-administrators");
        this.submit("show");
        this.assertTextPresent(SUMMARY_BOTH);
        this.assertTextPresent(SUMMARY_ADMIN);
        this.assertTextNotPresent(SUMMARY_FRED);
    }

    private void _testCreateIssueWithUser(String username, String fullName) {
        this._createIssueWithUser(username);
        this.assertTextPresentBeforeText(USER_FIELD_NAME, fullName);
        this.assertTextPresent("Issue with user picker " + username);
    }

    private void _createIssueWithUser(String username) {
        this.clickLink("create_link");
        this.selectOption("pid", "homosapien");
        this.selectOption("issuetype", "Bug");
        this.submit("Next>>");
        this.setFormElement("summary", "Issue with user picker " + username);
        this.assertTextPresent(USER_FIELD_NAME);
        this.setFormElement(USER_FIELD_ID, username);
        this.submit("Create");
    }
}

