/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.meterware.httpunit.WebLink;
import java.util.List;
import org.xml.sax.SAXException;

public class TestUserFormat
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testAnonymous() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("comment_issue");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.assertions.assertProfileLinkPresent("comment_10000_header_admin", "Administrator");
        this.navigation.gotoAdminSection("permission_schemes");
        this.tester.clickLink("0_edit");
        this.tester.clickLink("add_perm_10");
        this.tester.checkCheckbox("type", "group");
        this.tester.selectOption("group", "Anyone");
        this.tester.submit(" Add ");
        this.tester.clickLink("add_perm_15");
        this.tester.checkCheckbox("type", "group");
        this.tester.selectOption("group", "Anyone");
        this.tester.submit(" Add ");
        this.navigation.logout();
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("comment_issue");
        this.tester.setFormElement("comment", "My second anoymous test comment");
        this.tester.submit();
        this.tester.assertLinkNotPresent("Anonymous");
        this.tester.assertTextPresent("Anonymous added a comment");
    }

    public void testWorkflowInfoBox() {
        this.administration.restoreData("TestDraftWorkflow.xml");
        this.administration.usersAndGroups().addUserToGroup("fred", "jira-administrators");
        this.navigation.gotoAdminSection("workflows");
        this.tester.clickLink("createDraft_Workflow1");
        this.navigation.logout();
        this.navigation.login("fred");
        this.tester.gotoPage("/secure/admin/workflows/ViewWorkflowSteps.jspa?workflowMode=draft&workflowName=Workflow1");
        this.assertions.assertProfileLinkPresent("draft_workflow_edited_admin", "Administrator");
        this.tester.clickLink("view_live_workflow");
        this.assertions.assertProfileLinkPresent("workflow_edited_admin", "Administrator");
    }

    public void testCommentPanel() {
        this.tester.gotoPage("/secure/admin/AddPermission!default.jspa?permissions=34&schemeId=0");
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("comment_issue");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.tester.clickLink("edit_comment_10000");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.tester.setFormElement("comment", "My first test comment edited...");
        try {
            Thread.sleep(1001L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tester.submit();
        this.tester.clickLink("edit_comment_10000");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("comment_summary_updated_admin", "Administrator");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("delete_comment_10000");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("comment_summary_updated_admin", "Administrator");
    }

    public void testProjectSummary() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.assertions.assertProfileLinkPresent("project_summary_admin", "Administrator");
    }

    public void testBrowseProjectsTable() {
        this.tester.gotoPage("/secure/BrowseProjects.jspa");
        this.tester.assertTextPresent("Browse Projects");
        this.assertions.assertProfileLinkPresent("project_HSP_table_admin", "Administrator");
    }

    public void testViewProjects() {
        this.navigation.gotoAdminSection("view_projects");
        this.assertions.assertProfileLinkPresent("view_HSP_projects_admin", "Administrator");
    }

    public void testBrowseComponent() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("edit_comp_New Component 1");
        this.tester.setFormElement("name", "New Component 1");
        this.tester.setFormElement("componentLead", "fred");
        this.tester.submit("Update");
        this.tester.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.plugin.system.project:components-panel");
        this.assertions.assertProfileLinkPresent("component_lead_fred", "Fred Normal");
        this.tester.gotoPage("/browse/HSP/component/10000");
        this.assertions.assertProfileLinkPresent("component_summary_fred", "Fred Normal");
    }

    public void testBrowseProject() {
        this.tester.gotoPage("/browse/HSP");
        this.assertions.assertProfileLinkPresent("project_summary_admin", "Administrator");
    }

    public void testViewVoters() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLinkWithText("Vote for it");
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLinkWithText("Voting");
        this.assertions.assertProfileLinkPresent("voter_link_fred", "Fred Normal");
    }

    public void testFullProfile() {
        this.tester.gotoPage("/secure/BrowsePersonalProject.jspa");
        this.tester.assertTextPresent("Project");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/ChangePassword!default.jspa");
        this.tester.assertTextPresent("Change Password");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.setFormElement("current", "admin");
        this.tester.setFormElement("password", "test");
        this.tester.setFormElement("confirm", "test");
        this.tester.submit();
        this.tester.assertTextPresent("Change Password Success");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/ChangePassword!default.jspa");
        this.tester.setFormElement("current", "test");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.submit();
        this.tester.gotoPage("/secure/AddPortalPage!default.jspa");
        this.tester.assertTextPresent("Create New Dashboard");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/ConfigurePortalPages!default.jspa");
        this.tester.assertTextPresent("Manage Dashboard");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/EditPortalPage!default.jspa?pageId=10000");
        this.tester.assertTextPresent("Edit and Share Dashboard");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/RestoreDefaultDashboard!default.jspa?destination=manageportal");
        this.tester.assertTextPresent("Restore System Dashboard");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/EditProfile!default.jspa");
        this.tester.assertTextPresent("Edit Profile");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/UpdateUserPreferences!default.jspa");
        this.tester.assertTextPresent("Update User Preferences");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/UserVotes!default.jspa");
        this.tester.assertTextPresent("Voted Issues");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/UserWatches!default.jspa");
        this.tester.assertTextPresent("Watched Issues");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/ViewProfile.jspa");
        this.tester.assertTextPresent("User Profile : Administrator");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/ViewUserIssueColumns!default.jspa");
        this.tester.assertTextPresent("Issue Navigator Columns");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/ViewUserPreferences.jspa");
        this.tester.assertTextPresent("Your User Preferences");
        this.assertFullProfilePresent("admin", "Administrator", "admin@example.com", EasyList.build((Object)"jira-administrators", (Object)"jira-users", (Object)"jira-developers"));
        this.tester.gotoPage("/secure/EditProfile!default.jspa");
        this.tester.setFormElement("fullName", "Administrator \"<script>alert('owned')</script>\"");
        this.tester.setFormElement("email", "\"<script>alert('owned')</script>\"@localhost");
        this.tester.submit("Update");
        this.tester.gotoPage("/secure/ViewProfile.jspa");
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("User Profile : Administrator &quot;&lt;script&gt;alert('owned')&lt;/script&gt;&quot;") != -1 ? 1 : 0) != 0);
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("User Profile : Administrator \"<script>alert('owned')</script>\"") == -1 ? 1 : 0) != 0);
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("mailto:&quot;&lt;script&gt;alert('owned')&lt;/script&gt;&quot;") != -1 ? 1 : 0) != 0);
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("mailto:\"<script>alert('owned')</script>\"") == -1 ? 1 : 0) != 0);
    }

    public void testIssueSummary() {
        this.tester.gotoPage("/secure/admin/AddPermission!default.jspa?permissions=17&schemeId=0");
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("assign_issue");
        this.tester.selectOption("assignee", "Fred Normal");
        this.tester.submit("Assign");
        this.assertions.assertProfileLinkPresent("issue_summary_assignee_fred", "Fred Normal");
        this.assertions.assertProfileLinkPresent("issue_summary_reporter_admin", "Administrator");
    }

    public void testColumnView() {
        this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertions.assertProfileLinkPresent("assignee_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("reporter_admin", "Administrator");
    }

    public void testColumnViewUnAssigned() throws SAXException {
        this.tester.clickLink("admin_link");
        this.tester.clickLink("general_configuration");
        this.tester.clickLinkWithText("Edit Configuration");
        this.tester.checkCheckbox("allowUnassigned", "true");
        this.tester.submit("Update");
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "Unassigned bug");
        this.tester.selectOption("assignee", "Unassigned");
        this.tester.submit("Create");
        this.tester.clickLink("find_link");
        this.tester.submit("show");
        this.navigation.issueNavigator().displayAllIssues();
        WebLink link = this.tester.getDialog().getResponse().getLinkWithID("assignee_admin");
        TestUserFormat.assertNull((Object)link);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='issuetable']/tr[2]/td[4]"), "Unassigned");
        this.assertions.assertProfileLinkPresent("reporter_admin", "Administrator");
    }

    public void testUserSearcherView() throws SAXException {
        this.tester.clickLink("find_link");
        String linkText = "Current User";
        this.tester.selectOption("reporterSelect", "Current User");
        this.tester.submit("hide");
        String id = "searcher-profile-link";
        WebLink link = this.tester.getDialog().getResponse().getLinkWithID("searcher-profile-link");
        TestUserFormat.assertNotNull((String)"No link with id 'searcher-profile-link' present.", (Object)link);
        TestUserFormat.assertEquals((String)"Link text for link with id 'searcher-profile-link' does not match 'Current User'.", (String)"Current User", (String)link.asText());
        this.tester.clickLink("searcher-profile-link");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "User Profile : Administrator");
    }

    public void testIssueWatchers() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLinkWithText("Watch it");
        this.tester.clickLinkWithText("Watching");
        this.assertions.assertProfileLinkPresent("watcher_link_admin", "Administrator");
    }

    public void testCustomFields() {
        this.navigation.gotoAdminSection("view_custom_fields");
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Single User");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Multi User");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit_issue");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.setFormElement("customfield_10001", "admin, fred");
        this.tester.submit("Update");
        this.assertions.assertProfileLinkPresent("user_cf_fred", "Fred Normal");
        this.assertions.assertProfileLinkPresent("multiuser_cf_fred", "Fred Normal");
        this.assertions.assertProfileLinkPresent("multiuser_cf_admin", "Administrator");
    }

    public void testActionHeaders() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.submit("Activate");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("comment_issue");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "1h");
        this.tester.submit("Log");
        this.tester.clickLink("edit_issue");
        this.tester.setFormElement("summary", "First test bug really");
        this.tester.submit("Update");
        this.tester.gotoPage("/browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.assertions.assertProfileLinkPresent("comment_10000_header_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("ch_header_10000_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("ch_header_10001_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("worklog_10000_header_admin", "Administrator");
    }

    public void testDeveloperWorkloadReport() {
        this.navigation.gotoAdminSection("timetracking");
        this.tester.submit("Activate");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "1h");
        this.tester.submit("Log");
        this.navigation.runReport(10000L, "com.atlassian.jira.plugin.system.reports:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.submit("Next");
        this.assertions.assertProfileLinkPresent("dev_wl_report_admin", "Administrator");
    }

    public void testDifferentUsersInIterator() {
        this.administration.restoreData("TestFormatUserDifferentUsersInIterator.xml");
        this.navigation.gotoAdminSection("view_projects");
        this.assertions.assertProfileLinkPresent("view_HSP_projects_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("view_MKY_projects_fred", "Fred Normal");
        this.tester.gotoPage("/secure/BrowseProjects.jspa");
        this.assertions.assertProfileLinkPresent("project_HSP_table_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("project_MKY_table_fred", "Fred Normal");
        this.tester.gotoPage("/secure/ViewVoters!default.jspa?id=10001");
        this.assertions.assertProfileLinkPresent("voter_link_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("voter_link_fred", "Fred Normal");
    }

    private void assertFullProfilePresent(String username, String fullName, String email, List groups) {
        TableLocator tableLocator = new TableLocator(this.tester, "full_profile");
        this.text.assertTextSequence(tableLocator, new String[]{"Username", username, "Full Name", fullName, "Email", email, "Groups"});
        for (String groupName : groups) {
            this.text.assertTextPresent(new TableCellLocator(this.tester, "full_profile", 3, 0), groupName);
        }
        this.text.assertTextSequence(new TableLocator(this.tester, "full_profile_reports"), new String[]{"Personal Roadmap", "Your Votes", "Your Watches"});
        this.text.assertTextSequence(new TableLocator(this.tester, "full_profile_ops"), new String[]{"Administer User", "View Project Roles", "Change Password", "Manage Dashboard", "Manage Filters", "Navigator Columns", "View Preferences", "Edit Preferences", "View Your Profile", "Edit Profile"});
    }
}

