/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;

public class TestShareUserDefault
extends FuncTestCase {
    protected void setUpTest() {
        this.administration.restoreData("TestShareUserDefaults.xml");
    }

    public void tearDownTest() {
        this.administration.restoreBlankInstance();
    }

    public void testDefaults() {
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection("user_defaults");
        TableCellLocator locator = new TableCellLocator(this.tester, "view_user_defaults", 4, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 4, 1);
        this.text.assertTextPresent(locator, "Private");
        this.tester.clickLinkWithText("Edit default values");
        locator = new TableCellLocator(this.tester, "edit_user_defaults", 4, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "edit_user_defaults", 4, 1);
        this.text.assertTextPresent(locator, "Public");
        this.tester.assertRadioOptionPresent("sharePublic", "true");
        this.tester.assertRadioOptionPresent("sharePublic", "false");
        this.tester.assertRadioOptionSelected("sharePublic", "true");
        this.tester.gotoPage("secure/ViewUserPreferences.jspa");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "By default, NO other users will be able to see your filters and dashboards.");
        this.tester.clickLinkWithText("Edit Preferences");
        locator = new TableCellLocator(this.tester, "edit_user_preferences", 6, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        this.tester.assertRadioOptionPresent("shareDefault", "true");
        this.tester.assertRadioOptionPresent("shareDefault", "false");
        this.tester.assertRadioOptionSelected("shareDefault", "true");
        this.navigation.gotoAdminSection("user_defaults");
        this.tester.clickLinkWithText("Edit default values");
        this.tester.assertRadioOptionPresent("sharePublic", "true");
        this.tester.assertRadioOptionPresent("sharePublic", "false");
        this.tester.checkCheckbox("sharePublic", "false");
        this.tester.submit("Update");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 4, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 4, 1);
        this.text.assertTextPresent(locator, "Public");
        this.tester.clickLinkWithText("Edit default values");
        locator = new TableCellLocator(this.tester, "edit_user_defaults", 4, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "edit_user_defaults", 4, 1);
        this.text.assertTextPresent(locator, "Private");
        this.tester.assertRadioOptionPresent("sharePublic", "true");
        this.tester.assertRadioOptionPresent("sharePublic", "false");
        this.tester.assertRadioOptionSelected("sharePublic", "false");
        this.tester.gotoPage("secure/ViewUserPreferences.jspa");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "By default, ALL users will be able to see shared filters and dashboards.");
        this.tester.clickLinkWithText("Edit Preferences");
        locator = new TableCellLocator(this.tester, "edit_user_preferences", 6, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        this.tester.assertRadioOptionPresent("shareDefault", "true");
        this.tester.assertRadioOptionPresent("shareDefault", "false");
        this.tester.assertRadioOptionSelected("shareDefault", "false");
        this.tester.checkCheckbox("shareDefault", "true");
        this.tester.submit("Update");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "By default, NO other users will be able to see your filters and dashboards.");
        this.tester.clickLinkWithText("Edit Preferences");
        locator = new TableCellLocator(this.tester, "edit_user_preferences", 6, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        this.tester.assertRadioOptionPresent("shareDefault", "true");
        this.tester.assertRadioOptionPresent("shareDefault", "false");
        this.tester.assertRadioOptionSelected("shareDefault", "true");
        this.navigation.gotoAdminSection("user_defaults");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 4, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 4, 1);
        this.text.assertTextPresent(locator, "Public");
        this.tester.clickLinkWithText("Edit default values");
        locator = new TableCellLocator(this.tester, "edit_user_defaults", 4, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "edit_user_defaults", 4, 1);
        this.text.assertTextPresent(locator, "Public");
        this.tester.assertRadioOptionPresent("sharePublic", "true");
        this.tester.assertRadioOptionPresent("sharePublic", "false");
        this.tester.assertRadioOptionSelected("sharePublic", "false");
    }
}

