/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestGroupSelectorPermissions
extends JIRAWebTest {
    public void setUp() {
        super.setUp();
        this.restoreData("GroupSelectorPermissions.xml");
        this.enableAttachments();
    }

    public TestGroupSelectorPermissions(String name) {
        super(name);
    }

    public void testWorkflowPermissions() {
        TestGroupSelectorPermissions.logSection("Testing group permission selector");
        TestGroupSelectorPermissions.log("Testing that 'GroupRadio' selection (helpdesk) can comment, can't attach");
        this.login("helpdesk", "helpdesk");
        this.gotoIssue("NP-1");
        this.assertLinkPresent("comment_issue");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
        TestGroupSelectorPermissions.log("Check that webadmin users cannot do anything");
        this.login("webadmin", "webadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment_issue");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
        TestGroupSelectorPermissions.log("Check that unixadmin users cannot do anything");
        this.login("unixadmin", "unixadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment_issue");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
        TestGroupSelectorPermissions.log("Testing that regular users can't comment, can't attach");
        this.login("test", "test");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment_issue");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
        this.login("dba", "dba");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("comment_issue");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
        TestGroupSelectorPermissions.log("Editing fields: setting GroupRadio (comment perm) to WebAdmin, and 'Assigned Groups' (attach perm) to helpdesk");
        this.gotoIssue("NP-1");
        this.clickLink("edit_issue");
        this.assertOptionValuesEqual("customfield_10010", new String[]{"-1", "DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.assertOptionValuesEqual("customfield_10030", new String[]{"-1", "DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.assertOptionValuesEqual("customfield_10040", new String[]{"DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.assertOptionValuesEqual("customfield_10041", new String[]{"-1", "DBA User Group", "Helpdesk Group", "UNIX Admin Group", "Web Admin Group"});
        this.selectOption("customfield_10010", "Helpdesk Group");
        this.checkCheckbox("customfield_10030", "Web Admin Group");
        this.setFormElement("customfield_10040", "DBA User Group");
        this.selectOption("customfield_10041", "UNIX Admin Group");
        this.submit();
        this.assertTextPresentBeforeText("Assigned Groups:", "Helpdesk Group");
        this.assertTextPresentBeforeText("GroupRadio:", "Web Admin Group");
        this.assertTextPresentBeforeText("Multi Checkboxes:", "DBA User Group");
        this.assertTextPresentBeforeText("Select List:", "UNIX Admin Group");
        TestGroupSelectorPermissions.log("Testing that 'GroupRadio' selection (now webadmin) can comment, can't attach");
        this.login("webadmin", "webadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkPresent("comment_issue");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
        TestGroupSelectorPermissions.log("Testing that helpdesk can no longer comment, but can attach");
        this.login("helpdesk", "helpdesk");
        this.gotoIssue("NP-1");
        this.assertLinkPresent("attach_file");
        this.assertLinkNotPresent("comment_issue");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
        TestGroupSelectorPermissions.log("Check that DBA can delete issues");
        this.login("dba", "dba");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkNotPresent("comment_issue");
        this.assertLinkNotPresent("delete_issue");
        this.assertLinkPresent("move_issue");
        TestGroupSelectorPermissions.log("Check that Unix admin can move issues");
        this.login("unixadmin", "unixadmin");
        this.gotoIssue("NP-1");
        this.assertLinkNotPresent("attach_file");
        this.assertLinkNotPresent("comment_issue");
        this.assertLinkPresent("delete_issue");
        this.assertLinkNotPresent("move_issue");
    }
}

