/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestExternalUserManagement
extends JIRAWebTest {
    private static final String USERNAME_JOHN = "john";
    private static final String NAME_JOHN_WAYNE = "John Wayne";
    private static final int GROUP_COL = 4;

    public TestExternalUserManagement(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    public void testAddUser() {
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.assertLinkPresent("add_user");
        this.clickLink("add_user");
        this.setFormElement("username", USERNAME_JOHN);
        this.setFormElement("password", "some_pass");
        this.setFormElement("confirm", "some_pass");
        this.setFormElement("fullname", NAME_JOHN_WAYNE);
        this.setFormElement("email", "john@atlassian.com");
        this.submit("Create");
        this.assertTextPresent("User: John Wayne");
        this.toggleExternalUserManagement(true);
        this.assertLinkNotPresent("add_user");
        this.gotoPage("/secure/admin/user/AddUser!default.jspa");
        this.submit("Create");
        this.assertTextPresent("Cannot add user, as external user management is enabled. Contact your administrator.");
    }

    public void testEditUserGroups() throws SAXException {
        this.gotoAdmin();
        this.clickLink("user_browser");
        WebTable userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 4, "jira-developers"));
        this.assertTextPresent("jira-developers");
        this.assertLinkPresentWithText("Groups");
        this.clickLink("editgroups_admin");
        this.selectMultiOptionByValue("groupsToLeave", "jira-developers");
        this.submit("leave");
        userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellDoesNotHaveText(userTable, 1, 4, "jira-developers"));
        this.toggleExternalUserManagement(true);
        this.gotoAdmin();
        this.clickLink("user_browser");
        userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 4, "jira-users"));
        this.assertLinkNotPresent("editgroups_admin");
        this.gotoPage("/secure/admin/user/EditUserGroups!default.jspa?returnUrl=UserBrowser.jspa&name=admin");
        this.selectMultiOptionByValue("groupsToLeave", "jira-users");
        this.submit("leave");
        this.assertTextPresent("Cannot edit group memberships, as external user management is enabled. Contact your administrator.");
        this.clickLink("user_browser");
        userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 4, "jira-users"));
    }

    public void testBulkEditUserGroups() throws SAXException {
        this.gotoAdmin();
        this.clickLink("group_browser");
        WebTable userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 1, "1"));
        this.clickLink("edit_members_of_jira-administrators");
        this.setFormElement("usersToAssignStr", "fred");
        this.submit("assign");
        this.clickLink("group_browser");
        userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 1, "2"));
        this.toggleExternalUserManagement(true);
        this.gotoAdmin();
        this.clickLink("group_browser");
        userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 2, 1, "1"));
        this.assertLinkNotPresent("edit_members_of_jira-developers");
        this.gotoPage("/secure/admin/user/BulkEditUserGroups!default.jspa?selectedGroupsStr=jira-developers");
        this.setFormElement("usersToAssignStr", "fred");
        this.submit("assign");
        this.assertTextPresent("Cannot edit group memberships, as external user management is enabled. Contact your administrator.");
        this.gotoPage("/secure/admin/user/BulkEditUserGroups!default.jspa?selectedGroupsStr=jira-developers");
        this.selectOption("usersToUnassign", "admin");
        this.submit("unassign");
        this.assertTextPresent("Cannot edit group memberships, as external user management is enabled. Contact your administrator.");
        this.clickLink("group_browser");
        userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 2, 1, "1"));
    }

    public void testGroupEditPage() throws SAXException {
        this.gotoAdmin();
        this.clickLink("group_browser");
        this.assertTextPresent("You can also add and remove groups from here.");
        this.assertTablePresent("add_group");
        this.assertLinkPresent("bulk_edit_groups");
        WebTable groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)4, (int)groupBrowserTable.getColumnCount());
        TestExternalUserManagement.assertEquals((int)4, (int)groupBrowserTable.getRowCount());
        this.setFormElement("addName", "test-new-group");
        this.submit("add_group");
        this.assertTextPresent("test-new-group");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)5, (int)groupBrowserTable.getRowCount());
        this.toggleExternalUserManagement(true);
        this.clickLink("group_browser");
        this.assertTextNotPresent("You can also add and remove groups from here.");
        this.assertTableNotPresent("add_group");
        this.assertLinkNotPresent("bulk_edit_groups");
        this.gotoPage("/secure/admin/user/GroupBrowser.jspa?addName=another-test-group");
        this.assertTextPresent("Cannot add groups, as external user management is enabled. Contact your administrator.");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getColumnCount());
        TestExternalUserManagement.assertEquals((int)5, (int)groupBrowserTable.getRowCount());
    }

    public void testDeleteGroup() throws SAXException {
        this.gotoAdmin();
        this.clickLink("group_browser");
        WebTable groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)4, (int)groupBrowserTable.getRowCount());
        this.assertLinkPresent("del_jira-users");
        this.clickLink("del_jira-users");
        this.submit("Delete");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getRowCount());
        this.toggleExternalUserManagement(true);
        this.gotoAdmin();
        this.clickLink("group_browser");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getRowCount());
        this.assertLinkNotPresent("del_jira-developers");
        this.gotoPage("/secure/admin/user/DeleteGroup!default.jspa?name=jira-developers");
        this.submit("Delete");
        this.assertTextPresent("Cannot delete group, as external user management is enabled. Contact your administrator.");
        this.gotoAdmin();
        this.clickLink("group_browser");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getRowCount());
    }

    public void testDeleteUser() throws SAXException {
        this.gotoAdmin();
        this.addUser("bob", "bobspassword", "Bob Brown", "bob@atlassian.com");
        this.clickLink("user_browser");
        WebTable userBrowserTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertEquals((int)4, (int)userBrowserTable.getRowCount());
        this.assertLinkPresent("deleteuser_link_fred");
        this.clickLink("deleteuser_link_fred");
        this.submit("Delete");
        userBrowserTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)userBrowserTable.getRowCount());
        this.toggleExternalUserManagement(true);
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.assertLinkNotPresent("deleteuser_link_bob");
        this.gotoPage("/secure/admin/user/DeleteUser!default.jspa?returnUrl=UserBrowser.jspa&name=bob");
        this.submit("Delete");
        this.assertTextPresent("Cannot delete user, as external user management is enabled. Contact your administrator.");
        this.gotoAdmin();
        this.clickLink("user_browser");
        userBrowserTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)userBrowserTable.getRowCount());
    }

    public void testGroupNames() {
        this.gotoPage("/secure/admin/groupnames.jsp");
        this.assertTextPresent("Here you can specify a 'display' name for each group.");
        this.toggleExternalUserManagement(true);
        this.gotoPage("/secure/admin/groupnames.jsp");
        this.assertTextNotPresent("Here you can specify a 'display' name for each group.");
        this.assertTextPresent("External user management is enabled.");
    }

    public void testSystemInfo() {
        this.gotoPage("/secure/admin/jira/ViewSystemInfo.jspa");
        this.assertTextPresent("External user management");
        this.assertTextPresentAfterText("OFF", "External user management");
        this.assertTextNotPresent("External user management is enabled. Showing records from local database tables only.");
        this.toggleExternalUserManagement(true);
        this.gotoPage("/secure/admin/jira/ViewSystemInfo.jspa");
        this.assertTextPresent("External user management");
        this.assertTextPresentAfterText("ON", "External user management");
        this.assertTextPresent("External user management is enabled. Showing records from local database tables only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSignupLinkOnLoginPage() {
        try {
            this.toggleExternalUserManagement(true);
            this.logout();
            this.clickLinkWithText("Log in again.");
            this.assertLinkNotPresent("signup");
        }
        finally {
            this.login("admin", "admin");
        }
    }
}

