/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.assertions.TextAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestEditUserDetails
extends JIRAWebTest {
    public TestEditUserDetails(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCannotSetSysAdminPassword() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("root");
            this.assertLinkNotPresentWithText("Set Password");
            this.assertTextPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.gotoPage("/secure/admin/user/SetPassword.jspa?name=root&password=root&confirm=root");
            this.assertTextPresent("Error");
            this.assertTextPresent("Must be a System Administrator to reset a System Administrator's password.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCannotEditSysAdminDetails() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("root");
            this.assertLinkNotPresentWithText("Edit Details");
            this.assertTextPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.gotoPage("/secure/admin/user/EditUser.jspa?editName=root&fullName=rooty&email=root@example.com");
            this.assertTextPresent("Error");
            this.assertTextPresent("Only System Administrators can edit other System Administrators details.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminCanEditSysAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.login("root");
            this.addUser("anothersysadmin");
            this.addUserToGroup("anothersysadmin", "jira-sys-admins");
            this.navigateToUser("anothersysadmin");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Edit Details");
            this.setFormElement("fullName", "Rooty");
            this.submit("Update");
            this.assertTextPresent("Rooty");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminCanSetSysAdminPassword() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.login("root");
            this.addUser("anothersysadmin", "something", "Another User", "another@example.com");
            this.addUserToGroup("anothersysadmin", "jira-sys-admins");
            this.navigateToUser("anothersysadmin");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Set Password");
            this.setFormElement("password", "another");
            this.setFormElement("confirm", "another");
            this.submit("Update");
            this.login("anothersysadmin", "another");
            this.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanEditNormalUser() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("fred");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Edit Details");
            this.setFormElement("fullName", "Freddy Kruger");
            this.submit("Update");
            this.assertTextPresent("Freddy Kruger");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCanSetNormalUsersPassword() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("fred");
            this.assertTextNotPresent("This user is a System Administrator. Your permission to modify the user is restricted because you do not have System Administrator permissions.");
            this.clickLinkWithText("Set Password");
            this.setFormElement("password", "another");
            this.setFormElement("confirm", "another");
            this.submit("Update");
            this.login("fred", "another");
            this.assertTextNotPresent("Sorry, your username and password are incorrect - please try again.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAutocompleteIsOff() {
        try {
            TextAssertionsImpl text = new TextAssertionsImpl();
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("fred");
            this.clickLinkWithText("Set Password");
            XPathLocator xpathPassword = new XPathLocator(this.tester, "//*[@name=\"password\"]");
            text.assertRegexMatch(xpathPassword.getHTML(), "autocomplete=[ ]*\"off\"[ ]*");
            XPathLocator xpathConfirm = new XPathLocator(this.tester, "//*[@name=\"confirm\"]");
            text.assertRegexMatch(xpathConfirm.getHTML(), "autocomplete=[ ]*\"off\"[ ]*");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }
}

