/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestDeleteUserAndPermissions
extends JIRAWebTest {
    public void setUp() {
        super.setUp();
        this.restoreData("TestDeleteUserAndPermissions.xml");
        this.grantGlobalPermission(33, "jira-users");
    }

    public void tearDown() {
        this.removeGlobalPermission(33, "jira-users");
        super.tearDown();
    }

    public TestDeleteUserAndPermissions(String name) {
        super(name);
    }

    public void testDeleteUserNotPossibleWithAssignedIssue() {
        TestDeleteUserAndPermissions.logSection("Test Delete User Not Possible With Assigned Issue");
        TestDeleteUserAndPermissions.log("Making sure that you can't see the other issue");
        this.clickLink("find_link");
        this.submit("show");
        this.assertTextPresent("Seen issue");
        this.assertTextNotPresent("Unseen issue");
        TestDeleteUserAndPermissions.log("Ensuring that you're unable to delete fred and that the correct number of issues are shown");
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("fred");
        this.clickLink("deleteuser_link");
        this.assertTextPresent("This user cannot be deleted at this time because there are issues assigned to them");
        this.assertTextPresentBeforeText("Assigned Issues", "1");
        this.assertTextPresentBeforeText("Reported Issues", "2");
        this.assertTextPresentBeforeText("1", "Reported Issues");
    }

    public void testDeletUserRemoveFromPermissionAndNotificationSchemes() {
        TestDeleteUserAndPermissions.logSection("Test delete user with shared filters");
        this.assertFredHasPermissionsAssigned();
        this.gotoAdmin();
        this.clickLink("security_schemes");
        this.clickLinkWithText("Test Issue Security Scheme");
        this.assertTextPresent("fred");
        this.gotoAdmin();
        this.clickLink("notification_schemes");
        this.clickLinkWithText("Default Notification Scheme");
        this.assertTextPresent("fred");
        this.assertLinkPresent("del_10050");
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLink("10000_edit");
        this.clickLink("add_perm_12");
        this.checkCheckbox("type", "user");
        this.setFormElement("user", "admin");
        this.submit(" Add ");
        this.clickLink("add_perm_10");
        this.checkCheckbox("type", "user");
        this.setFormElement("user", "admin");
        this.submit(" Add ");
        this.clickLink("add_perm_30");
        this.checkCheckbox("type", "user");
        this.setFormElement("user", "admin");
        this.submit(" Add ");
        this.gotoIssue("HSP-1");
        this.clickLink("edit_issue");
        this.setFormElement("reporter", "admin");
        this.submit("Update");
        this.gotoIssue("MKY-1");
        this.clickLink("edit_issue");
        this.setFormElement("reporter", "admin");
        this.selectOption("assignee", "Administrator");
        this.submit("Update");
        TestDeleteUserAndPermissions.log("Deleting Fred");
        this.gotoAdmin();
        this.clickLink("user_browser");
        this.clickLink("fred");
        this.clickLink("deleteuser_link");
        this.assertTextPresent("Delete User");
        this.submit("Delete");
        this.assertTextPresent("User Browser");
        this.assertTextNotPresent("fred");
        this.assertFredHasNoPermissionsAssigned();
        this.gotoAdmin();
        this.clickLink("security_schemes");
        this.clickLinkWithText("Test Issue Security Scheme");
        this.assertTextNotPresent("fred");
        this.gotoAdmin();
        this.clickLink("notification_schemes");
        this.clickLinkWithText("Default Notification Scheme");
        this.assertTextNotPresent("fred");
        this.assertLinkNotPresent("del_10050");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCannotDeleteSysadmin() {
        this.restoreBlankInstance();
        try {
            this.addUser("sysadmin2");
            this.addUserToGroup("sysadmin2", "jira-administrators");
            this.addUser("nonsystemadmin");
            this.createGroup("nonsystemadmins");
            this.addUserToGroup("nonsystemadmin", "nonsystemadmins");
            this.grantGlobalPermission(0, "nonsystemadmins");
            this.login("nonsystemadmin");
            this.gotoAdmin();
            this.clickLink("user_browser");
            this.assertLinkNotPresent("deleteuser_link_sysadmin2");
            this.gotoPage("/secure/admin/user/DeleteUser!default.jspa?returnUrl=UserBrowser.jspa&name=sysadmin2");
            this.assertTextPresent("As a user with JIRA Administrators permission, you cannot delete users with JIRA System Administrators permission.");
            this.assertTextNotPresent("submit");
            this.gotoPage("/secure/admin/user/DeleteUser.jspa?returnUrl=UserBrowser.jspa&name=sysadmin2&confirm=true");
            this.assertTextPresent("As a user with JIRA Administrators permission, you cannot delete users with JIRA System Administrators permission.");
            this.gotoAdmin();
            this.clickLink("user_browser");
            this.assertLinkPresent("sysadmin2");
        }
        finally {
            this.login("admin");
        }
    }

    private void assertFredHasPermissionsAssigned() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextNotPresent("fred");
        this.assertTextNotPresent("Fred");
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Fred's scheme");
        this.assertLinkPresent("del_perm_23_fred");
        this.assertLinkPresent("del_perm_10_fred");
        this.assertLinkPresent("del_perm_11_fred");
        this.assertLinkPresent("del_perm_12_fred");
        this.assertLinkPresent("del_perm_28_fred");
        this.assertLinkPresent("del_perm_25_fred");
        this.assertLinkPresent("del_perm_17_fred");
        this.assertLinkPresent("del_perm_14_fred");
        this.assertLinkPresent("del_perm_18_fred");
        this.assertLinkPresent("del_perm_30_fred");
        this.assertLinkPresent("del_perm_15_fred");
        this.assertLinkPresent("del_perm_36_fred");
        this.assertLinkPresent("del_perm_16_fred");
        this.assertLinkPresent("del_perm_20_fred");
        this.assertLinkPresent("del_perm_21_fred");
        this.assertLinkPresent("del_perm_19_fred");
        this.assertLinkPresent("del_perm_38_fred");
        this.assertLinkPresent("del_perm_29_fred");
        this.assertLinkPresent("del_perm_31_fred");
        this.assertLinkPresent("del_perm_32_fred");
        this.assertLinkPresent("del_perm_26_fred");
    }

    private void assertFredHasNoPermissionsAssigned() {
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextNotPresent("fred");
        this.assertTextNotPresent("Fred");
        this.gotoAdmin();
        this.clickLink("permission_schemes");
        this.clickLinkWithText("Fred's scheme");
        this.assertTextNotPresent("fred");
        for (int i = 0; i < 100; ++i) {
            this.assertLinkNotPresent("del_perm_" + i + "_fred");
        }
    }
}

