/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestWorkLogTabPanelVisibility
extends JIRAWebTest {
    private static final String BUG = "HSP-1";
    private static final String NEW_FEATURE = "HSP-2";

    public TestWorkLogTabPanelVisibility(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestWorkLogVisibility.xml");
    }

    public void testWorkLogTabPanelVisibility() {
        this.gotoIssue(BUG);
        this.assertTabLinkPresent();
        this.gotoIssue(NEW_FEATURE);
        this.assertTabLinkNotPresent();
        this.flipVisibilityInFieldConfigEnterprise();
        this.gotoIssue(BUG);
        this.assertTabLinkNotPresent();
        this.gotoIssue(NEW_FEATURE);
        this.assertTabLinkPresent();
    }

    public void testDirectUrlAccessTakesVisibilityIntoAccount() {
        this.assertTabPresent(BUG);
        this.assertTabNotPresent(NEW_FEATURE);
        this.flipVisibilityInFieldConfigEnterprise();
        this.assertTabNotPresent(BUG);
        this.assertTabPresent(NEW_FEATURE);
    }

    private void flipVisibilityInFieldConfigEnterprise() {
        this.gotoAdmin();
        this.clickLink("field_configuration");
        this.clickLink("configure-Default Field Configuration");
        this.clickLink("show_15");
        this.clickLink("view_fieldlayouts");
        this.clickLink("configure-Bug Field Configuration");
        this.clickLink("hide_15");
    }

    private void assertTabPresent(String issueKey) {
        this.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.assertTextSequence(new String[]{"Time Worked", BUG.equals(issueKey) ? "2 hours" : "1 hour", "No comment"});
    }

    private void assertTabNotPresent(String issueKey) {
        this.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.assertTextNotPresent("Time Worked");
        this.assertTextNotPresent(BUG.equals(issueKey) ? "2 hours" : "1 hour");
        this.assertTextNotPresent("No comment");
    }

    private void assertTabLinkNotPresent() {
        this.assertLinkNotPresentWithText("Work Log");
    }

    private void assertTabLinkPresent() {
        this.assertLinkPresentWithText("Work Log");
    }
}

