/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestWorkLogTabPanel
extends JIRAWebTest {
    private static final String ADMIN_TIME_WORKED = "4h 30m";
    private static final String ADMIN_TIME_PERFORMED = "18/Jun/07 05:39 PM";
    private static final String ADMIN_COMMENT = "Admin's worklog comment.";
    private static final String ADMIN = "admin";
    private static final String FRED_TIME_WORKED = "3d";
    private static final String FRED_TIME_PERFORMED = "20/Jun/07 05:39 PM";
    private static final String FRED_COMMENT = "Fred's worklog comment.";
    private static final String FRED = "fred";

    public TestWorkLogTabPanel(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestLogWork.xml");
        this.grantPermission(FRED, 20);
        this.addTestWorklogs();
    }

    public void testViewIssuePermissionOnly() {
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        TestWorkLogTabPanel.assertFalse((boolean)this.isAdminWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isAdminWorklogDeleteLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    public void testEditOwnWorklogsPermission() {
        this.grantPermission(ADMIN, 40);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        TestWorkLogTabPanel.assertTrue((boolean)this.isAdminWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isAdminWorklogDeleteLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    public void testEditAllWorklogsPermission() {
        this.grantPermission(ADMIN, 41);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        TestWorkLogTabPanel.assertTrue((boolean)this.isAdminWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isAdminWorklogDeleteLinkPresent());
        TestWorkLogTabPanel.assertTrue((boolean)this.isFredsWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    public void testDeleteOwnWorklogsPermission() {
        this.grantPermission(ADMIN, 42);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        TestWorkLogTabPanel.assertFalse((boolean)this.isAdminWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertTrue((boolean)this.isAdminWorklogDeleteLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    public void testDeleteAllWorklogsPermission() {
        this.grantPermission(ADMIN, 43);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        TestWorkLogTabPanel.assertFalse((boolean)this.isAdminWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertTrue((boolean)this.isAdminWorklogDeleteLinkPresent());
        TestWorkLogTabPanel.assertFalse((boolean)this.isFredsWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertTrue((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    public void testFullWorklogPermissions() {
        this.grantPermission(ADMIN, 41);
        this.grantPermission(ADMIN, 43);
        this.gotoHSP1WorklogTab();
        this.assertWorklogsPresent();
        TestWorkLogTabPanel.assertTrue((boolean)this.isAdminWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertTrue((boolean)this.isAdminWorklogDeleteLinkPresent());
        TestWorkLogTabPanel.assertTrue((boolean)this.isFredsWorklogEditLinkPresent());
        TestWorkLogTabPanel.assertTrue((boolean)this.isFredsWorklogDeleteLinkPresent());
    }

    private void assertWorklogsPresent() {
        this.assertTextSequence(new String[]{"Administrator", "Time Worked:", "4 hours, 30 minutes", ADMIN_COMMENT, "Fred Normal", "Time Worked:", "3 days", FRED_COMMENT});
    }

    private void gotoHSP1WorklogTab() {
        this.gotoIssue("HSP-1");
        this.clickLinkWithText("Work Log");
    }

    private boolean isAdminWorklogEditLinkPresent() {
        TestWorkLogTabPanel.log("checking if the edit link for Admin's worklog is present");
        return this.getDialog().isTextInResponse("/secure/UpdateWorklog!default.jspa?id=10000&worklogId=10000");
    }

    private boolean isAdminWorklogDeleteLinkPresent() {
        TestWorkLogTabPanel.log("checking if the delete link for Admin's worklog is present");
        return this.getDialog().isTextInResponse("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
    }

    private boolean isFredsWorklogEditLinkPresent() {
        TestWorkLogTabPanel.log("checking if the edit link for Fred's worklog is present");
        return this.getDialog().isTextInResponse("/secure/UpdateWorklog!default.jspa?id=10000&worklogId=10001");
    }

    private boolean isFredsWorklogDeleteLinkPresent() {
        TestWorkLogTabPanel.log("checking if the edit link for Fred's worklog is present");
        return this.getDialog().isTextInResponse("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10001");
    }

    private void addTestWorklogs() {
        TestWorkLogTabPanel.log("Adding worklog as admin");
        this.gotoIssue("HSP-1");
        this.clickLink("log_work");
        this.setFormElement("timeLogged", ADMIN_TIME_WORKED);
        this.setFormElement("startDate", ADMIN_TIME_PERFORMED);
        this.getDialog().setFormParameter("comment", ADMIN_COMMENT);
        this.submit("Log");
        this.logout();
        TestWorkLogTabPanel.log("Adding worklog as fred");
        this.login(FRED, FRED);
        this.gotoIssue("HSP-1");
        this.clickLink("log_work");
        this.setFormElement("timeLogged", FRED_TIME_WORKED);
        this.setFormElement("startDate", FRED_TIME_PERFORMED);
        this.getDialog().setFormParameter("comment", FRED_COMMENT);
        this.submit("Log");
        this.logout();
        TestWorkLogTabPanel.log("Logging back in as admin");
        this.login(ADMIN, ADMIN);
    }

    private void grantPermission(String username, int permission) {
        this.grantPermissionToUserInEnterprise(permission, username);
    }
}

