/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestWorkLogOperationVisibility
extends JIRAWebTest {
    private static final String BUG = "HSP-1";
    private static final String NEW_FEATURE = "HSP-2";

    public TestWorkLogOperationVisibility(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestWorkLogVisibility.xml");
    }

    public void testWorkLogOperationVisibility() throws Exception {
        this.gotoIssue(BUG);
        this.assertLogWorkOperationPresent();
        this.gotoIssue(NEW_FEATURE);
        this.assertLogWorkOperationNotPresent();
        this.flipVisibilityInFieldConfigEnterprise();
        this.gotoIssue(BUG);
        this.assertLogWorkOperationNotPresent();
        this.gotoIssue(NEW_FEATURE);
        this.assertLogWorkOperationPresent();
    }

    public void testCreateWorkActionVisibility() throws Exception {
        this.gotoIssue(BUG);
        this.assertLogWorkOperationPresent();
        this.clickLink("log_work");
        this.assertWorkLogFormPresent();
        this.gotoPage("/secure/CreateWorklog!default.jspa?id=10010");
        this.assertWorkLogFromNotPresent();
        this.gotoPage("/secure/CreateWorklog.jspa?id=10010&timeLogged=1h&startDate=26/Sep/07%2005:41%20PM");
        this.assertWorkLogFromNotPresent();
        this.flipVisibilityInFieldConfigEnterprise();
        this.gotoPage("/secure/CreateWorklog!default.jspa?id=10000");
        this.assertWorkLogFromNotPresent();
        this.gotoPage("/secure/CreateWorklog.jspa?id=10000&timeLogged=1h&startDate=26/Sep/07%2005:41%20PM");
        this.assertWorkLogFromNotPresent();
        this.gotoIssue(NEW_FEATURE);
        this.assertLogWorkOperationPresent();
        this.clickLink("log_work");
        this.assertWorkLogFormPresent();
    }

    private void flipVisibilityInFieldConfigEnterprise() {
        this.gotoAdmin();
        this.clickLink("field_configuration");
        this.clickLink("configure-Default Field Configuration");
        this.clickLink("show_15");
        this.clickLink("view_fieldlayouts");
        this.clickLink("configure-Bug Field Configuration");
        this.clickLink("hide_15");
    }

    private void assertWorkLogFormPresent() {
        this.assertTextPresent("This form allows you to log work that you have done on this issue.");
        this.assertTextNotPresent("ACCESS DENIED");
        this.assertTextNotPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    private void assertWorkLogFromNotPresent() {
        this.assertTextNotPresent("This form allows you to log work that you have done on this issue.");
        this.assertTextSequence(new String[]{"ACCESS DENIED", "It seems that you have tried to perform an operation which you are not permitted to perform."});
    }

    private void assertLogWorkOperationNotPresent() {
        this.assertLinkNotPresent("log_work");
        this.assertLinkNotPresentWithText("Log work");
    }

    private void assertLogWorkOperationPresent() {
        this.assertLinkPresent("log_work");
        this.assertLinkPresentWithText("Log work");
    }
}

