/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestUpdateWorklog
extends JIRAWebTest {
    private static final String ADMIN_COMMENT = "Admin does some work.";
    private static final String HSP_1 = "HSP-1";
    private static final String HSP_2 = "HSP-2";

    public TestUpdateWorklog(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestUpdateWorklog.xml");
    }

    public void testWorklogDoesNotExist() {
        this.gotoPage("/secure/UpdateWorklog!default.jspa?worklogId=99999&id=10000");
        this.assertTextPresent("Cannot retrieve worklog with id='99999' for update.");
    }

    public void testWorklogNoPermToUpdate() {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("del_perm_40_");
        this.submit("Delete");
        this.clickLink("del_perm_41_");
        this.submit("Delete");
        this.gotoPage("/secure/UpdateWorklog!default.jspa?worklogId=10000&id=10000");
        this.assertTextPresent("ACCESS DENIED");
    }

    public void testMandatoryFields() {
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "");
        this.setFormElement("startDate", "");
        this.setFormElement("newEstimate", "");
        this.checkCheckbox("adjustEstimate", "new");
        this.submit();
        this.assertTextPresent("You must indicate the time spent working.");
        this.assertTextPresent("You must specify a date on which the work occurred.");
        this.assertTextPresent("You must supply a valid new estimate.");
    }

    public void testInvalidFormattedDurationFields() {
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "16 Candles");
        this.setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.setFormElement("newEstimate", "Six Days, Seven Nights");
        this.checkCheckbox("adjustEstimate", "new");
        this.submit();
        this.assertTextPresent("Invalid time duration entered.");
        this.assertTextPresent("Invalid new estimate entered.");
    }

    public void testInvalidTimeSpentZero() {
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "0");
        this.setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.submit();
        this.assertTextPresent("Time Spent can not be zero.");
    }

    public void testInvalidStartDateField() {
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "4h");
        this.setFormElement("startDate", "The Day After Tomorrow");
        this.checkCheckbox("adjustEstimate", "leave");
        this.submit();
        this.assertTextPresent("You must specify a date on which the work occurred.");
    }

    public void testUpdateTimeSpentDecreasingAutoAdjust() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10002");
        this.setFormElement("timeLogged", "1d");
        this.submit("Log");
        this.assertTextSequence(new String[]{"3 weeks, 3 days", "4 days"});
        this.assertTableCellHasText("worklog_details_10002", 0, 1, "1 day");
    }

    public void testUpdateTimeSpentIncreasingAutoAdjust() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "8d");
        this.submit("Log");
        this.assertTextSequence(new String[]{"2 weeks, 1 day", "1 week, 6 days"});
        this.assertTableCellHasText("worklog_details_10000", 0, 1, "1 week, 1 day");
    }

    public void testUpdateTimeSpentStopsAtZeroAutoAdjust() {
        this.gotoIssue(HSP_2);
        this.assertTextSequence(new String[]{"3 days", "2 weeks"});
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10010");
        this.setFormElement("timeLogged", "3w");
        this.submit("Log");
        this.assertTextSequence(new String[]{"0 minutes", "3 weeks"});
        this.assertTableCellHasText("worklog_details_10010", 0, 1, "3 weeks");
    }

    public void testUpdateStartDateOrderChanges() {
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.assertTextSequence(new String[]{"worklog_details_10000", "worklog_details_10001", "worklog_details_10002"});
        this.clickLink("edit_worklog_10002");
        this.setFormElement("startDate", "1/Jun/06 12:00 PM");
        this.submit("Log");
        this.assertTextSequence(new String[]{"worklog_details_10002", "worklog_details_10000", "worklog_details_10001"});
        this.assertTextPresent("1/Jun/06 12:00 PM");
    }

    public void testUpdateTimeSpentIncreasingNoRemainingEstimateChange() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "8d");
        this.checkCheckbox("adjustEstimate", "leave");
        this.submit("Log");
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "1 week, 6 days"});
        this.assertTableCellHasText("worklog_details_10000", 0, 1, "1 week, 1 day");
    }

    public void testUpdateTimeSpentIncreasingClobberRemainingEstimate() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "8d");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "8w");
        this.submit("Log");
        this.assertTextSequence(new String[]{"8 weeks", "1 week, 6 days"});
        this.assertTableCellHasText("worklog_details_10000", 0, 1, "1 week, 1 day");
    }

    public void testUpdateComment() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("comment", "This is an updated worklog comment");
        this.submit("Log");
        this.assertTableCellHasText("worklog_details_10000", 1, 0, "This is an updated worklog comment");
    }

    public void testUpdateTimeSpentAutoAdjustCreatesChangeHistory() throws SAXException {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "8d");
        this.submit("Log");
        this.assertTextSequence(new String[]{"2 weeks, 1 day", "1 week, 6 days"});
        this.clickLinkWithText("Change History");
        boolean timeSpentCalled = false;
        boolean remainingEstitmateCalled = false;
        WebTable table = this.getDialog().getResponse().getTableWithID("changehistory_10020");
        if (table.getCellAsText(0, 0).indexOf("Time Spent") != -1) {
            this.assertChangeHistoryForTimeSpent(0);
            timeSpentCalled = true;
        } else if (table.getCellAsText(0, 0).indexOf("Remaining Estimate") != -1) {
            this.assertChangeHistoryForRemaininigEstimate(0);
            remainingEstitmateCalled = true;
        }
        if (table.getCellAsText(1, 0).indexOf("Time Spent") != -1) {
            this.assertChangeHistoryForTimeSpent(1);
            timeSpentCalled = true;
        } else if (table.getCellAsText(1, 0).indexOf("Remaining Estimate") != -1) {
            this.assertChangeHistoryForRemaininigEstimate(1);
            remainingEstitmateCalled = true;
        }
        TestUpdateWorklog.assertTrue((boolean)timeSpentCalled);
        TestUpdateWorklog.assertTrue((boolean)remainingEstitmateCalled);
    }

    public void testUpdateWorklogSecurityLevels() {
        TestUpdateWorklog.assertTrue((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        TestUpdateWorklog.assertTrue((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "1d");
        this.selectOption("commentLevel", "jira-developers");
        this.submit("Log");
        TestUpdateWorklog.assertTrue((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
        TestUpdateWorklog.assertFalse((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        this.gotoIssue(HSP_1);
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "1d");
        this.selectOption("commentLevel", "Specialist");
        this.submit("Log");
        TestUpdateWorklog.assertFalse((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
        TestUpdateWorklog.assertTrue((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        this.gotoIssue(HSP_1);
        this.clickLink("edit_worklog_10000");
        this.setFormElement("timeLogged", "1d");
        this.selectOption("commentLevel", "jira-users");
        this.submit("Log");
        TestUpdateWorklog.assertTrue((boolean)this.canUserSeeComment("mel", ADMIN_COMMENT));
        TestUpdateWorklog.assertTrue((boolean)this.canUserSeeComment("fred", ADMIN_COMMENT));
    }

    public void testManuallyAdjustEstimateOptionNotAvailable() {
        this.gotoIssue(HSP_1);
        this.tester.clickLinkWithText("Work Log");
        this.tester.clickLink("edit_worklog_10001");
        this.assertTextPresent("id=\"auto_adjust_estimate_id\"");
        this.assertTextNotPresent("id=\"manual_adjust_estimate_id\"");
    }

    private void assertChangeHistoryForRemaininigEstimate(int row) {
        this.assertTableCellHasText("changehistory_10020", row, 1, "3 weeks, 1 day");
        this.assertTableCellHasText("changehistory_10020", row, 2, "2 weeks, 1 day");
    }

    private void assertChangeHistoryForTimeSpent(int row) {
        this.assertTableCellHasText("changehistory_10020", row, 1, "6 day");
        this.assertTableCellHasText("changehistory_10020", row, 2, "1 week, 6 days");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canUserSeeComment(String user, String comment) {
        try {
            this.logout();
            this.login(user, user);
            TestUpdateWorklog.log("Checking if " + user + " can see comment '" + comment + "'");
            this.gotoIssue(HSP_1);
            this.clickWorkLogLink();
            boolean bl = this.getDialog().isTextInResponse(comment);
            return bl;
        }
        finally {
            this.login("admin", "admin");
        }
    }

    private void clickWorkLogLink() {
        if (this.hasLinkWithText("Work Log")) {
            this.clickLinkWithText("Work Log");
        }
    }
}

