/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestTimeTrackingAggregates
extends JIRAWebTest {
    public TestTimeTrackingAggregates(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestTimeTrackingAggregates.xml");
    }

    public void tearDown() {
        this.login("admin", "admin");
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testAllTest() throws SAXException {
        this._testNoValues();
        this._testNoOrigValue();
        this._testNoTimeSpent();
        this._testAllValuesTotalGreaterThanOrigNoSubs();
        this._testNoValuesWithSubstasks();
        this._testWithNoValueSubTaskAsStartingPoint();
        this._testWithValuesWithSubstasksWithValues();
        this._testWithRemainingZeroValue();
        this._testPermissionedSubtasks();
        this._testCantSeeSubTasks();
    }

    public void testTimeTrackingDisabled() {
        this.deactivateTimeTracking();
        this.gotoIssue("HSP-1");
        this.assertTextNotPresent("Time Tracking:");
        this.assertTextNotPresent("Original Estimate:");
        this.assertTextNotPresent("subtasks_resolution_percentage");
        this.gotoIssue("HSP-6");
        this.assertTextNotPresent("Time Tracking:");
        this.assertTextNotPresent("Original Estimate:");
        this.assertTextPresent("subtasks_resolution_percentage");
    }

    public void testTimeTrackingHidden() {
        this.setHiddenFields("Time Tracking");
        this.gotoIssue("HSP-1");
        this.assertTextNotPresent("tt_single_text_orig");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        this.gotoIssue("HSP-6");
        this.assertTextNotPresent("tt_single_text_orig");
        this.assertTextNotPresent("tt_aggregate_text_orig");
    }

    public void _testNoValues() throws SAXException {
        this.gotoIssue("HSP-2");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Not Specified"));
    }

    public void _testNoOrigValue() throws SAXException {
        this.gotoIssue("HSP-3");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "Not Specified"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "2 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "2 days"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testNoTimeSpent() throws SAXException {
        this.gotoIssue("HSP-4");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "3 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "3 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "Not Specified"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void _testAllValuesTotalGreaterThanOrigNoSubs() throws SAXException {
        this.gotoIssue("HSP-5");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "1 week, 1 day"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "4 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "4 days"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:75%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:25%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testNoValuesWithSubstasks() throws SAXException {
        this.gotoIssue("HSP-6");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("subtasks_resolution_percentage");
        this.assertTextPresent("Issue & Sub-Tasks");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Not Specified"));
        table = this.getDialog().getResponse().getTableWithID("tt_aggregate_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Not Specified"));
    }

    public void _testWithNoValueSubTaskAsStartingPoint() throws SAXException {
        this.gotoIssue("HSP-7");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Not Specified"));
    }

    public void _testWithValuesWithSubstasksWithNoValues() throws SAXException {
        this.gotoIssue("HSP-9");
        this.assertTextPresent("Time Tracking:");
        this.assertTextPresent("tt_aggregate_text_orig");
        this.assertTextPresent("Issue & Sub-Tasks");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_aggregate_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "3 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "3 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "1 day"));
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:75%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:75%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:25%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:75%");
        table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "Not Specified"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "Not Specified"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "Not Specified"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.assertTextPresent("tt_graph_outer_HSP-10_100%");
        this.assertTextPresent("tt_percent_HSP-10_50%");
        this.assertTextPresent("tt_graph_inner_HSP-10_100%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-10", 0, "width:50%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-10", 1, "width:50%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-10", 0, "width:50%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-10", 2, "width:50%");
        this.assertTextPresent("tt_graph_outer_HSP-11_100%");
        this.assertTextPresent("tt_percent_HSP-11_0%");
        this.assertTextPresent("tt_graph_inner_HSP-11_100%");
        this.assertGraphElementAttribute("tt_graph_orig_HSP-11", 0, "width:100%");
        this.assertGraphElementAttribute("tt_graph_progress_HSP-11", 0, "width:100%");
    }

    public void _testWithAllValueSubTaskAsStartingPoint() throws SAXException {
        this.gotoIssue("HSP-10");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "1 day"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "1 day"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "1 day"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:50%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:50%");
    }

    public void _testWithValuesWithSubstasksWithValues() throws SAXException {
        this.gotoIssue("HSP-12");
        this.assertTextPresent("Time Tracking:");
        this.assertTextPresent("tt_aggregate_text_orig");
        this.assertTextPresent("Issue & Sub-Tasks");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_aggregate_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "1 week, 1 day"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "4 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "1 week"));
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:66%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:34%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:55%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:45%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:55%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:45%");
        table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "4 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "4 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "1 day"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:80%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 1, "width:80%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:20%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 1, "width:80%");
        this.assertTextPresent("tt_dpb_graph_outer_HSP-13_100%");
        this.assertTextPresent("tt_dpb_percent_HSP-13_100%");
        this.assertTextPresent("tt_dpb_graph_inner_HSP-13_100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-13", 0, "width:57%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-13", 1, "width:43%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-13", 0, "width:100%");
        this.assertTextPresent("tt_dpb_graph_outer_HSP-14_100%");
        this.assertTextPresent("tt_dpb_percent_HSP-14_100%");
        this.assertTextPresent("tt_dpb_graph_inner_HSP-14_14%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-14", 0, "width:0%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-14", 0, "width:100%");
    }

    public void _testWithRemainingZeroValue() throws SAXException {
        this.gotoIssue("HSP-13");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "2 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "0 minutes"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "3 days, 4 hours"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:57%");
        this.assertGraphElementAttribute("tt_single_graph_orig", 1, "width:43%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void _testPermissionedSubtasks() throws SAXException {
        this.login("fred", "fred");
        this.gotoIssue("HSP-15");
        this.assertTextPresent("Time Tracking:");
        this.assertTextPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "2 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "2 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "Not Specified"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        table = this.getDialog().getResponse().getTableWithID("tt_aggregate_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "3 days, 2 hours"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "3 days, 2 hours"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "Not Specified"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        this.login("admin", "admin");
        this.gotoIssue("HSP-15");
        this.assertTextPresent("Time Tracking:");
        this.assertTextPresent("tt_aggregate_text_orig");
        table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "2 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "2 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "Not Specified"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
        table = this.getDialog().getResponse().getTableWithID("tt_aggregate_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "4 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "4 days"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "1 day"));
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 0, "width:80%");
        this.assertGraphElementAttribute("tt_aggregate_graph_orig", 1, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 0, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_remain", 1, "width:80%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 0, "width:20%");
        this.assertGraphElementAttribute("tt_aggregate_graph_spent", 1, "width:80%");
        this.assertTextPresent("tt_dpb_graph_outer_HSP-16_100%");
        this.assertTextPresent("tt_dpb_percent_HSP-16_33%");
        this.assertTextPresent("tt_dpb_graph_inner_HSP-16_100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 2, "width:67%");
        this.assertTextNotPresent("tt_dpb_graph_outer_HSP-17_100%");
        this.assertTextNotPresent("tt_dpb_percent_HSP-17_");
        this.assertTextNotPresent("tt_dpb_graph_inner_HSP-17_100%");
        this.assertTextNotPresent("tt_dpb_graph_orig_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_dpb_graph_progress_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_dpb_graph_orig_HSP-18");
    }

    public void _testCantSeeSubTasks() throws SAXException {
        this.gotoIssue("HSP-19");
        this.assertTextPresent("Time Tracking:");
        this.assertTextNotPresent("tt_aggregate_text_orig");
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 0, 1, "1 day"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "1 day"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTrackingAggregates.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "Not Specified"));
        this.assertGraphElementAttribute("tt_single_graph_orig", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_remain", 0, "width:100%");
        this.assertGraphElementAttribute("tt_single_graph_spent", 0, "width:100%");
    }

    public void testProgressNavigableField() throws SAXException {
        this.displayAllIssues();
        this.assertTextPresent("tt_dpb_graph_outer_HSP-16_150px");
        this.assertTextPresent("tt_dpb_percent_HSP-16_33%");
        this.assertTextPresent("tt_dpb_graph_inner_HSP-16_100%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_dpb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_dpb_graph_progress_HSP-16", 2, "width:67%");
        this.assertTextNotPresent("tt_dpb_graph_outer_HSP-17_150px");
        this.assertTextNotPresent("tt_dpb_percent_HSP-17_");
        this.assertTextNotPresent("tt_dpb_graph_inner_HSP-17_100%");
        this.assertTextNotPresent("tt_dpb_graph_orig_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_dpb_graph_progress_HSP-17_empty_cell");
    }

    public void testAggregateProgressBar() throws SAXException {
        this.displayAllIssues();
        this.assertTextNotPresent("\u03a3 Original Estimate");
        this.clickLinkWithText("Configure");
        this.selectOption("fieldId", "\u03a3 Progress");
        this.submit("add");
        this.displayAllIssues();
        this.assertTextPresent(" Progress");
        this.assertTextPresent("tt_apb_graph_outer_HSP-19_150px");
        this.assertTextPresent("tt_apb_percent_HSP-19_");
        this.assertTextPresent("tt_apb_graph_inner_HSP-19_100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-19", 0, "width:100%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-19", 0, "width:100%");
        this.assertTextNotPresent("tt_apb_graph_outer_HSP-17_150px");
        this.assertTextNotPresent("tt_apb_percent_HSP-17_");
        this.assertTextNotPresent("tt_apb_graph_inner_HSP-17_100%");
        this.assertTextNotPresent("tt_apb_graph_orig_HSP-17_empty_cell");
        this.assertTextNotPresent("tt_apb_graph_progress_HSP-17_empty_cell");
        this.assertTextPresent("tt_apb_graph_outer_HSP-16_150px");
        this.assertTextPresent("tt_apb_percent_HSP-16_33%");
        this.assertTextPresent("tt_apb_graph_inner_HSP-16_100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-16", 0, "width:66%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-16", 1, "width:34%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-16", 0, "width:33%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-16", 2, "width:67%");
        this.assertTextPresent("tt_apb_graph_outer_HSP-12_150px");
        this.assertTextPresent("tt_apb_percent_HSP-12_55%");
        this.assertTextPresent("tt_apb_graph_inner_HSP-12_100%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-12", 0, "width:66%");
        this.assertGraphElementAttribute("tt_apb_graph_orig_HSP-12", 1, "width:34%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-12", 0, "width:55%");
        this.assertGraphElementAttribute("tt_apb_graph_progress_HSP-12", 2, "width:45%");
    }

    private void assertGraphElementAttribute(String tableName, int col, String attribute) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID(tableName);
        String style = table.getTableCell(0, col).getDOM().getAttributes().getNamedItem("style").getNodeValue();
        TestTimeTrackingAggregates.assertTrue((style.indexOf(attribute) != -1 ? 1 : 0) != 0);
    }
}

