/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestTimeTracking
extends JIRAWebTest {
    public TestTimeTracking(String name) {
        super(name);
    }

    public void testCustomDefaultUnit() throws SAXException {
        this.restoreBlankInstance();
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.submit("Activate");
        this.tester.assertTextPresent("The current default unit for time tracking is <b>minute</b>.");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.submit("Deactivate");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.selectOption("defaultUnit", "hour");
        this.tester.submit("Activate");
        this.tester.assertTextPresent("The current default unit for time tracking is <b>hour</b>.");
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "");
        this.tester.setFormElement("timetracking", "5");
        this.tester.setFormElement("summary", "Morbi pretium mattis nulla");
        this.tester.submit("Create");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Time Tracking:");
        this.assertTimeTracking("5 hours", "5 hours", "Not Specified");
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "3");
        this.tester.submit("Log");
        this.assertTimeTracking("5 hours", "2 hours", "3 hours");
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "1 10m");
        this.tester.submit("Log");
        this.assertTimeTracking("5 hours", "50 minutes", "4 hours, 10 minutes");
    }

    public void testCustomDefaultWithCustomLengths() throws Exception {
        this.restoreBlankInstance();
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.selectOption("hoursPerDay", "8");
        this.tester.selectOption("daysPerWeek", "5");
        this.tester.selectOption("defaultUnit", "day");
        this.tester.submit("Activate");
        this.tester.assertTextPresent("The current default unit for time tracking is <b>day</b>.");
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "");
        this.tester.setFormElement("timetracking", "11");
        this.tester.setFormElement("summary", "Morbi pretium mattis nulla");
        this.tester.submit("Create");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Time Tracking:");
        this.assertTimeTracking("2 weeks, 1 day", "2 weeks, 1 day", "Not Specified");
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "1w");
        this.tester.submit("Log");
        this.assertTimeTracking("2 weeks, 1 day", "1 week, 1 day", "1 week");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.submit("Deactivate");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.selectOption("hoursPerDay", "24");
        this.tester.selectOption("daysPerWeek", "2");
        this.tester.selectOption("defaultUnit", "week");
        this.tester.submit("Activate");
        this.tester.assertTextPresent("The current default unit for time tracking is <b>week</b>.");
        this.gotoIssue("HSP-1");
        this.assertTimeTracking("1 week, 1 day, 16 hours", "1 week", "1 day, 16 hours");
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "1");
        this.tester.submit("Log");
        this.gotoIssue("HSP-1");
        this.assertTimeTracking("1 week, 1 day, 16 hours", "0 minutes", "1 week, 1 day, 16 hours");
    }

    public void testCustomDefaultUnitSwitch() throws SAXException {
        this.restoreBlankInstance();
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.selectOption("hoursPerDay", "6");
        this.tester.selectOption("daysPerWeek", "5");
        this.tester.submit("Activate");
        this.tester.assertTextPresent("The current default unit for time tracking is <b>minute</b>.");
        this.tester.clickLink("create_link");
        this.tester.submit("Next>>");
        this.tester.setFormElement("summary", "");
        this.tester.setFormElement("timetracking", "3w");
        this.tester.setFormElement("summary", "Morbi pretium mattis nulla");
        this.tester.submit("Create");
        this.gotoIssue("HSP-1");
        this.assertTextPresent("Time Tracking:");
        this.assertTimeTracking("3 weeks", "3 weeks", "Not Specified");
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "120");
        this.tester.submit("Log");
        this.assertTimeTracking("3 weeks", "2 weeks, 4 days, 4 hours", "2 hours");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.submit("Deactivate");
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.selectOption("defaultUnit", "hour");
        this.tester.submit("Activate");
        this.tester.assertTextPresent("The current default unit for time tracking is <b>hour</b>.");
        this.gotoIssue("HSP-1");
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "5");
        this.tester.submit("Log");
        this.assertTimeTracking("3 weeks", "2 weeks, 3 days, 5 hours", "1 day, 1 hour");
    }

    private void assertTimeTracking(String originalEstimate, String remainingEstimate, String timeSpent) throws SAXException {
        WebTable table = this.getDialog().getResponse().getTableWithID("tt_single_table_info");
        TestTimeTracking.assertTrue((boolean)this.tableCellHasText(table, 0, 0, "Original Estimate:"));
        TestTimeTracking.assertTrue((boolean)this.tableCellHasText(table, 0, 1, originalEstimate));
        TestTimeTracking.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Remaining Estimate:"));
        TestTimeTracking.assertTrue((boolean)this.tableCellHasText(table, 1, 1, remainingEstimate));
        TestTimeTracking.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Time Spent:"));
        TestTimeTracking.assertTrue((boolean)this.tableCellHasText(table, 2, 1, timeSpent));
    }
}

