/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import java.util.HashMap;
import org.xml.sax.SAXException;

public class TestDeleteWorklog
extends JIRAWebTest {
    private static final String ADMIN_COMMENT = "Admin does some work.";
    private static final String HSP_1 = "HSP-1";
    private static final String TIME_SPENT = "Time Spent";
    private static final String REMAINING_ESTIMATE = "Remaining Estimate";
    private static final String WORKLOG_ID = "Worklog Id";
    private static final String WORKLOG_TIME_SPENT = "Worklog Time Spent";

    public TestDeleteWorklog(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestUpdateWorklog.xml");
    }

    public void testMandatoryFields() {
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.clickLink("delete_worklog_10000");
        this.setFormElement("newEstimate", "");
        this.checkCheckbox("adjustEstimate", "new");
        this.submit();
        this.assertTextPresent("You must supply a valid new estimate.");
    }

    public void testInvalidFormattedDurationFields() {
        this.gotoIssue(HSP_1);
        this.clickWorkLogLink();
        this.clickLink("delete_worklog_10000");
        this.setFormElement("newEstimate", "Six Days, Seven Nights");
        this.checkCheckbox("adjustEstimate", "new");
        this.submit();
        this.assertTextPresent("Invalid new estimate entered.");
    }

    public void testInsufficientSecurityLevelCantDelete() {
        this.gotoIssue(HSP_1);
        this.clickLinkWithText("Work Log");
        this.clickLink("edit_worklog_10000");
        this.selectOption("commentLevel", "jira-administrators");
        this.submit("Log");
        this.logout();
        this.login("mel", "mel");
        this.gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
        this.assertTextPresent("ACCESS DENIED");
        this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    public void testNoPermissionCantDelete() {
        this.gotoDefaultPermissionScheme();
        this.clickLink("del_perm_43_");
        this.submit("Delete");
        this.logout();
        this.login("mel", "mel");
        this.gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=10000");
        this.assertTextPresent("ACCESS DENIED");
        this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
    }

    public void testDeleteNonExistantWorklog() {
        this.gotoPage("/secure/DeleteWorklog!default.jspa?id=10000&worklogId=OMGROFLCOPTER");
        this.assertTextPresent("Delete Worklog");
        this.assertTextPresent("Cannot retrieve worklog with id='null' for update.");
    }

    public void testDeleteChangeHistory() throws SAXException {
        this.gotoIssue(HSP_1);
        this.clickLinkWithText("Work Log");
        this.clickLink("delete_worklog_10000");
        this.submit("Delete");
        this.assertAdminWorklogDeleted();
        this.clickLinkWithText("Change History");
        HashMap<String, String> prevValue = new HashMap<String, String>();
        HashMap<String, String> newValue = new HashMap<String, String>();
        WebTable table = this.getDialog().getResponse().getTableWithID("changehistory_10020");
        for (int i = 0; i < 4; ++i) {
            if (table.getCellAsText(i, 0).indexOf(WORKLOG_TIME_SPENT) != -1) {
                prevValue.put(WORKLOG_TIME_SPENT, table.getCellAsText(i, 1));
                newValue.put(WORKLOG_TIME_SPENT, table.getCellAsText(i, 2));
                continue;
            }
            if (table.getCellAsText(i, 0).indexOf(REMAINING_ESTIMATE) != -1) {
                prevValue.put(REMAINING_ESTIMATE, table.getCellAsText(i, 1));
                newValue.put(REMAINING_ESTIMATE, table.getCellAsText(i, 2));
                continue;
            }
            if (table.getCellAsText(i, 0).indexOf(WORKLOG_ID) != -1) {
                prevValue.put(WORKLOG_ID, table.getCellAsText(i, 1));
                newValue.put(WORKLOG_ID, table.getCellAsText(i, 2));
                continue;
            }
            if (table.getCellAsText(i, 0).indexOf(TIME_SPENT) == -1) continue;
            prevValue.put(TIME_SPENT, table.getCellAsText(i, 1));
            newValue.put(TIME_SPENT, table.getCellAsText(i, 2));
        }
        TestDeleteWorklog.assertEquals((int)4, (int)prevValue.keySet().size());
        TestDeleteWorklog.assertTrue((boolean)prevValue.keySet().contains(TIME_SPENT));
        TestDeleteWorklog.assertTrue((boolean)prevValue.keySet().contains(REMAINING_ESTIMATE));
        TestDeleteWorklog.assertTrue((boolean)prevValue.keySet().contains(WORKLOG_ID));
        TestDeleteWorklog.assertTrue((boolean)prevValue.keySet().contains(WORKLOG_TIME_SPENT));
        TestDeleteWorklog.assertEquals((int)4, (int)newValue.keySet().size());
        TestDeleteWorklog.assertTrue((boolean)newValue.keySet().contains(TIME_SPENT));
        TestDeleteWorklog.assertTrue((boolean)newValue.keySet().contains(REMAINING_ESTIMATE));
        TestDeleteWorklog.assertTrue((boolean)newValue.keySet().contains(WORKLOG_ID));
        TestDeleteWorklog.assertTrue((boolean)newValue.keySet().contains(WORKLOG_TIME_SPENT));
        this.assertContainsSubstring("3 weeks, 1 day", (String)prevValue.get(REMAINING_ESTIMATE));
        this.assertContainsSubstring("1900800", (String)prevValue.get(REMAINING_ESTIMATE));
        this.assertContainsSubstring("3 weeks, 2 days", (String)newValue.get(REMAINING_ESTIMATE));
        this.assertContainsSubstring("1987200", (String)newValue.get(REMAINING_ESTIMATE));
        this.assertContainsSubstring("6 days", (String)prevValue.get(TIME_SPENT));
        this.assertContainsSubstring("518400", (String)prevValue.get(TIME_SPENT));
        this.assertContainsSubstring("5 days", (String)newValue.get(TIME_SPENT));
        this.assertContainsSubstring("432000", (String)newValue.get(TIME_SPENT));
        this.assertContainsSubstring("10000", (String)prevValue.get(WORKLOG_ID));
        this.assertContainsSubstring("10000", (String)prevValue.get(WORKLOG_ID));
        this.assertContainsSubstring("1 day", (String)prevValue.get(WORKLOG_TIME_SPENT));
        this.assertContainsSubstring("86400", (String)prevValue.get(WORKLOG_TIME_SPENT));
    }

    public void testDeleteAndAutoAdjustRemainingEstimate() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("delete_worklog_10000");
        this.checkCheckbox("adjustEstimate", "auto");
        this.submit("Delete");
        this.assertTextSequence(new String[]{"3 weeks", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    public void testDeleteAndRetainRemainingEstimate() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("delete_worklog_10000");
        this.checkCheckbox("adjustEstimate", "leave");
        this.submit("Delete");
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    public void testDeleteAndSpecifyNewEstimate() {
        this.gotoIssue(HSP_1);
        this.assertTextSequence(new String[]{"3 weeks, 1 day", "6 days"});
        this.clickWorkLogLink();
        this.clickLink("delete_worklog_10000");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "8w");
        this.submit("Delete");
        this.assertTextSequence(new String[]{"8 weeks", "5 days"});
        this.assertAdminWorklogDeleted();
    }

    private void assertAdminWorklogDeleted() {
        this.assertTextNotPresent(ADMIN_COMMENT);
        this.assertTextNotPresent("19/Jun/07 06:09 PM");
        this.assertTextNotPresent("title=\"Created: 19/Jun/07 06:10 PM\"");
        this.assertLinkNotPresent("delete_worklog_10000");
        this.assertLinkNotPresent("edit_worklog_10000");
    }

    private void clickWorkLogLink() {
        if (this.hasLinkWithText("Work Log")) {
            this.clickLinkWithText("Work Log");
        }
    }

    private void assertContainsSubstring(String s1, String s2) {
        TestDeleteWorklog.assertTrue((s2.indexOf(s1) > -1 ? 1 : 0) != 0);
    }

    public void testManuallyIncreaseEstimate() {
        this.gotoIssue(HSP_1);
        this.assertTableCellHasText("tt_single_table_info", 0, 0, "Original Estimate:");
        this.assertTableCellHasText("tt_single_table_info", 0, 1, "4 weeks");
        this.assertTableCellHasText("tt_single_table_info", 1, 0, "Remaining Estimate:");
        this.assertTableCellHasText("tt_single_table_info", 1, 1, "3 weeks, 1 day");
        this.assertTableCellHasText("tt_single_table_info", 2, 0, "Time Spent:");
        this.assertTableCellHasText("tt_single_table_info", 2, 1, "6 days");
        this.tester.clickLinkWithText("Work Log");
        this.tester.clickLink("delete_worklog_10002");
        this.tester.checkCheckbox("adjustEstimate", "manual");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
        this.tester.setFormElement("adjustmentAmount", "heaps");
        this.tester.submit("Delete");
        this.tester.assertTextPresent("Invalid time entered for adjusting the estimate.");
        this.tester.setFormElement("adjustmentAmount", "2d");
        this.tester.submit("Delete");
        this.assertTableCellHasText("tt_single_table_info", 0, 0, "Original Estimate:");
        this.assertTableCellHasText("tt_single_table_info", 0, 1, "4 weeks");
        this.assertTableCellHasText("tt_single_table_info", 1, 0, "Remaining Estimate:");
        this.assertTableCellHasText("tt_single_table_info", 1, 1, "3 weeks, 3 days");
        this.assertTableCellHasText("tt_single_table_info", 2, 0, "Time Spent:");
        this.assertTableCellHasText("tt_single_table_info", 2, 1, "3 days");
    }
}

