/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking;

import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;

public class TestCreateWorklog
extends JIRAWebTest {
    private static final String HSP_1 = "HSP-1";
    private static final String WORK_LOG_COMMENT_1 = "This is a comment generated for a first work log.";
    private static final String WORK_LOG_COMMENT_2 = "This is a comment generated for a second work log.";
    private static final String ROLE_DEVELOPERS = "Developers";
    private static final String GROUP_ADMINISTRATORS = "jira-administrators";
    private String timeFormat;
    private static final String CHANGEHISTORY_10001 = "changehistory_10001";

    public TestCreateWorklog(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestLogWork.xml");
        this.enableCommentGroupVisibility(Boolean.TRUE);
    }

    public void tearDown() {
        this.login("admin", "admin");
        super.tearDown();
    }

    public void testWorklogNoPermToCreate() {
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.clickLink("del_perm_20_jira-developers");
        this.submit("Delete");
        this.gotoPage("/secure/CreateWorklog!default.jspa?id=10000");
        this.assertTextPresent("ACCESS DENIED");
    }

    public void testLogWorkNoteCorrect() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.assertTextPresent("Note: Your current conversion rates are 1w = 7d and 1d = 24h");
    }

    public void testMandatoryFields() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "");
        this.setFormElement("startDate", "");
        this.setFormElement("newEstimate", "");
        this.checkCheckbox("adjustEstimate", "new");
        this.submit();
        this.assertTextPresent("You must indicate the time spent working.");
        this.assertTextPresent("You must specify a date on which the work occurred.");
        this.assertTextPresent("You must supply a valid new estimate.");
    }

    public void testInvalidFormattedDurationFields() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "16 Candles");
        this.setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.setFormElement("newEstimate", "Six Days, Seven Nights");
        this.checkCheckbox("adjustEstimate", "new");
        this.submit();
        this.assertTextPresent("Invalid time duration entered.");
        this.assertTextPresent("Invalid new estimate entered.");
    }

    public void testInvalidTimeSpentZero() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "0");
        this.setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.submit();
        this.assertTextPresent("Time Spent can not be zero.");
    }

    public void testInvalidStartDateField() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "4h");
        this.setFormElement("startDate", "The Day After Tomorrow");
        this.checkCheckbox("adjustEstimate", "leave");
        this.submit();
        this.assertTextPresent("You must specify a date on which the work occurred.");
    }

    public void testAutoAdjustEstimate() {
        this.gotoIssue(HSP_1);
        this.clickLink("edit_issue");
        this.setFormElement("timetracking", "4d");
        this.submit("Update");
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "4h 30m");
        this.submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "3 days, 19 hours, 30 minutes", "Time Spent", "4 hours, 30 minutes"});
    }

    public void testNewEstimate() {
        this.gotoIssue(HSP_1);
        this.clickLink("edit_issue");
        this.setFormElement("timetracking", "4d");
        this.submit("Update");
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "4h 30m");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "1d 5h");
        this.submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "1 day, 5 hours", "Time Spent", "4 hours, 30 minutes"});
    }

    public void testLeaveExistingEstimate() {
        this.gotoIssue(HSP_1);
        this.clickLink("edit_issue");
        this.setFormElement("timetracking", "4d");
        this.submit("Update");
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "4h 30m");
        this.checkCheckbox("adjustEstimate", "leave");
        this.submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "4 days", "Time Spent", "4 hours, 30 minutes"});
    }

    public void testLogWorkVisibleToAll() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisibleToAll();
    }

    public void testLogWorkVisibleToAllDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisibleToAll();
    }

    public void testLogWorkVisibleToAllHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisibleToAll();
    }

    private void execLogWorkVisibleToAll() {
        this.gotoIssue(HSP_1);
        this.logWorkOnIssueWithComment(HSP_1, "2d", WORK_LOG_COMMENT_1);
        this.clickLinkWithText("Work Log");
        this.assertTextPresent(WORK_LOG_COMMENT_1);
        if ("pretty".equals(this.timeFormat)) {
            this.assertTextPresent("2 days");
        } else if ("days".equals(this.timeFormat)) {
            this.assertTextPresentAfterText("2d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.assertTextPresentAfterText("48h", "Time Spent");
        }
    }

    public void testLogWorkVisibleToRole() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisibleToRole();
    }

    public void testLogWorkVisibleToRoleDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisibleToRole();
    }

    public void testLogWorkVisibleToRoleHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisibleToRole();
    }

    public void execLogWorkVisibleToRole() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "2d");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "2w");
        this.setFormElement("comment", WORK_LOG_COMMENT_1);
        this.selectOption("commentLevel", ROLE_DEVELOPERS);
        this.submit();
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "3d");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "2w");
        this.setFormElement("comment", WORK_LOG_COMMENT_2);
        this.selectOption("commentLevel", ROLE_DEVELOPERS);
        this.submit();
        this.clickLinkWithText("Work Log");
        this.assertTextPresent(WORK_LOG_COMMENT_1);
        this.assertTextPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.assertTextPresent("2 days");
            this.assertTextPresent("3 days");
            this.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.assertTextPresentAfterText("2d", "Time Worked");
            this.assertTextPresentAfterText("3d", "Time Worked");
            this.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.assertTextPresentAfterText("48h", "Time Worked");
            this.assertTextPresentAfterText("72h", "Time Worked");
            this.assertTextPresentAfterText("120h", "Time Spent");
        }
        this.login("fred", "fred");
        this.gotoIssue(HSP_1);
        this.assertTextNotPresent(WORK_LOG_COMMENT_1);
        this.assertTextNotPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.assertTextNotPresent("2 days");
            this.assertTextNotPresent("3 days");
            this.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.assertTextNotPresent(" 2d ");
            this.assertTextNotPresent(" 3d ");
            this.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.assertTextNotPresent(" 48h ");
            this.assertTextNotPresent(" 72h ");
            this.assertTextPresentAfterText("120h", "Time Spent");
        }
    }

    public void testLogWorkVisibleToGroup() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkVisibleToGroupDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkVisibleToGroupHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkDateIsStartDate() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "2d");
        this.setFormElement("startDate", "1/Jun/06 12:00 PM");
        this.submit();
        this.clickLinkWithText("Work Log");
        this.assertTextPresent("01/Jun/06 12:00 PM");
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "2d");
        this.setFormElement("startDate", "1/Jun/05 12:00 PM");
        this.submit();
        this.assertTextPresentBeforeText("1/Jun/05 12:00 PM", "01/Jun/06 12:00 PM");
    }

    public void execLogWorkVisibleToGroup() {
        this.gotoIssue(HSP_1);
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "2d");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "2w");
        this.setFormElement("comment", WORK_LOG_COMMENT_1);
        this.selectOption("commentLevel", GROUP_ADMINISTRATORS);
        this.submit();
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "3d");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "2w");
        this.setFormElement("comment", WORK_LOG_COMMENT_2);
        this.selectOption("commentLevel", GROUP_ADMINISTRATORS);
        this.submit();
        this.clickLinkWithText("Work Log");
        this.assertTextPresent(WORK_LOG_COMMENT_1);
        this.assertTextPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.assertTextPresent("2 days");
            this.assertTextPresent("3 days");
            this.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.assertTextPresentAfterText("2d", "Time Worked");
            this.assertTextPresentAfterText("3d", "Time Worked");
            this.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.assertTextPresentAfterText("48h", "Time Worked");
            this.assertTextPresentAfterText("72h", "Time Worked");
            this.assertTextPresentAfterText("120h", "Time Spent");
        }
        this.login("fred", "fred");
        this.gotoIssue(HSP_1);
        this.assertTextNotPresent(WORK_LOG_COMMENT_1);
        this.assertTextNotPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.assertTextNotPresent("2 days");
            this.assertTextNotPresent("3 days");
            this.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.assertTextNotPresent(" 2d ");
            this.assertTextNotPresent(" 3d ");
            this.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.assertTextNotPresent(" 48h ");
            this.assertTextNotPresent(" 72h ");
            this.assertTextPresentAfterText("120h", "Time Spent");
        }
    }

    public void reconfigureTimetracking(String format) {
        super.reconfigureTimetracking(format);
        this.timeFormat = format;
    }

    public void testChangeHistory() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        this.gotoIssue(HSP_1);
        this.clickLink("edit_issue");
        this.setFormElement("timetracking", "4d");
        this.submit("Update");
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.clickLink("log_work");
        this.setFormElement("timeLogged", "4h 30m");
        this.checkCheckbox("adjustEstimate", "new");
        this.setFormElement("newEstimate", "1d 5h");
        this.submit("Log");
        this.clickLinkWithText("Change History");
        boolean timeSpentCalled = false;
        boolean remainingEstitmateCalled = false;
        this.getDialog().dumpResponse();
        WebTable table = this.getDialog().getResponse().getTableWithID(CHANGEHISTORY_10001);
        if (table.getCellAsText(0, 0).indexOf("Time Spent") != -1) {
            this.assertChangeHistoryForTimeSpent(0);
            timeSpentCalled = true;
        } else if (table.getCellAsText(0, 0).indexOf("Remaining Estimate") != -1) {
            this.assertChangeHistoryForRemaininigEstimate(0);
            remainingEstitmateCalled = true;
        }
        if (table.getCellAsText(1, 0).indexOf("Time Spent") != -1) {
            this.assertChangeHistoryForTimeSpent(1);
            timeSpentCalled = true;
        } else if (table.getCellAsText(1, 0).indexOf("Remaining Estimate") != -1) {
            this.assertChangeHistoryForRemaininigEstimate(1);
            remainingEstitmateCalled = true;
        }
        TestCreateWorklog.assertTrue((boolean)remainingEstitmateCalled);
        TestCreateWorklog.assertTrue((boolean)timeSpentCalled);
    }

    private void assertChangeHistoryForRemaininigEstimate(int row) {
        this.assertTableCellHasText(CHANGEHISTORY_10001, row, 1, "4 days");
        this.assertTableCellHasText(CHANGEHISTORY_10001, row, 1, "345600");
        this.assertTableCellHasText(CHANGEHISTORY_10001, row, 2, "1 day, 5 hours");
        this.assertTableCellHasText(CHANGEHISTORY_10001, row, 2, "10440");
    }

    private void assertChangeHistoryForTimeSpent(int row) {
        this.assertTableCellHasText(CHANGEHISTORY_10001, row, 2, "4 hours, 30 minutes");
        this.assertTableCellHasText(CHANGEHISTORY_10001, row, 2, "16200");
    }

    public void testManuallyReduceEstimate() {
        this.gotoIssue(HSP_1);
        this.clickLink("edit_issue");
        this.setFormElement("timetracking", "2d");
        this.submit("Update");
        this.tester.clickLink("log_work");
        this.tester.setFormElement("timeLogged", "12h");
        this.tester.checkCheckbox("adjustEstimate", "manual");
        this.tester.submit("Log");
        this.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
        this.tester.setFormElement("adjustmentAmount", "1cow");
        this.tester.submit("Log");
        this.assertTextPresent("Invalid time entered for adjusting the estimate.");
        this.tester.setFormElement("adjustmentAmount", "6h");
        this.tester.submit("Log");
        this.assertTableCellHasText("tt_single_table_info", 0, 0, "Original Estimate:");
        this.assertTableCellHasText("tt_single_table_info", 0, 1, "2 days");
        this.assertTableCellHasText("tt_single_table_info", 1, 0, "Remaining Estimate:");
        this.assertTableCellHasText("tt_single_table_info", 1, 1, "1 day, 18 hours");
        this.assertTableCellHasText("tt_single_table_info", 2, 0, "Time Spent:");
        this.assertTableCellHasText("tt_single_table_info", 2, 1, "12 hours");
    }
}

