/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

public class TestSubTaskQuickCreation
extends JIRAWebTest {
    private static final String ISSUE_PARENT = "HSP-6";

    public TestSubTaskQuickCreation(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestTimeTrackingAggregates.xml");
    }

    public void testFormHasVerticalLayout() throws SAXException {
        this.gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOrigEstimeFieldPresent();
    }

    public void testOriginalEstimateVisibility() throws Exception {
        this.gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOrigEstimeFieldPresent();
        this.deactivateTimeTracking();
        this.gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOrigEstimeFieldNotPresent();
        this.activateTimeTracking();
        this.gotoIssue(ISSUE_PARENT);
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOrigEstimeFieldPresent();
    }

    public void testCreateSubTask() throws Exception {
        this.gotoIssue(ISSUE_PARENT);
        this.setFormElement("summary", "New test sub-task");
        this.selectOption("issuetype", "Sub-task");
        this.selectOption("assignee", "Fred Normal");
        this.setFormElement("timetracking", "8h");
        this.clickButton("stqc_submit");
        this.assertVerticalFormPresent();
        this.assertFormFieldsPresent();
        this.assertOrigEstimeFieldPresent();
        this.assertTextSequence(new String[]{"New test sub-task", "Open", "Fred Normal", "0%"});
        this.gotoIssue("HSP-21");
        this.assertTextSequence(new String[]{"homosapien", "parent 1", "New test sub-task"});
    }

    private void assertVerticalFormPresent() {
        this.assertTextPresent("subtask_container_vertical");
        this.assertTextPresent("Add Sub-Task");
    }

    private void assertFormFieldsPresent() {
        this.assertTextPresent("Summary:");
        this.assertTextPresent("Issue Type:");
        this.assertTextPresent("Assignee:");
        this.assertFormElementPresent("summary");
        this.assertFormElementPresent("issuetype");
        this.assertFormElementPresent("assignee");
    }

    private void assertOrigEstimeFieldPresent() {
        this.assertTextPresent("Original Estimate:");
        this.assertFormElementPresent("timetracking");
    }

    private void assertOrigEstimeFieldNotPresent() {
        this.assertTextNotPresent("Original Estimate:");
        this.assertFormElementNotPresent("timetracking");
    }
}

