/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;

public class TestIssueToSubTaskConversionSystemFields
extends JIRAWebTest {
    private static final String ISSUE_MKY_1 = "MKY-1";
    private static final String PARENT_ISSUE_MKY_3 = "MKY-3";
    private static final String ISSUE_HSP_1 = "HSP-1";
    private static final String PARENT_ISSUE_HSP_2 = "HSP-2";
    private static final String ISSUE_GOD_1 = "GOD-1";
    private static final String PARENT_ISSUE_GOD_2 = "GOD-2";

    public TestIssueToSubTaskConversionSystemFields(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueToSubtaskConversionSystemFields.xml");
    }

    public void testConvertHiddenAndSomeShownScenarios() {
        this.gotoIssue(ISSUE_MKY_1);
        this.clickLink("issue_to_subtask");
        this.assertTextPresent("Step 1 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 1);
        this.assertTextPresent("Convert Issue to Sub-task: MKY-1");
        this.setFormElement("parentIssueKey", PARENT_ISSUE_MKY_3);
        this.submit("Next >>");
        this.assertTextNotPresent("Step 2 of 4");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 3);
        this.assertTextPresent("Component/s:");
        this.assertTextPresent("Environment:");
        this.assertTextNotPresent("Affects:");
        this.assertTextNotPresent("Assignee:");
        this.assertTextNotPresent("Description:");
        this.assertTextNotPresent("Due Date:");
        this.submit("Next >>");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 3);
        this.assertTextPresent("Component/s is required");
        this.selectOption("components", "Component1");
        this.submit("Next >>");
        this.assertTextPresent("Step 4 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_MKY_1, 4);
        WebTable table = this.getDialog().getWebTableBySummaryOrId("convert_confirm_table");
        TestIssueToSubTaskConversionSystemFields.assertEquals((String)"number of rows", (int)5, (int)table.getRowCount());
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Type"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "Bug"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 2, "Sub-task"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Component/s"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellDoesNotHaveText(table, 2, 1, "Component1"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 2, 2, "Component1"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 3, 0, "Environment"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 3, 1, "A test value"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 3, 2, "A test value"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 4, 0, "Description"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 4, 1, "A test value"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellDoesNotHaveText(table, 4, 2, "A test value"));
        this.submit("Finish");
        this.assertIssueIsSubtask("A monkey bug", ISSUE_MKY_1, "A third monkey issue", PARENT_ISSUE_MKY_3, "Sub-task");
    }

    public void testShownAndSomeRequiredScenarios() {
        this.gotoIssue(ISSUE_HSP_1);
        this.clickLink("issue_to_subtask");
        this.assertTextPresent("Step 1 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 1);
        this.assertTextPresent("Convert Issue to Sub-task: HSP-1");
        this.setFormElement("parentIssueKey", PARENT_ISSUE_HSP_2);
        this.submit("Next >>");
        this.assertTextNotPresent("Step 2 of 4");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 3);
        this.assertTextPresent("Component/s:");
        this.assertTextPresent("Environment:");
        this.assertTextPresent("Description:");
        this.assertTextNotPresent("Affects:");
        this.assertTextNotPresent("Due Date:");
        this.assertTextNotPresent("Priority:");
        this.assertTextNotPresent("Summary:");
        this.submit("Next >>");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 3);
        this.assertTextPresent("Component/s is required");
        this.selectOption("components", "New Component 1");
        this.submit("Next >>");
        this.assertTextPresent("Step 4 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_HSP_1, 4);
        WebTable table = this.getDialog().getWebTableBySummaryOrId("convert_confirm_table");
        TestIssueToSubTaskConversionSystemFields.assertEquals((String)"number of rows", (int)6, (int)table.getRowCount());
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Type"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "Bug"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 2, "Sub-task"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Component/s"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellDoesNotHaveText(table, 2, 1, "New Component 1"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 2, 2, "New Component 1"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 3, 0, "Description"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 3, 1, "A test desc"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 3, 2, "A test desc"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 4, 0, "Environment"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 4, 1, "A test env"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 4, 2, "A test env"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 5, 0, "Fix Version/s"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 5, 1, "New Version 1"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellDoesNotHaveText(table, 5, 2, "New Version 1"));
        this.submit("Finish");
        this.assertIssueIsSubtask("A new issue", ISSUE_HSP_1, "A second issue", PARENT_ISSUE_HSP_2, "Sub-task");
    }

    public void testSomeMoreShownAndSomeRequiredScenarios() {
        this.gotoIssue(ISSUE_GOD_1);
        this.clickLink("issue_to_subtask");
        this.assertTextPresent("Step 1 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_GOD_1, 1);
        this.assertTextPresent("Convert Issue to Sub-task: GOD-1");
        this.setFormElement("parentIssueKey", PARENT_ISSUE_GOD_2);
        this.submit("Next >>");
        this.assertTextNotPresent("Step 2 of 4");
        this.assertTextPresent("Step 3 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_GOD_1, 3);
        this.assertTextPresent("Description:");
        this.assertTextNotPresent("Component/s:");
        this.assertTextNotPresent("Environment:");
        this.assertTextNotPresent("Affects:");
        this.assertTextNotPresent("Due Date:");
        this.assertTextNotPresent("Priority:");
        this.assertTextNotPresent("Summary:");
        this.submit("Next >>");
        this.assertTextPresent("Step 4 of 4");
        this.assertSubTaskConversionPanelSteps(ISSUE_GOD_1, 4);
        WebTable table = this.getDialog().getWebTableBySummaryOrId("convert_confirm_table");
        TestIssueToSubTaskConversionSystemFields.assertEquals((String)"number of rows", (int)3, (int)table.getRowCount());
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 0, "Type"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 1, "Bug"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 1, 2, "Sub-task"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 2, 0, "Description"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 2, 1, "A test desc"));
        TestIssueToSubTaskConversionSystemFields.assertTrue((boolean)this.tableCellHasText(table, 2, 2, "A test desc"));
        this.submit("Finish");
        this.assertIssueIsSubtask("A new issue", ISSUE_GOD_1, "The overlord", PARENT_ISSUE_GOD_2, "Sub-task");
    }
}

