/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueToSubTaskConversionParentPicker
extends JIRAWebTest {
    private static final String PROJECT_ID = "10000";
    private static final String ISSUE = "HSP-1";
    private static final String SUBTASK = "HSP-3";
    private static final String PARENT_ISSUE = "HSP-5";
    private static final String ISSUE_FROM_OTHER_PROJECT = "MKY-1";
    private static final String SHOW_ALL_FILTER = "Show all";
    private static final String SHOW_ALL_FILTER_ID = "10000";

    public TestIssueToSubTaskConversionParentPicker(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueToSubTaskConversion.xml");
    }

    public void testIssueToSubTaskConversionParentPickerSameIssue() {
        this.gotoFilter(SHOW_ALL_FILTER);
        this.assertLinkPresentWithText(ISSUE);
        this.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.assertLinkNotPresentWithText(ISSUE);
    }

    public void testIssueToSubTaskConversionParentPickerSubTask() {
        this.gotoFilter(SHOW_ALL_FILTER);
        this.assertLinkPresentWithText(SUBTASK);
        this.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.assertLinkNotPresentWithText(SUBTASK);
    }

    public void testIssueToSubTaskConversionParentPickerOtherProject() {
        this.gotoFilter(SHOW_ALL_FILTER);
        this.assertLinkPresentWithText(ISSUE_FROM_OTHER_PROJECT);
        this.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.assertLinkNotPresentWithText(ISSUE_FROM_OTHER_PROJECT);
    }

    public void testIssueToSubTaskConversionParentPickerNoPermission() {
        this.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.submit();
        this.assertLinkPresentWithText(PARENT_ISSUE);
        this.logout();
        this.login("fred", "fred");
        this.gotoPage("/secure/popups/IssuePicker.jspa?searchRequestId=10000&mode=search&formName=jiraform&linkFieldName=parentIssueKey&currentIssue=HSP-1&singleSelectOnly=true&showSubTasks=false&showSubTasksParent=true&selectedProjectId=10000");
        this.assertLinkNotPresentWithText(PARENT_ISSUE);
    }
}

