/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestClosedParent
extends FuncTestCase {
    public void testCantCreateSubtaskWhenParentClosed() {
        this.administration.restoreData("TestCantCreateSubtaskWhenParentClosed.xml");
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.assertLinkPresent("create_subtask");
        this.tester.clickLinkWithText("Close Issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.tester.assertLinkPresentWithText("Reopen Issue");
        this.tester.assertLinkNotPresent("create_subtask");
    }

    public void testCantCloseParentWithOpenSubTasks() {
        this.administration.restoreData("TestCantCreateSubtaskWhenParentClosed.xml");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertTextPresent("Open - The issue is open and ready for the assignee to start work on it.");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextPresent("Open - The issue is open and ready for the assignee to start work on it.");
        this.tester.assertTextNotInTable("available_workflow_actions", new String[]{"Close Issue"});
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLinkWithText("Close Issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertTextInTable("available_workflow_actions", new String[]{"Close Issue"});
    }

    public void testConvertIssueToSubtask() {
        this.administration.restoreData("TestConvertIssueToSubtask.xml");
        this.navigation.issue().viewIssue("HSP-3");
        this.tester.clickLinkWithText("Convert");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("parentIssueKey", "HSP-1");
        this.tester.submit();
        this.tester.assertTextPresent("The issue HSP-1 is not editable.");
    }

    public void testMoveSubtaskToClosedParent() {
        this.administration.restoreData("TestMoveSubtaskToClosedParent.xml");
        this.navigation.issue().viewIssue("HSP-4");
        this.tester.clickLinkWithText("Move");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("operation", "move.subtask.parent.operation.name");
        this.tester.clickButton("Next >>");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("parentIssue", "HSP-1");
        this.tester.submit();
        this.tester.assertTextPresent("The new parent issue HSP-1 is not editable.");
    }

    public void testCantChangeAssigneeWhenIssueIsClosed() {
        this.administration.restoreData("TestCantChangeAssigneeWhenIssueIsClosed.xml");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertLinkNotPresentWithText("Assign");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertLinkNotPresentWithText("Assign");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.clickLinkWithText("Reopen Issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertLinkPresentWithText("Assign");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLinkWithText("Reopen Issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.assertLinkPresentWithText("Assign");
    }
}

