/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.security;

import com.atlassian.jira.functest.framework.FuncTestCase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class TestRedirectAfterLogin
extends FuncTestCase {
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testRedirectWithRelativeUrl() throws Exception {
        this.navigation.logout();
        String expectedLogoutPage = "/secure/Logout!default.jspa";
        String url = this.getCurrentUrl();
        TestRedirectAfterLogin.assertTrue((boolean)url.endsWith(expectedLogoutPage));
        String context = url.substring(0, url.length() - expectedLogoutPage.length());
        this.tester.gotoPage("login.jsp?os_destination=%2Fsecure%2Fadmin%2Fuser%2FUserBrowser.jspa");
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.submit("");
        TestRedirectAfterLogin.assertEquals((String)(context + "/secure/admin/user/UserBrowser.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("The User Browser allows you to browse all the users in the system. Filters allow you to limit the users that you see.");
    }

    public void testRedirectWithAbsoluteUrlSameContext() throws Exception {
        this.navigation.logout();
        String expectedLogoutPage = "/secure/Logout!default.jspa";
        String url = this.getCurrentUrl();
        TestRedirectAfterLogin.assertTrue((boolean)url.endsWith(expectedLogoutPage));
        String context = url.substring(0, url.length() - expectedLogoutPage.length());
        String absoluteUrl = context + "/secure/admin/user/UserBrowser.jspa";
        this.tester.gotoPage("login.jsp?os_destination=" + URLEncoder.encode(absoluteUrl, System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.submit("");
        TestRedirectAfterLogin.assertEquals((String)(context + "/secure/admin/user/UserBrowser.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("The User Browser allows you to browse all the users in the system. Filters allow you to limit the users that you see.");
    }

    public void testRedirectWithAbsoluteUrlDifferentContext() throws Exception {
        this.navigation.logout();
        String expectedLogoutPage = "/secure/Logout!default.jspa";
        String url = this.getCurrentUrl();
        TestRedirectAfterLogin.assertTrue((boolean)url.endsWith(expectedLogoutPage));
        String context = url.substring(0, url.length() - expectedLogoutPage.length());
        String absoluteUrl = "http://www.atlassian.com";
        this.tester.gotoPage("login.jsp?os_destination=" + URLEncoder.encode(absoluteUrl, System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.submit("");
        TestRedirectAfterLogin.assertEquals((String)(context + "/secure/Dashboard.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("jWebTest JIRA installation");
    }

    public void testRedirectWithHeaderInjectionCRLF() throws Exception {
        this._testRedirectWithHeaderInjection("\r\n");
    }

    public void testRedirectWithHeaderInjectionCR() throws Exception {
        this._testRedirectWithHeaderInjection("\r");
    }

    public void testRedirectWithHeaderInjectionLF() throws Exception {
        this._testRedirectWithHeaderInjection("\n");
    }

    private void _testRedirectWithHeaderInjection(String newlineChars) throws UnsupportedEncodingException {
        this.navigation.logout();
        String expectedLogoutPage = "/secure/Logout!default.jspa";
        String url = this.getCurrentUrl();
        TestRedirectAfterLogin.assertTrue((boolean)url.endsWith(expectedLogoutPage));
        String context = url.substring(0, url.length() - expectedLogoutPage.length());
        this.tester.gotoPage("login.jsp?os_destination=%2Fsecure%2Fadmin%2Fuser%2FUserBrowser.jspa" + URLEncoder.encode(newlineChars + "http://www.atlassian.com", System.getProperty("file.encoding")));
        this.tester.setFormElement("os_username", "admin");
        this.tester.setFormElement("os_password", "admin");
        this.tester.submit("");
        TestRedirectAfterLogin.assertEquals((String)(context + "/secure/Dashboard.jspa"), (String)this.getCurrentUrl());
        this.tester.assertTextPresent("jWebTest JIRA installation");
    }

    private String getCurrentUrl() {
        return this.tester.getDialog().getWebClient().getCurrentPage().getURL().toString();
    }
}

