/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.version;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.FuncTestHelperFactory;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryItem;
import com.atlassian.jira.webtests.ztests.workflow.ExpectedChangeHistoryRecord;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;

public class TestVersionActions
extends JIRAWebTest {
    private static final String AFFECTS_VERSION_FIELD = "Affects Version/s";
    private static final String FIX_VERSION_FIELD = "Fix Version/s";
    private Assertions assertions;
    private String issueKey;
    private static final String VERSION_ID_FIVE = "10002";
    private static final String VERSION_ID_ONE = "10000";

    public TestVersionActions(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        FuncTestHelperFactory funcTestHelperFactory = new FuncTestHelperFactory((TestCase)this, this.getEnvironmentData());
        this.assertions = funcTestHelperFactory.getAssertions();
    }

    public void testVersionActions() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        this.restoreBlankInstance();
        this.deleteVersionTest();
        this.issueKey = this.addIssue("homosapien", "HSP", "Bug", "Test issue for components", "Major", null, new String[]{"New Version 4"}, new String[]{"New Version 4"}, "Administrator", "test environment", "Issue to be moved from deleted component", null, null, null);
        this.versionActionDeleteVersionWithIssueMovingIssue();
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.versionActionDeleteVersionWithIssueRemovingIssue();
    }

    public void testMergeVersions() {
        this.restoreBlankInstance();
        this.issueKey = this.addIssue("homosapien", "HSP", "Bug", "Test issue for components", "Major", null, new String[]{"New Version 4"}, new String[]{"New Version 4"}, "Administrator", "test environment", "Issue to be moved from deleted component", null, null, null);
        this.gotoAdmin();
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("manage_versions");
        this.tester.setFormElement("name", "");
        this.tester.clickLink("merge_New Version 1");
        this.tester.uncheckCheckbox("idsToMerge");
        this.tester.selectOption("idMergeTo", "New Version 5");
        this.tester.submit("Merge");
        this.tester.assertTextPresent("You must select versions to merge from.");
        this.tester.checkCheckbox("idsToMerge", VERSION_ID_ONE);
        this.tester.checkCheckbox("idsToMerge", VERSION_ID_FIVE);
        this.tester.selectOption("idMergeTo", "New Version 1");
        this.tester.submit("Merge");
        this.tester.assertTextPresent("You cannot move the issues to the version being deleted.");
        this.tester.selectOption("idsToMerge", "New Version 1");
        this.tester.selectOption("idMergeTo", "New Version 5");
        this.tester.submit("Merge");
        this.assertTextSequence(new String[]{"Merging From Versions", "Merge To Version", "New Version 1", "New Version 5"});
        this.tester.submit("Merge");
        this.assertTextNotPresent("New Version 1");
        this.tester.clickLink("merge_New Version 4");
        this.tester.selectOption("idsToMerge", "New Version 4");
        this.tester.selectOption("idMergeTo", "New Version 5");
        this.tester.submit("Merge");
        this.assertTextSequence(new String[]{"Merging From Versions", "Merge To Version", "New Version 4", "New Version 5"});
        this.tester.submit("Merge");
        this.assertTextNotPresent("New Version 4");
        this.gotoIssue(this.issueKey);
        this.assertLinkPresentWithText("New Version 5");
        this.assertLinkNotPresentWithText("New Version 4");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem(AFFECTS_VERSION_FIELD, "New Version 4", ""), (Object)new ExpectedChangeHistoryItem(AFFECTS_VERSION_FIELD, "", "New Version 5"), (Object)new ExpectedChangeHistoryItem(FIX_VERSION_FIELD, "New Version 4", ""), (Object)new ExpectedChangeHistoryItem(FIX_VERSION_FIELD, "", "New Version 5"))));
    }

    public void testReleaseAndUnreleaseVersions() {
        this.restoreData("testReleaseUnreleaseVersions.xml");
        this.gotoManageVersions("homosapien");
        this.assertTextPresent("version 1");
        this.assertTextNotPresent("23/Jan/06");
        SimpleDateFormat datePickerFormat = new SimpleDateFormat("d/MMM/yy");
        String today = datePickerFormat.format(new Date());
        this.clickLinkWithText("Release");
        TestVersionActions.assertEquals((String)today, (String)this.getDialog().getFormParameterValue("releaseDate"));
        this.setFormElement("releaseDate", "24/Jan/06");
        this.submit("Release");
        this.assertTextPresent("24/Jan/06");
        this.clickLinkWithText("Unrelease");
        TestVersionActions.assertEquals((String)"24/Jan/06", (String)this.getDialog().getFormParameterValue("releaseDate"));
        this.setFormElement("releaseDate", "25/Jan/06");
        this.submit("Unrelease");
        this.assertTextPresent("25/Jan/06");
        this.clickLinkWithText("Release");
        TestVersionActions.assertEquals((String)"25/Jan/06", (String)this.getDialog().getFormParameterValue("releaseDate"));
        this.setFormElement("releaseDate", "");
        this.submit("Release");
        this.assertTextNotPresent("25/Jan/06");
        this.clickLinkWithText("Unrelease");
        TestVersionActions.assertEquals((String)"", (String)this.getDialog().getFormParameterValue("releaseDate"));
        this.setFormElement("releaseDate", "26/Jan/06");
        this.submit("Unrelease");
        this.assertTextPresent("26/Jan/06");
        this.clickLinkWithText("Release");
        TestVersionActions.assertEquals((String)"26/Jan/06", (String)this.getDialog().getFormParameterValue("releaseDate"));
        this.setFormElement("releaseDate", "invalidDate");
        this.submit("Release");
        this.assertTextPresent("Invalid date format. Please enter the date in the format d/MMM/yy");
        TestVersionActions.assertEquals((String)"invalidDate", (String)this.getDialog().getFormParameterValue("releaseDate"));
        this.setFormElement("releaseDate", "27/Jan/06");
        this.submit("Release");
        this.assertTextPresent("27/Jan/06");
        this.clickLinkWithText("Unrelease");
        TestVersionActions.assertEquals((String)"27/Jan/06", (String)this.getDialog().getFormParameterValue("releaseDate"));
        this.setFormElement("releaseDate", "invalidDate");
        this.submit("Unrelease");
        this.assertTextPresent("Invalid date format. Please enter the date in the format d/MMM/yy");
        TestVersionActions.assertEquals((String)"invalidDate", (String)this.getDialog().getFormParameterValue("releaseDate"));
    }

    public void testArchiveAndUnarchiveVersions() {
        this.restoreData("testReleaseUnreleaseVersions.xml");
        this.gotoManageVersions("homosapien");
        this.assertTextPresent("version 1");
        this.assertLinkNotPresentWithText("Unarchive");
        this.clickLinkWithText("Archive");
        this.assertLinkPresentWithText("Unarchive");
        this.clickLinkWithText("Unarchive");
        this.assertLinkPresentWithText("Archive");
    }

    public void testArchiveAndUnarchiveVersionsNoPermission() {
        this.restoreData("testReleaseUnreleaseVersions.xml");
        this.gotoManageVersions("homosapien");
        this.assertTextPresent("version 1");
        this.logout();
        this.gotoPage("secure/project/EditVersionArchives!archive.jspa?versionId=10004&pid=10000");
        this.assertTextPresent("ACCESS DENIED");
    }

    public void deleteVersionTest() {
        TestVersionActions.log("deleting version");
        this.deleteVersion("homosapien", "New Version 1");
        this.assertTextNotPresent("New Version 1");
    }

    public void versionActionDeleteVersionWithIssueMovingIssue() {
        TestVersionActions.log("Version Action: Test the operation to move issues from a version if version is deleted");
        this.gotoManageVersions("homosapien");
        this.clickLink("del_New Version 4");
        this.selectOption("affectsSwapVersionId", "New Version 5");
        this.getDialog().setFormParameter("affectsAction", "swap");
        this.assertRadioOptionSelected("affectsAction", "swap");
        this.selectOption("fixSwapVersionId", "New Version 5");
        this.getDialog().setFormParameter("fixAction", "swap");
        this.assertRadioOptionSelected("fixAction", "swap");
        this.submit("Delete");
        this.gotoIssue(this.issueKey);
        this.assertLinkPresentWithText("New Version 5");
        this.assertLinkNotPresentWithText("New Version 4");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem(AFFECTS_VERSION_FIELD, "New Version 4", ""), (Object)new ExpectedChangeHistoryItem(AFFECTS_VERSION_FIELD, "", "New Version 5"), (Object)new ExpectedChangeHistoryItem(FIX_VERSION_FIELD, "New Version 4", ""), (Object)new ExpectedChangeHistoryItem(FIX_VERSION_FIELD, "", "New Version 5"))));
    }

    public void versionActionDeleteVersionWithIssueRemovingIssue() {
        TestVersionActions.log("Version Action: Test the operation to remove issues from a version if version is deleted");
        this.gotoManageVersions("homosapien");
        this.clickLink("del_New Version 5");
        try {
            this.assertTextPresent("There are no other versions in this project. The version will be removed from all issues affecting it.");
            this.assertFormElementNotPresent("affectsSwapVersionId");
            this.assertFormElementNotPresent("fixSwapVersionId");
        }
        catch (Throwable t) {
            this.getDialog().setFormParameter("affectsAction", "remove");
            this.assertRadioOptionSelected("affectsAction", "remove");
            this.getDialog().setFormParameter("fixAction", "remove");
            this.assertRadioOptionSelected("fixAction", "remove");
        }
        this.submit("Delete");
        this.gotoIssue(this.issueKey);
        this.assertTextPresent("None");
        this.assertLinkNotPresentWithText("New Version 5");
        this.assertions.assertLastChangeHistoryRecords("HSP-1", new ExpectedChangeHistoryRecord(EasyList.build((Object)new ExpectedChangeHistoryItem(AFFECTS_VERSION_FIELD, "New Version 5", ""), (Object)new ExpectedChangeHistoryItem(FIX_VERSION_FIELD, "New Version 5", ""))));
    }

    public void testDeleteArchivedVersion() {
        this.restoreBlankInstance();
        this.addIssue("homosapien", "HSP", "Bug", "fix for one", "Major", null, null, new String[]{"New Version 1"}, null, "", "", null, null, null);
        this.addIssue("homosapien", "HSP", "Bug", "fix for two", "Major", null, null, new String[]{"New Version 4"}, null, "", "", null, null, null);
        this.addIssue("homosapien", "HSP", "Bug", "fix for five", "Major", null, null, new String[]{"New Version 5"}, null, "", "", null, null, null);
        this.gotoManageVersions("homosapien");
        this.assertNoUnarchivedVersionsAvaliable();
        this.assertOnlyUnarchivedVersionsAvaliable();
    }

    public void testAddVersionSecurityBreach() {
        this.restoreBlankInstance();
        this.logout();
        this.gotoPage("AddVersion.jspa?pid=10000");
        this.assertTextNotPresent("On this page you can manage the versions for the");
        this.assertTextNotPresent("New Version 5");
        this.assertTextNotPresent("You must specify a valid version name");
        this.assertTextPresent("ACCESS DENIED");
    }

    private void assertOnlyUnarchivedVersionsAvaliable() {
        this.clickLinkWithText("Unarchive", 0);
        this.clickLinkWithText("Delete", 0);
        this.assertTextPresent("Swap current fix version to");
        this.assertOptionNotPresent("fixSwapVersionId", "New Version 1");
    }

    private void assertNoUnarchivedVersionsAvaliable() {
        this.clickLinkWithText("Archive", 0);
        this.clickLinkWithText("Archive", 1);
        this.clickLinkWithText("Delete");
        this.assertTextPresent("There are no other versions in this project. The version will be removed from all issues it fixes.");
        this.gotoManageVersions("homosapien");
    }

    private void gotoManageVersions(String project) {
        this.goToProject(project);
        this.clickLink("manage_versions");
    }
}

