/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.version;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;

public class TestIssuesVersionTabPanel
extends FuncTestCase {
    private static final String NEW_VERSION_1 = "New Version 1";
    private static final String NEW_VERSION_4 = "New Version 4";

    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssuesVersionTabPanel.xml");
    }

    public void testUnresolvedByComponentVisibility() throws Exception {
        this.assertFragmentNotPresent("TestIssuesVersionTabPanel_ComponentsHiddenInFieldScheme.xml", "fragunresolvedissuesbycomponent", "Unresolved: By Component");
    }

    public void testUnresolvedByPriorityVisibility() throws Exception {
        this.assertFragmentNotPresent("TestIssuesVersionTabPanel_PriorityHiddenInFieldScheme.xml", "fragunresolvedissuesbypriority", "Unresolved: By Priority");
    }

    public void testStatusSummaryNoIssues() {
        this.deleteAllIssuesAndAssertNoIssues("fragstatussummary");
    }

    public void testUnresolvedByComponentNoIssues() {
        this.deleteAllIssuesAndAssertNoIssues("fragunresolvedissuesbycomponent");
    }

    public void testUnresolvedByPriorityNoIssues() {
        this.deleteAllIssuesAndAssertNoIssues("fragunresolvedissuesbypriority");
    }

    public void testStatusSummaryLinkOnPriority() {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.tester.clickLinkWithText("Open");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldstatus", "Open");
        this.assertSearchOrder("Priority descending");
    }

    public void testUnresolvedByComponentLinkOnNoComponent() {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.tester.clickLinkWithText("No Component");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldcomponent", "no components");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
    }

    public void testUnresolvedByPriorityLinkOnPriority() {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.tester.clickLinkWithText("Blocker");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldpriority", "Blocker");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Key descending");
    }

    public void testUnresolvedByPriorityHeaderLinkAndStats() {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/h3"), "Unresolved: By Priority");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/table//td");
        this.text.assertTextSequence(pathLocator, "Blocker", "1", "17%", "Major", "3", "50%", "Minor", "1", "17%", "Trivial", "1", "17%");
        this.tester.clickLink("fragunresolvedissuesbypriority_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
        this.setPriority("HSP-4", "Critical");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/table//td");
        this.text.assertTextSequence(pathLocator, "Blocker", "1", "17%", "Critical", "1", "17%", "Major", "3", "50%", "Trivial", "1", "17%");
        this.resolveIssue("HSP-4", null);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/table//td");
        this.text.assertTextSequence(pathLocator, "Blocker", "1", "20%", "Major", "3", "60%", "Trivial", "1", "20%");
        this.scheduleIssueFixVersion("HSP-5", NEW_VERSION_4);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/table//td");
        this.text.assertTextSequence(pathLocator, "Blocker", "1", "25%", "Major", "3", "75%");
    }

    public void testUnresolvedByComponentHeaderLink() {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/h3"), "Unresolved: By Component");
        this.tester.clickLink("fragunresolvedissuesbycomponent_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Component/s ascending");
    }

    public void testStatusSummaryHeaderLink() {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragstatussummary']/h3"), "Status Summary");
        this.tester.clickLink("fragstatussummary_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearchOrder("Status descending");
    }

    public void testStatusSummaryStats() throws Exception {
        this.administration.restoreData("TestIssuesVersionTabPanel_StatusSummary.xml");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragstatussummary']/table//td");
        this.text.assertTextSequence(pathLocator, "Open", "6", "50%", "In Progress", "1", "8%", "Reopened", "1", "8%", "Resolved", "2", "17%", "Closed", "2", "17%");
        this.scheduleIssueFixVersion("HSP-5", NEW_VERSION_4);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragstatussummary']/table//td");
        this.text.assertTextSequence(pathLocator, "Open", "5", "45%", "In Progress", "1", "9%", "Reopened", "1", "9%", "Resolved", "2", "18%", "Closed", "2", "18%");
    }

    public void testUnresolvedByComponentStats() {
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/div");
        this.text.assertTextSequence(pathLocator, "6", "No Component");
        this.text.assertTextNotPresent(pathLocator, "New Component");
        this.navigation.issue().setComponents("HSP-1", "New Component 1");
        this.navigation.issue().setComponents("HSP-2", "New Component 2");
        this.navigation.issue().setComponents("HSP-3", "New Component 3");
        this.navigation.issue().setComponents("HSP-4", "New Component 1");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/div");
        this.text.assertTextSequence(pathLocator, "2", "New Component 1", "1", "New Component 2", "1", "New Component 3", "2", "No Component");
        this.resolveIssue("HSP-3", null);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/div");
        this.text.assertTextSequence(pathLocator, "2", "New Component 1", "1", "New Component 2", "2", "No Component");
        this.scheduleIssueFixVersion("HSP-5", NEW_VERSION_4);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/div");
        this.text.assertTextSequence(pathLocator, "2", "New Component 1", "1", "New Component 2", "1", "No Component");
        this.tester.clickLinkWithText("New Component 1");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.tester.clickLinkWithText("New Component 2");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldcomponent", "New Component 2");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
    }

    public void testUnresolvedByAssignee() {
        this.administration.restoreData("TestIssuesVersionTabPanel_UnresolvedIssuesByAssignee.xml");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.tester.clickLink("fragunresolvedissuesbyassignee_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Assignee ascending");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/table//td");
        this.text.assertTextSequence(pathLocator, "Administrator", "1", "9%", "Big Boo", "1", "9%", "Charles", "1", "9%", "David Developer", "1", "9%", "Erik Eagle", "1", "9%", "Fred Normal", "1", "9%", "George Gray", "1", "9%", "Harry Henderson", "1", "9%", "Sleepy ZZZ", "1", "9%", "Xanadu", "1", "9%", "Unassigned", "1", "9%");
        this.assignIssue("HSP-1", "Unassigned");
        this.assignIssue("HSP-2", "Harry Henderson");
        this.assignIssue("HSP-3", "George Gray");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/table//td");
        this.text.assertTextSequence(pathLocator, "Charles", "1", "9%", "David Developer", "1", "9%", "Erik Eagle", "1", "9%", "George Gray", "2", "18%", "Harry Henderson", "2", "18%", "Sleepy ZZZ", "1", "9%", "Xanadu", "1", "9%", "Unassigned", "2", "18%");
        this.resolveIssue("HSP-3", null);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/table//td");
        this.text.assertTextSequence(pathLocator, "Charles", "1", "10%", "David Developer", "1", "10%", "Erik Eagle", "1", "10%", "George Gray", "1", "10%", "Harry Henderson", "2", "20%", "Sleepy ZZZ", "1", "10%", "Xanadu", "1", "10%", "Unassigned", "2", "20%");
        this.scheduleIssueFixVersion("HSP-5", NEW_VERSION_4);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/table//td");
        this.text.assertTextSequence(pathLocator, "Charles", "1", "11%", "David Developer", "1", "11%", "Erik Eagle", "1", "11%", "George Gray", "1", "11%", "Harry Henderson", "2", "22%", "Xanadu", "1", "11%", "Unassigned", "2", "22%");
        this.tester.clickLinkWithText("Unassigned");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearcherField("fieldassignee", "Unassigned");
        this.assertSearchOrder("Priority descending");
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.tester.clickLinkWithText("Harry Henderson");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldfixfor", NEW_VERSION_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearcherField("fieldassignee", "harry");
        this.assertSearchOrder("Priority descending");
        for (int i = 1; i <= 11; ++i) {
            this.navigation.issue().deleteIssue("HSP-" + i);
        }
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/p"), "No issues");
        this.tester.assertLinkNotPresent("fragunresolvedissuesbyassignee_more");
        this.assertFragmentNotPresent("TestIssuesVersionTabPanel_AssigneeHiddenInFieldScheme.xml", "fragunresolvedissuesbyassignee", "Unresolved: By Assignee");
    }

    private void assertSearchOrder(String expected) {
        XPathLocator pathLocator = new XPathLocator(this.tester, "//*[@id='filter-summary']/div");
        this.text.assertTextSequence(pathLocator, "Sorted by", expected);
    }

    private void assignIssue(String issueKey, String assigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("assign_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("assignee", assigneeName);
        this.tester.submit("Assign");
    }

    private void scheduleIssueFixVersion(String issueKey, String fixVersion) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("fixVersions", fixVersion);
        this.tester.submit("Update");
    }

    private void resolveIssue(String issueKey, String fixVersion) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("jiraform");
        if (fixVersion != null) {
            this.tester.selectOption("fixVersions", fixVersion);
        }
        this.tester.submit("Resolve");
    }

    private void assertSearcherField(String elementId, String expectedText) {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@id='" + elementId + "']"), expectedText);
    }

    private void setPriority(String key, String priority) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("priority", priority);
        this.tester.submit();
    }

    private void assertFragmentNotPresent(String xmlBackup, String fragId, String title) {
        this.administration.restoreData(xmlBackup);
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='" + fragId + "']/h3"), title);
    }

    private void deleteAllIssuesAndAssertNoIssues(String fragId) {
        for (String key : new String[]{"HSP-1", "HSP-2", "HSP-3", "HSP-4", "HSP-5", "HSP-6"}) {
            this.navigation.issue().deleteIssue(key);
        }
        this.navigation.browseVersionTabPanel("HSP", NEW_VERSION_1, "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='" + fragId + "']/p"), "No issues");
    }
}

