/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.component;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.LinkAssertionsImpl;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.joda.time.DateTime;
import org.w3c.dom.Node;

public class TestSummaryComponentTabPanel
extends FuncTestCase {
    private static final String NEW_COMPONENT_1 = "New Component 1";
    private static final String NEW_COMPONENT_2 = "New Component 2";

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testComponentDescription() throws Exception {
        this.assertFragmentNotPresent("fragcomponentdescription");
        this.administration.project().editComponent("homosapien", NEW_COMPONENT_1, null, "A description which should be <b>HTML</b> escaped", null);
        this.navigation.browseComponentTabPanel("HSP", NEW_COMPONENT_1, "summary");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragcomponentdescription']/h3"), "Description");
        this.tester.assertTextPresent("A description which should be &lt;b&gt;HTML&lt;/b&gt; escaped");
        this.tester.assertTextNotPresent("A description which should be <b>HTML</b> escaped");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='fragcomponentdescription']//li"), "Lead:");
        this.administration.project().editComponent("homosapien", NEW_COMPONENT_1, null, null, "admin");
        this.navigation.browseComponentTabPanel("HSP", NEW_COMPONENT_1, "summary");
        LinkAssertionsImpl link = new LinkAssertionsImpl(this.tester, this.getEnvironmentData());
        link.assertLinkPresentWithExactText("//div[@id='fragcomponentdescription']//li", "Administrator");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='fragcomponentdescription']//li"), "Lead:", "Administrator");
    }

    public void testDueIssues() throws Exception {
        DateTime cal = new DateTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("d/MMM/yy EEEE", Locale.getDefault());
        cal = cal.minusDays(14);
        DateTuple twoWeeksAgo = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(7);
        DateTuple oneWeekAgo = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(6);
        DateTuple yesterday = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(1);
        DateTuple today = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(1);
        DateTuple tomorrow = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(6);
        DateTuple oneWeekLater = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(7);
        DateTuple twoWeeksLater = new DateTuple(dateFormat.format(cal.toDate()));
        this.assertFragmentNotPresent("fragdueissues");
        String issue1 = this.createIssueAndSetDueDate(twoWeeksAgo, "Bug due two weeks ago", NEW_COMPONENT_1);
        String issue2 = this.createIssueAndSetDueDate(oneWeekAgo, "Bug due one week ago", NEW_COMPONENT_1);
        String issue3 = this.createIssueAndSetDueDate(yesterday, "Bug due yesterday", NEW_COMPONENT_1);
        String issue4 = this.createIssueAndSetDueDate(today, "Bug due today", NEW_COMPONENT_1);
        String issue5 = this.createIssueAndSetDueDate(tomorrow, "Bug due tomorrow", NEW_COMPONENT_1);
        String issue6 = this.createIssueAndSetDueDate(oneWeekLater, "Bug due one week later", NEW_COMPONENT_1);
        String issue7 = this.createIssueAndSetDueDate(twoWeeksLater, "Bug due two weeks later", NEW_COMPONENT_1);
        String issueOtherComponent = this.createIssueAndSetDueDate(twoWeeksAgo, "Bug due two weeks ago", NEW_COMPONENT_2);
        this.assertTop3DueIssues(issue1, twoWeeksAgo.dateString, issue2, "Last " + oneWeekAgo.dayOfWeek, issue3, "Yesterday", issue4, issue5, issue6, issue7, issueOtherComponent);
        this.setComponentDueDateAndPriority(issue2, null, yesterday.dateString, "Blocker");
        this.setComponentDueDateAndPriority(issue3, null, yesterday.dateString, "Minor");
        this.setComponentDueDateAndPriority(issue1, null, yesterday.dateString, "Trivial");
        this.assertTop3DueIssues(issue2, "Yesterday", issue3, "Yesterday", issue1, "Yesterday", issue4, issue5, issue6, issue7, issueOtherComponent);
        this.resolveIssue(issue1);
        this.resolveIssue(issue2);
        this.resolveIssue(issue3);
        this.assertTop3DueIssues(issue4, "Today", issue5, "Tomorrow", issue6, oneWeekLater.dayOfWeek, issue1, issue2, issue3, issue7, issueOtherComponent);
        this.setComponentDueDateAndPriority(issue4, null, "", null);
        this.assertTop3DueIssues(issue5, "Tomorrow", issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue1, issue2, issue3, issue4, issueOtherComponent);
        this.setComponentDueDateAndPriority(issue5, null, "", null);
        this.assertTop3DueIssues(issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue4, "", issue1, issue2, issue3, issue5, issueOtherComponent);
        this.setComponentDueDateAndPriority(issue5, null, "", "Blocker");
        this.assertTop3DueIssues(issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue5, "", issue1, issue2, issue3, issue4, issueOtherComponent);
        this.tester.clickLink("fragdueissues_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldcomponent", NEW_COMPONENT_1);
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Due Date ascending", "then Priority descending", "then Created ascending");
    }

    public void testRecentlyUpdatedIssues() throws Exception {
        this.assertFragmentNotPresent("fragrecentissues");
        this.administration.restoreData("TestRecentlyUpdatedIssuesFragment.xml");
        this.assertTop3RecentIssues("HSP-4", "HSP-2", "HSP-3", "HSP-1");
        this.setComponentDueDateAndPriority("HSP-1", null, "", "Blocker");
        this.assertTop3RecentIssues("HSP-1", "HSP-4", "HSP-2", "HSP-3");
        this.setComponentDueDateAndPriority("HSP-2", NEW_COMPONENT_2, "", null);
        this.assertTop3RecentIssues("HSP-1", "HSP-4", "HSP-3", "HSP-2");
        this.tester.clickLink("fragrecentissues_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldcomponent", NEW_COMPONENT_1);
        this.assertSearchOrder("Updated descending", "then Priority descending", "then Created ascending");
    }

    public void testDueVersions() throws Exception {
        this.administration.restoreData("TestSummaryProjectTabPanel_DueVersions.xml");
        this.assertTop3DueVersions(new String[]{"New Version 1", "New Version 4", "New Version 5"}, "New Version 7");
        this.administration.project().archiveVersion("homosapien", "New Version 1");
        this.assertTop3DueVersions(new String[]{"New Version 4", "New Version 5", "New Version 7"}, "New Version 1");
        this.administration.project().releaseVersion("homosapien", "New Version 5", null);
        this.assertTop3DueVersions(new String[]{"New Version 4", "New Version 7"}, "New Version 1", "New Version 5");
        this.administration.project().releaseVersion("homosapien", "New Version 4", null);
        this.administration.project().archiveVersion("homosapien", "New Version 4");
        this.assertTop3DueVersions(new String[]{"New Version 7"}, "New Version 1", "New Version 4", "New Version 5");
        this.administration.project().releaseVersion("homosapien", "New Version 7", null);
        this.administration.project().archiveVersion("homosapien", "New Version 7");
        this.assertFragmentNotPresent("fragdueversions");
        this.administration.project().unreleaseVersion("homosapien", "New Version 5", null);
        this.assertTop3DueVersions(new String[]{"New Version 5"}, "New Version 1", "New Version 4", "New Version 7");
        this.tester.gotoPage("/secure/admin/IssueFieldHide.jspa?hide=8");
        this.assertFragmentNotPresent("fragdueversions");
    }

    public void testDueVersionsNoVersions() throws Exception {
        this.administration.project().deleteVersion("homosapien", "New Version 1");
        this.administration.project().deleteVersion("homosapien", "New Version 4");
        this.administration.project().deleteVersion("homosapien", "New Version 5");
        this.assertFragmentNotPresent("fragdueversions");
    }

    private void assertFragmentNotPresent(String fragmentId) {
        this.navigation.browseComponentTabPanel("HSP", NEW_COMPONENT_1, "summary");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='" + fragmentId + "']/h3");
        Node[] nodes = pathLocator.getNodes();
        TestSummaryComponentTabPanel.assertTrue((nodes == null || nodes.length == 0 ? 1 : 0) != 0);
    }

    private void assertTop3DueVersions(String[] presentVersions, String ... notPresentVersions) {
        this.navigation.browseComponentTabPanel("HSP", NEW_COMPONENT_1, "summary");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragdueversions' ]//ul[@class='issues']/li");
        for (String version : notPresentVersions) {
            this.text.assertTextNotPresent(pathLocator, version);
        }
        this.text.assertTextSequence(pathLocator, presentVersions);
    }

    private void assertTop3DueIssues(String firstIssue, String firstDueDate, String secondIssue, String secondDueDate, String thirdIssue, String thirdDueDate, String ... issuesNotPresent) {
        this.navigation.browseComponentTabPanel("HSP", NEW_COMPONENT_1, "summary");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragdueissues']//ul[@class='issues']/li");
        this.text.assertTextSequence(pathLocator, new String[]{firstIssue, firstDueDate, secondIssue, secondDueDate, thirdIssue, thirdDueDate});
        for (String issue : issuesNotPresent) {
            this.text.assertTextNotPresent(pathLocator, issue);
        }
    }

    private void assertTop3RecentIssues(String firstIssue, String secondIssue, String thirdIssue, String ... issuesNotPresent) {
        this.navigation.browseComponentTabPanel("HSP", NEW_COMPONENT_1, "summary");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragrecentissues']//ul[@class='issues']/li");
        this.text.assertTextSequence(pathLocator, new String[]{firstIssue, secondIssue, thirdIssue});
        for (String issue : issuesNotPresent) {
            this.text.assertTextNotPresent(pathLocator, issue);
        }
    }

    private String createIssueAndSetDueDate(DateTuple dateTuple, String summary, String component) {
        String key = this.navigation.issue().createIssue("homosapien", "Bug", summary);
        this.setComponentDueDateAndPriority(key, component, dateTuple.dateString, null);
        return key;
    }

    private void setComponentDueDateAndPriority(String key, String component, String dueDate, String priority) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("duedate", dueDate);
        if (priority != null) {
            this.tester.selectOption("priority", priority);
        }
        if (component != null) {
            this.tester.selectOption("components", component);
        }
        this.tester.submit();
    }

    private void resolveIssue(String key) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLinkWithText("Resolve Issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.submit();
    }

    private void assertSearchOrder(String ... expectedSequence) {
        XPathLocator pathLocator = new XPathLocator(this.tester, "//*[@id='filter-summary']/div");
        this.text.assertTextSequence(pathLocator, "Sorted by", expectedSequence);
    }

    private void assertSearcherField(String elementId, String expectedText) {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@id='" + elementId + "']"), expectedText);
    }

    private static class DateTuple {
        String dateString;
        String dayOfWeek;

        DateTuple(String format) {
            String[] parts = format.split(" ");
            this.dateString = parts[0];
            this.dayOfWeek = parts[1];
        }
    }
}

