/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestProjectRoles
extends JIRAWebTest {
    public static final String VIEW_PROJECT_ROLES = "View members";
    private static final String ROLE_DESC = "this is a test role";
    private static final String ROLE_NAME = "test role";
    private static final String ROLE_NAME_UPPER_CASE = "Test role";
    private static final String ROLE_UPDATED_NAME = "testing role";
    private static final String ROLE_UPDATED_DESC = "this is an updated description";
    private static final String EDIT_ADMIN_USER_ACTORS = "edit_Administrators_atlassian-user-role-actor";
    private static final String EDIT_ADMIN_GROUP_ACTORS = "edit_Administrators_atlassian-group-role-actor";
    private static final String EDIT_USER_ACTORS = "edit_test role_atlassian-user-role-actor";
    private static final String EDIT_GROUP_ACTORS = "edit_test role_atlassian-group-role-actor";
    private static final String DELETE_ROLE = "delete_test role";
    private static final String EDIT_ROLE = "edit_test role";

    public TestProjectRoles(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
    }

    public void tearDown() {
        super.tearDown();
    }

    public void testProjectRoleOperations() {
        this.restoreBlankInstance();
        this.createProjectRole();
        this.editProjectRole();
        this.editProjectRole(ROLE_NAME_UPPER_CASE);
        this.ensureErrorForDuplicateRoleName();
        this.deleteProjectRole(false);
    }

    public void testProjectRoleActorOperations() {
        this.restoreBlankInstance();
        this.createProjectRole();
        this.gotoProjectRoleActorsForProject("homosapien");
        this.assertTextPresent(ROLE_NAME);
        this.editUsersForRole();
        this.ensureErrorsForUsersInRole();
        this.editGroupsForRole();
        this.deleteUsersForRole();
        this.deleteGroupsForRole();
    }

    public void testAddUsersToProjectRoleCaseSensitive() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_ADMIN_USER_ACTORS);
        this.setFormElement("userNames", "adMIN");
        this.submit("add");
        this.assertTextPresent("'adMIN' does not exist");
        this.assertTextPresent("There are currently no users assigned to this project role.");
    }

    public void testAddGroupsToProjectRoleCaseSensitive() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_ADMIN_GROUP_ACTORS);
        this.setFormElement("groupNames", "jira-USERS");
        this.submit("add");
        this.assertTextPresent("'jira-USERS' does not exist");
        this.assertTextPresent("There are currently no groups assigned to this project role.");
    }

    public void testCreateIssueWithRolePermissions() {
        this.restoreData("TestProjectRoles.xml");
        this.assertLinkNotPresent("create_link");
        this.gotoAdmin();
        this.clickLinkWithText("homosapien");
        this.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.clickLink(EDIT_USER_ACTORS);
        this.setFormElement("userNames", "admin");
        this.submit("add");
        this.assertLinkPresent("create_link");
        this.clickLink("create_link");
        this.assertOptionNotPresent("pid", "monkey");
        this.gotoAdmin();
        this.clickLinkWithText("monkey");
        this.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.clickLink(EDIT_USER_ACTORS);
        this.setFormElement("userNames", "admin");
        this.submit("add");
        this.assertLinkPresent("create_link");
        this.clickLink("create_link");
        this.selectOption("pid", "homosapien");
        this.selectOption("pid", "monkey");
    }

    public void testCreateIssueWithRolePermissionsForGroup() {
        this.restoreData("TestProjectRoles.xml");
        this.assertLinkNotPresent("create_link");
        this.gotoAdmin();
        this.clickLinkWithText("homosapien");
        this.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.clickLink(EDIT_GROUP_ACTORS);
        this.setFormElement("groupNames", "jira-administrators");
        this.submit("add");
        this.assertLinkPresent("create_link");
        this.clickLink("create_link");
        this.assertOptionNotPresent("pid", "monkey");
        this.gotoAdmin();
        this.clickLinkWithText("monkey");
        this.clickLinkWithText(VIEW_PROJECT_ROLES);
        this.clickLink(EDIT_GROUP_ACTORS);
        this.setFormElement("groupNames", "jira-administrators");
        this.submit("add");
        this.assertLinkPresent("create_link");
        this.clickLink("create_link");
        this.selectOption("pid", "homosapien");
        this.selectOption("pid", "monkey");
    }

    public void testAddDefaultUsersAndDefaultGroupsToRole() {
        this.restoreData("TestProjectRoles.xml");
        this.addAdministratorToDefaultRole();
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.clickLink(EDIT_USER_ACTORS);
        this.setFormElement("userNames", "detkin");
        this.submit("add");
        this.assertTextPresent("'detkin' does not exist.");
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.clickLink(EDIT_USER_ACTORS);
        this.setFormElement("userNames", "admin");
        this.submit("add");
        this.assertTextPresent("'admin' is already a member of the project role.");
        this.addGroupsToDefaultRole();
        this.deleteDefaultUsersForRole();
        this.deleteDefaultGroupsForRole();
    }

    public void testDeleteProjectRoleRemovesSchemeEntries() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.deleteProjectRole(true);
        this.clickLink("notification_schemes");
        this.clickLinkWithText("Notifications");
        this.assertTextNotPresent(ROLE_NAME);
        this.gotoPermissionSchemes();
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextNotPresent(ROLE_NAME);
        this.gotoIssueSecuritySchemes();
        this.clickLinkWithText("Default Issue Security Scheme");
        this.assertTextNotPresent(ROLE_NAME);
    }

    public void testDeleteProjectRoleWorkflowConditions() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoAdmin();
        this.clickLink("workflows");
        this.clickLink("steps_live_Copy of jira workflow");
        this.clickLinkWithText("Start Progress");
        this.assertTextPresent("Only users in project role <b>test role</b> can execute this transition.");
        this.clickLink("project_role_browser");
        this.setFormElement("name", "");
        this.clickLink(DELETE_ROLE);
        this.assertTextPresent("The following <strong>1</strong> workflow actions contain conditions that rely on the project role <strong>test role</strong>. If you delete this project role, these conditions will always fail.");
        this.submit("Delete");
        this.clickLink("workflows");
        this.clickLink("steps_live_Copy of jira workflow");
        this.clickLinkWithText("Start Progress");
        this.assertTextPresent("Project Role (id=10000) is missing, now this condition will always fail.");
        this.gotoPage("/secure/admin/workflows/EditWorkflowTransitionConditionParams!default.jspa?workflowStep=1&workflowTransition=4&count=2&workflowName=Copy+of+jira+workflow&workflowMode=live");
        this.selectOption("jira.projectrole.id", "Users");
        this.submit("Update");
        this.assertTextPresent("Only users in project role <b>Users</b> can execute this transition.");
    }

    public void testDeleteUserRemovesFromProjectRole() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoAdmin();
        this.editUsersForRole();
        this.addAdministratorToDefaultRole();
        this.deleteUser("fred");
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.clickLink(EDIT_USER_ACTORS);
        this.assertTextNotPresent("fred");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_USER_ACTORS);
        this.assertTextNotPresent("fred");
    }

    public void testDeleteGroupRemovesFromProjectRole() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoAdmin();
        this.editGroupsForRole();
        this.ensureErrorForDuplicateRoleNameOnEdit();
        this.addGroupsToDefaultRole();
        this.removeGroup("jira-users");
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextNotPresent("jira-users");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextNotPresent("jira-users");
    }

    public void testViewUsages() {
        this.restoreData("TestProjectRoleViewUsages.xml");
        this.gotoViewUsagesForUsersProjectRole();
        this.assertLinkPresentWithText("Other Notification Scheme");
        this.assertLinkPresentWithText("Default Notification Scheme");
        this.assertLinkPresentWithText("Other Permission Scheme");
        this.assertLinkPresentWithText("Default Permission Scheme");
        this.assertTextPresentBeforeText("homosapien", "3 (");
        this.assertTextPresentBeforeText("monkey", "2 (");
        this.assertTextPresentBeforeText("test", "1 (");
        this.assertLinkPresentWithText("test issue security scheme");
        this.assertLinkPresentWithText("jira workflow");
        this.assertLinkPresentWithText("Start Progress");
        this.assertLinkPresentWithText("Stop Progress");
        this.clickLinkWithText("Default Notification Scheme");
        this.assertTextPresent("Edit Notifications &mdash; Default Notification Scheme");
        this.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLinkWithText("Other Notification Scheme");
        this.assertTextPresent("Edit Notifications &mdash; Other Notification Scheme");
        this.assertLinkPresentWithText("Add notification");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLinkWithText("Other Permission Scheme");
        this.assertTextPresent("Edit Permissions &mdash; Other Permission Scheme");
        this.assertLinkPresentWithText("Grant permission");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLinkWithText("Default Permission Scheme");
        this.assertTextPresent("Edit Permissions &mdash; Default Permission Scheme");
        this.assertLinkPresentWithText("Grant permission");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLinkWithText("test issue security scheme");
        this.assertTextPresent("Edit Issue Security Levels");
        this.assertTextPresent("test security level");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLinkWithText("Start Progress");
        this.assertTextPresent("Transition: Start Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLinkWithText("Stop Progress");
        this.assertTextPresent("Transition: Stop Progress");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLinkWithText("homosapien");
        this.assertTextPresent("Project: homosapien");
        this.gotoViewUsagesForUsersProjectRole();
        this.clickLink("view_project_role_actors_10000");
        this.assertTextPresent("Manage Project Role Membership for Project: homosapien");
    }

    private void gotoViewUsagesForUsersProjectRole() {
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.clickLink("view_Users");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectRoleBrowserForProjectAdmin() {
        this.restoreData("TestProjectRoleViewUsages.xml");
        try {
            this.logout();
            this.login("fred", "fred");
            this.gotoAdmin();
            this.clickLinkWithText("monkey");
            this.clickLinkWithText(VIEW_PROJECT_ROLES);
            this.clickLink("edit_Users_atlassian-user-role-actor");
            this.checkCheckbox("removeusers_fred", ".");
            this.submit("remove");
            this.assertTextPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
            this.clickLink("return_link");
            this.clickLink("edit_Users_atlassian-group-role-actor");
            this.setFormElement("groupNames", "jira-users");
            this.submit("add");
            this.clickLink("return_link");
            this.clickLink("edit_Users_atlassian-user-role-actor");
            this.checkCheckbox("removeusers_fred", ".");
            this.submit("remove");
            this.assertTextNotPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
        }
        finally {
            this.logout();
            this.login("admin", "admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectRoleBrowserForNotLoggedInUser() {
        this.restoreData("TestProjectRoleViewUsages.xml");
        try {
            this.logout();
            this.gotoPage("/secure/project/ViewProjectRoleActors.jspa?projectId=10000");
            this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
            this.gotoPage("/secure/project/UserRoleActorAction.jspa?projectRoleId=10000&projectId=10000");
            this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
            this.gotoPage("/secure/project/GroupRoleActorAction.jspa?projectRoleId=10000&projectId=10000");
            this.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform.");
        }
        finally {
            this.logout();
            this.login("admin", "admin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProjectRoleUserRemoveRoleNotInAdminProjectPerm() {
        this.restoreData("TestProjectRoleUserRemoveAdminProjectPerm.xml");
        try {
            this.logout();
            this.login("fred", "fred");
            this.gotoAdmin();
            this.clickLinkWithText("monkey");
            this.clickLinkWithText(VIEW_PROJECT_ROLES);
            this.clickLink("edit_Users_atlassian-user-role-actor");
            this.checkCheckbox("removeusers_fred", ".");
            this.submit("remove");
            this.assertTextNotPresent("You can not remove a user/group that will result in completely removing yourself from this role.");
        }
        finally {
            this.logout();
            this.login("admin", "admin");
        }
    }

    public void testProjectRoleGroupAddRemoveErrorMessage() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoAdmin();
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextPresent("Assign Groups to Project Role: test role");
        this.setFormElement("groupNames", "jira-users");
        this.submit("add");
        this.assertTextPresent("jira-users");
        this.submit("remove");
        this.assertTextPresent("You must select some groups to remove.");
        this.submit("add");
        this.assertTextPresent("You must input some group names to add them to the project role.");
        this.assertTextPresent("jira-users");
    }

    public void testProjectRoleGroupBrowserWithNoBrowserUserPermission() {
        this.restoreData("TestProjectRoles.xml");
        this.gotoAdmin();
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextPresent("Assign Groups to Project Role: test role");
        this.assertLinkPresentWithImage("/images/icons/filter_public.gif");
        this.assertLinkNotPresentWithImage("/images/icons/userpicker_disabled.gif");
        this.removeGlobalPermission(27, "jira-developers");
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextPresent("Assign Groups to Project Role: test role");
        this.assertTextPresent("/images/icons/userpicker_disabled.gif");
        this.assertTextNotPresent("/images/icons/filter_public.gif");
    }

    private void addGroupsToDefaultRole() {
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.assertTextPresent("None selected");
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextPresent("Assign Default Groups to Project Role: test role");
        this.setFormElement("groupNames", "jira-users, jira-developers, jira-administrators");
        this.submit("add");
        this.clickLink("return_link");
        this.assertTextPresent("jira-administrators");
        this.assertTextPresent("jira-users");
        this.assertTextPresent("jira-developers");
        this.clickLink("return_link");
        this.assertTextPresent("Project Role Browser");
    }

    private void addAdministratorToDefaultRole() {
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.assertTextPresent("None selected.");
        this.clickLink(EDIT_USER_ACTORS);
        this.assertTextPresent("Assign Default Users to Project Role: test role");
        this.setFormElement("userNames", "admin, fred");
        this.submit("add");
        this.clickLink("return_link");
        this.assertTextPresent("Administrator");
        this.clickLink("return_link");
        this.assertTextPresent("Project Role Browser");
    }

    private void deleteDefaultUsersForRole() {
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.clickLink(EDIT_USER_ACTORS);
        this.assertTextPresent("Assign Default Users to Project Role: test role");
        this.checkCheckbox("removeusers_admin", ".");
        this.checkCheckbox("removeusers_fred", ".");
        this.submit("remove");
        this.assertTextPresent("There are currently no users assigned to this project role.");
    }

    private void deleteDefaultGroupsForRole() {
        this.gotoAdmin();
        this.clickLink("project_role_browser");
        this.clickLink("manage_test role");
        this.deleteGroupsFromRoleForm("Assign Default Groups to Project Role: test role");
    }

    private void deleteGroupsForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.deleteGroupsFromRoleForm("Assign Groups to Project Role: test role");
    }

    private void deleteGroupsFromRoleForm(String textPresent) {
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextPresent(textPresent);
        this.checkCheckbox("removegroups_jira-users", ".");
        this.checkCheckbox("removegroups_jira-developers", ".");
        this.checkCheckbox("removegroups_jira-administrators", ".");
        this.submit("remove");
        this.assertTextPresent("There are currently no groups assigned to this project role");
    }

    private void deleteUsersForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_USER_ACTORS);
        this.assertTextPresent("Assign Users to Project Role: test role");
        this.checkCheckbox("removeusers_admin", ".");
        this.checkCheckbox("removeusers_fred", ".");
        this.submit("remove");
        this.assertTextPresent("There are currently no users assigned to this project role.");
    }

    private void ensureErrorsForUsersInRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_USER_ACTORS);
        this.assertTextPresent("Assign Users to Project Role: test role");
        this.setFormElement("userNames", "fred, admin, detkin");
        this.submit("add");
        this.assertTextPresent("'detkin' does not exist.");
        this.assertTextPresent("'fred' is already a member of the project role.");
        this.assertTextPresent("'admin' is already a member of the project role.");
        this.clickLink("return_link");
    }

    private void editGroupsForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_GROUP_ACTORS);
        this.assertTextPresent("Assign Groups to Project Role: test role");
        this.setFormElement("groupNames", "jira-users, jira-developers, jira-administrators");
        this.submit("add");
        this.clickLink("return_link");
        this.assertTextPresent("jira-users");
        this.assertTextPresent("jira-developers");
        this.assertTextPresent("jira-administrators");
    }

    private void editUsersForRole() {
        this.gotoProjectRoleActorsForProject("homosapien");
        this.clickLink(EDIT_USER_ACTORS);
        this.assertTextPresent("Assign Users to Project Role: test role");
        this.setFormElement("userNames", "fred, admin");
        this.submit("add");
        this.assertTextPresent("Fred Normal");
        this.assertTextPresent("Administrator");
        this.clickLink("return_link");
        this.assertTextPresent("Fred Normal");
        this.assertTextPresent("Administrator");
    }

    private void deleteProjectRole(boolean checkAssociatedSchemes) {
        this.clickLink(DELETE_ROLE);
        this.assertTextPresent("Are you sure you would like to delete project role");
        this.assertTextPresent(ROLE_NAME);
        if (checkAssociatedSchemes) {
            this.assertLinkPresentWithText("Default Notification Scheme");
            this.assertLinkPresentWithText("Default Permission Scheme");
            this.assertLinkPresentWithText("Default Issue Security Scheme");
            this.assertTextPresent("Copy of jira workflow");
            this.assertLinkPresentWithText("Start Progress");
        }
        this.submit("Delete");
        this.setFormElement("name", "");
        this.assertTextNotPresent(ROLE_NAME);
        this.assertTextNotPresent(ROLE_UPDATED_DESC);
    }

    private void ensureErrorForDuplicateRoleName() {
        this.setFormElement("name", ROLE_NAME);
        this.setFormElement("description", "");
        this.submit("Add Project Role");
        this.assertTextPresent("A project role with name 'test role' already exists.");
    }

    private void ensureErrorForDuplicateRoleNameOnEdit() {
        this.clickLink("project_role_browser");
        this.setFormElement("name", "anotherRole");
        this.setFormElement("description", "test");
        this.submit("Add Project Role");
        this.clickLink("edit_anotherRole");
        this.setFormElement("name", ROLE_NAME);
        this.submit("Update");
        this.assertTextPresent("A project role with name 'test role' already exists.");
    }

    private void editProjectRole() {
        this.editProjectRole(ROLE_UPDATED_NAME);
    }

    private void editProjectRole(String newRoleName) {
        this.clickLink(EDIT_ROLE);
        this.setFormElement("name", newRoleName);
        this.setFormElement("description", ROLE_UPDATED_DESC);
        this.submit("Update");
        this.assertTextPresent(newRoleName);
        this.assertTextPresent(ROLE_UPDATED_DESC);
        this.clickLink("edit_" + newRoleName);
        this.setFormElement("name", ROLE_NAME);
        this.setFormElement("description", ROLE_DESC);
        this.submit("Update");
    }

    private void createProjectRole() {
        this.gotoProjectRolesScreen();
        this.setFormElement("name", ROLE_NAME);
        this.setFormElement("description", ROLE_DESC);
        this.submit("Add Project Role");
        this.assertTextPresent(ROLE_NAME);
        this.assertTextPresent(ROLE_DESC);
    }
}

