/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.assertions.LinkAssertions;
import com.atlassian.jira.functest.framework.assertions.LinkAssertionsImpl;
import com.atlassian.jira.functest.framework.parser.SystemInfoParserImpl;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.ImageCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.TextCell;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestProjectComponentQuickSearch
extends JIRAWebTest {
    String appServer;
    private LinkAssertions linkAssertions;

    public TestProjectComponentQuickSearch(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        this.restoreData("TestProjectComponentQuickSearch.xml");
        SystemInfoParserImpl systemInfoParser = new SystemInfoParserImpl(this.getTester());
        this.appServer = systemInfoParser.getSystemInfo().getAppServer();
        this.linkAssertions = new LinkAssertionsImpl(this.tester, this.getEnvironmentData());
    }

    public void tearDown() {
        super.tearDown();
    }

    public void testProjectComponentQuickSearchMultipleProjects() throws Exception {
        WebTable issueTable = this.assertComponentQuickSearch("", 5);
        this.assertLinkPresentWithoutSubString("permlink", "pid");
        this.assertLinkPresentWithoutSubString("permlink", "component");
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("c:one", 1);
        this.assertLinkWithTextExists("Query Syntax");
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "component = \"one two homo three four five\"");
        this.assertIssueTableHasHSP_12345(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced(" c:two ", 2);
        this.assertLinkWithTextExists("Query Syntax");
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "component in (\"one two homo three four five\", \"two three homo four five\")");
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("three c:three", 3);
        this.assertLinkWithTextExists("Query Syntax");
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "(summary ~ three OR description ~ three OR comment ~ three) AND component in (\"one two homo three four five\", \"two three homo four five\", \"three monk five\")");
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_35(issueTable);
        issueTable = this.assertComponentQuickSearchOnAdvanced("c:four four", 4);
        this.assertLinkWithTextExists("Query Syntax");
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "(summary ~ four OR description ~ four OR comment ~ four) AND component in (\"homo four five\", \"one two homo three four five\", \"two three homo four five\", \"monk five four\")");
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        if (this.appServer.indexOf("WebSphere") == -1) {
            issueTable = this.assertComponentQuickSearchOnAdvanced("five c:five five", 5);
            this.assertLinkWithTextExists("Query Syntax");
            this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "(summary ~ \"five  five\" OR description ~ \"five  five\" OR comment ~ \"five  five\") AND component in (\"homo four five\", \"one two homo three four five\", \"two three homo four five\", \"monk five four\", \"three monk five\")");
            this.assertIssueTableHasHSP_12345(issueTable);
            this.assertIssueTableHasHSP_2345(issueTable);
            this.assertIssueTableHasMKY_35(issueTable);
            this.assertIssueTableHasMKY_45(issueTable);
            this.assertIssueTableHasHSP_45(issueTable);
        }
    }

    public void testProjectComponentQuickSearchHomosapienProject() throws SAXException {
        WebTable issueTable = this.assertComponentQuickSearch("hsp c:one", 1);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = HSP AND component = \"one two homo three four five\"");
        this.assertIssueTableHasHSP_12345(issueTable);
        issueTable = this.assertComponentQuickSearch(" c:two homosapien ", 2);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = HSP AND component in (\"one two homo three four five\", \"two three homo four five\")");
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearch("three HSP c:three", 2);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = HSP AND (summary ~ three OR description ~ three OR comment ~ three) AND component in (\"one two homo three four five\", \"two three homo four five\")");
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        issueTable = this.assertComponentQuickSearch("c:four four HOMOSAPIEN", 3);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = HSP AND (summary ~ four OR description ~ four OR comment ~ four) AND component in (\"homo four five\", \"one two homo three four five\", \"two three homo four five\")");
        this.assertIssueTableHasHSP_12345(issueTable);
        this.assertIssueTableHasHSP_2345(issueTable);
        this.assertIssueTableHasHSP_45(issueTable);
        if (this.appServer.indexOf("WebSphere") == -1) {
            issueTable = this.assertComponentQuickSearch("hsp five c:five five", 3);
            this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = HSP AND (summary ~ \"five  five\" OR description ~ \"five  five\" OR comment ~ \"five  five\") AND component in (\"homo four five\", \"one two homo three four five\", \"two three homo four five\")");
            this.assertIssueTableHasHSP_12345(issueTable);
            this.assertIssueTableHasHSP_2345(issueTable);
            this.assertIssueTableHasHSP_45(issueTable);
        }
    }

    public void testProjectComponentQuickSearchMonkey() throws SAXException {
        WebTable issueTable = this.assertComponentQuickSearch("c:one MONKEY", 2);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = MKY");
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch(" MKY c:two ", 2);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = MKY");
        this.assertIssueTableHasMKY_35(issueTable);
        this.assertIssueTableHasMKY_45(issueTable);
        issueTable = this.assertComponentQuickSearch("monkey three c:three", 1);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = MKY AND (summary ~ three OR description ~ three OR comment ~ three) AND component = \"three monk five\"");
        this.assertIssueTableHasMKY_35(issueTable);
        issueTable = this.assertComponentQuickSearch("c:four mky four", 1);
        this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = MKY AND (summary ~ four OR description ~ four OR comment ~ four) AND component = \"monk five four\"");
        this.assertIssueTableHasMKY_45(issueTable);
        if (this.appServer.indexOf("WebSphere") == -1) {
            issueTable = this.assertComponentQuickSearch("five c:five five monkey", 2);
            this.linkAssertions.assertLinkIdQueryStringContainsJqlQuery("permlink", "project = MKY AND (summary ~ \"five  five\" OR description ~ \"five  five\" OR comment ~ \"five  five\") AND component in (\"monk five four\", \"three monk five\")");
            this.assertIssueTableHasMKY_35(issueTable);
            this.assertIssueTableHasMKY_45(issueTable);
        }
    }

    private WebTable assertComponentQuickSearch(String searchInput, int numOfResults) throws SAXException {
        this.runQuickSearch(searchInput);
        this.assertIssueNavigatorDisplaying("1", String.valueOf(numOfResults), String.valueOf(numOfResults));
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestProjectComponentQuickSearch.assertEquals((int)(numOfResults + 1), (int)issueTable.getRowCount());
        this.assertTableHasMatchingRowFromTo(issueTable, 0, 1, new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "Pr", "Status", "Res", "Created", "Updated", "Due"});
        return issueTable;
    }

    private WebTable assertComponentQuickSearchOnAdvanced(String searchInput, int numOfResults) throws SAXException {
        this.runQuickSearch(searchInput);
        this.assertAdvacnedIssueNavigatorDisplaying("1", String.valueOf(numOfResults), String.valueOf(numOfResults));
        WebTable issueTable = this.getDialog().getResponse().getTableWithID("issuetable");
        TestProjectComponentQuickSearch.assertEquals((int)(numOfResults + 1), (int)issueTable.getRowCount());
        this.assertTableHasMatchingRowFromTo(issueTable, 0, 1, new Object[]{"T", "Key", "Summary", "Assignee", "Reporter", "Pr", "Status", "Res", "Created", "Updated", "Due"});
        return issueTable;
    }

    private void assertAdvacnedIssueNavigatorDisplaying(String from, String to, String of) {
        this.assertTextPresent("Displaying issues <strong>" + from + "</strong> to <strong>" + to + "</strong> of <strong>" + of + "</strong> matching issues");
    }

    private void assertIssueTableHasHSP_45(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-1", ""), new ImageCell("/images/icons/bug.gif")), new LinkCell("/browse/HSP-1", "HSP-1"), "homo four five", "Administrator", "Administrator", new ImageCell("/images/icons/priority_major.gif"), new AndCell(new ImageCell("/images/icons/status_open.gif"), new TextCell("Open")), "UNRESOLVED", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasHSP_12345(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-2", ""), new ImageCell("/images/icons/task.gif")), new LinkCell("/browse/HSP-2", "HSP-2"), "one two homo three four five", "Administrator", "Administrator", new ImageCell("/images/icons/priority_major.gif"), new AndCell(new ImageCell("/images/icons/status_open.gif"), new TextCell("Open")), "UNRESOLVED", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasHSP_2345(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/HSP-3", ""), new ImageCell("/images/icons/improvement.gif")), new LinkCell("/browse/HSP-3", "HSP-3"), "two three homo four five", "Administrator", "Administrator", new ImageCell("/images/icons/priority_major.gif"), new AndCell(new ImageCell("/images/icons/status_open.gif"), new TextCell("Open")), "UNRESOLVED", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasMKY_35(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/MKY-2", ""), new ImageCell("/images/icons/newfeature.gif")), new LinkCell("/browse/MKY-2", "MKY-2"), "three monk five", "Administrator", "Administrator", new ImageCell("/images/icons/priority_major.gif"), new AndCell(new ImageCell("/images/icons/status_open.gif"), new TextCell("Open")), "UNRESOLVED", "23/Nov/07", "23/Nov/07", ""});
    }

    private void assertIssueTableHasMKY_45(WebTable issueTable) {
        this.assertTableHasMatchingRow(issueTable, new Object[]{new AndCell(new LinkCell("/browse/MKY-1", ""), new ImageCell("/images/icons/bug.gif")), new LinkCell("/browse/MKY-1", "MKY-1"), "monk five four", "Administrator", "Administrator", new ImageCell("/images/icons/priority_major.gif"), new AndCell(new ImageCell("/images/icons/status_open.gif"), new TextCell("Open")), "UNRESOLVED", "23/Nov/07", "23/Nov/07", ""});
    }
}

