/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestProjectCategory
extends JIRAWebTest {
    private static final String CATEGORY_NAME = "New Project Category For Testing";
    private static final String CATEGORY_DESCRIPTION = "Testing for project category";

    public TestProjectCategory(String name) {
        super(name);
    }

    public void testProjectCategory() {
        if (this.projectExists("homosapien")) {
            TestProjectCategory.log("Project: homosapien exists");
        } else {
            this.addProject("homosapien", "HSP", "", "admin", "project for homsapiens.");
        }
        if (this.projectCategoryExists(CATEGORY_NAME)) {
            this.deleteProjectCategory(CATEGORY_NAME);
        }
        this.projectCategoryAddProjectCategory();
        this.projectCategoryDeleteProjectCategory();
        this.projectCategoryPlaceProjectInProjectCategory();
        this.projectCategoryAddDuplicateCategory();
        this.projectCategoryAddInvalidCategory();
        this.placeProjectInCategory("homosapien", "None");
        this.deleteProjectCategory(CATEGORY_NAME);
    }

    public void projectCategoryAddProjectCategory() {
        TestProjectCategory.log("Project Category: Add project category");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.assertTextPresent(CATEGORY_NAME);
    }

    public void projectCategoryDeleteProjectCategory() {
        TestProjectCategory.log("Project Category: Delete project category");
        this.deleteProjectCategory(CATEGORY_NAME);
        this.assertTextNotPresent(CATEGORY_NAME);
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
    }

    public void projectCategoryPlaceProjectInProjectCategory() {
        TestProjectCategory.log("Project Category: Place a project in a project category");
        this.placeProjectInCategory("homosapien", CATEGORY_NAME);
        this.assertTextPresent(CATEGORY_NAME);
    }

    public void projectCategoryAddDuplicateCategory() {
        TestProjectCategory.log("Project Category: Attempt to create a project category with a duplicate name");
        this.createProjectCategory(CATEGORY_NAME, CATEGORY_DESCRIPTION);
        this.assertTextPresent("The project category 'New Project Category For Testing' already exists");
    }

    public void projectCategoryAddInvalidCategory() {
        TestProjectCategory.log("Project Category: Attempt to create a project category with an invalid name");
        this.createProjectCategory("", "");
        this.assertTextPresent("Please specify a name");
    }
}

