/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestProjectActions
extends JIRAWebTest {
    private String PROJECT_CHIMP = "Chimps";

    public TestProjectActions(String name) {
        super(name);
    }

    public void testAddProject() {
        this.addProject("homosapien", "HSP", "", "admin", "project for homosapiens");
        this.assertTextPresent("Project: homosapien");
        this.assertTextPresent("Components");
        this.assertTextPresent("Versions");
        this.addProject("neanderthal", "NDT", "", "admin", "project for neanderthals");
        this.assertTextPresent("Project: neanderthal");
        this.addProject("monkey", "MKY", "", "admin", "project for monkeys");
        this.assertTextPresent("Project: monkey");
    }

    public void testAddProjectWithDefaultRoles() {
        this.restoreData("TestProjectActions.xml");
        this.addProject(this.PROJECT_CHIMP, "CHM", "", "admin", "project for chimps");
        this.goToProject(this.PROJECT_CHIMP);
        this.clickLinkWithText("View members");
        this.assertTextPresent(" Manage Project Role Membership for Project: Chimps");
        this.assertTextPresent("default role");
        this.assertTextPresent("Fred Normal");
        this.assertTextPresent("Administrator");
        this.assertTextPresent("jira-users");
        this.assertTextPresent("jira-developers");
    }

    public void projectActionInvalidProjectLead() {
        TestProjectActions.log("Project Action: Test for the existence of a warning if a Project Lead is made Unassignable");
        this.removeGroupPermission(17, "jira-developers");
        this.goToProject("homosapien");
        this.assertTextPresent("WARNING: User not Assignable.");
        this.grantGroupPermission(17, "jira-developers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBrowseProjectWithPermission() {
        try {
            this.removeGroupPermission(10, "jira-users");
            this.addUser("bob", "bob_password", "Bob The Builder", "bob@stuff.com.com");
            this.logout();
            this.login("bob", "bob_password");
            this._testBrowseProjectWithoutPermission();
        }
        finally {
            try {
                this.logout();
                this.login("admin", "admin");
                this.deleteUser("bob");
                this.grantGroupPermission(10, "jira-users");
            }
            catch (Exception exception) {}
        }
    }

    public void _testBrowseProjectWithoutPermission() {
        this.beginAt("/secure/BrowseProject.jspa");
        this.assertTextPresent("You do not have the permissions required to browse any projects.");
    }
}

