/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;

public class TestIssuesProjectTabPanel
extends FuncTestCase {
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssuesProjectTabPanel.xml");
    }

    public void testUnresolvedByComponentVisibility() throws Exception {
        this.assertFragmentNotPresent("TestIssuesProjectTabPanel_ComponentsHiddenInFieldScheme.xml", "fragunresolvedissuesbycomponent", "Unresolved: By Component");
    }

    public void testUnresolvedByPriorityVisibility() throws Exception {
        this.assertFragmentNotPresent("TestIssuesProjectTabPanel_PriorityHiddenInFieldScheme.xml", "fragunresolvedissuesbypriority", "Unresolved: By Priority");
    }

    public void testStatusSummaryNoIssues() {
        this.deleteAllIssuesAndAssertNoIssues("fragstatussummary");
    }

    public void testUnresolvedByComponentNoIssues() {
        this.deleteAllIssuesAndAssertNoIssues("fragunresolvedissuesbycomponent");
    }

    public void testUnresolvedByPriorityNoIssues() {
        this.deleteAllIssuesAndAssertNoIssues("fragunresolvedissuesbypriority");
    }

    public void testStatusSummaryLinkOnPriority() {
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLinkWithText("Open");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldstatus", "Open");
        this.assertSearchOrder("Priority descending");
    }

    public void testUnresolvedByPriorityLinkOnPriority() {
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLinkWithText("Blocker");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldpriority", "Blocker");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Key descending");
    }

    public void testUnresolvedByComponentLinkOnNoComponent() {
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLinkWithText("No Component");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldcomponent", "no components");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
    }

    public void testUnresolvedByPriorityHeaderLinkAndStats() {
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/h3"), "Unresolved: By Priority");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/table//td");
        this.text.assertTextSequence(pathLocator, "Blocker", "1", "17%", "Major", "3", "50%", "Minor", "1", "17%", "Trivial", "1", "17%");
        this.tester.clickLink("fragunresolvedissuesbypriority_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
        this.setPriority("HSP-4", "Critical");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/table//td");
        this.text.assertTextSequence(pathLocator, "Blocker", "1", "17%", "Critical", "1", "17%", "Major", "3", "50%", "Trivial", "1", "17%");
        this.resolveIssue("HSP-4", null);
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbypriority']/table//td");
        this.text.assertTextSequence(pathLocator, "Blocker", "1", "20%", "Major", "3", "60%", "Trivial", "1", "20%");
    }

    public void testUnresolvedByComponentHeaderLink() {
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/h3"), "Unresolved: By Component");
        this.tester.clickLink("fragunresolvedissuesbycomponent_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Component/s ascending");
    }

    public void testStatusSummaryHeaderLink() {
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragstatussummary']/h3"), "Status Summary");
        this.tester.clickLink("fragstatussummary_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearchOrder("Status descending");
    }

    public void testStatusSummaryStats() throws Exception {
        this.administration.restoreData("TestIssuesProjectTabPanel_StatusSummary.xml");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragstatussummary']/table//td");
        this.text.assertTextSequence(pathLocator, "Open", "6", "50%", "In Progress", "1", "8%", "Reopened", "1", "8%", "Resolved", "2", "17%", "Closed", "2", "17%");
    }

    public void testUnresolvedByComponentStats() {
        this.navigation.browseProjectTabPanel("HSP", "issues");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/div");
        this.text.assertTextSequence(pathLocator, "6", "No Component");
        this.text.assertTextNotPresent(pathLocator, "New Component");
        this.navigation.issue().setComponents("HSP-1", "New Component 1");
        this.navigation.issue().setComponents("HSP-2", "New Component 2");
        this.navigation.issue().setComponents("HSP-3", "New Component 3");
        this.navigation.issue().setComponents("HSP-4", "New Component 1");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/div");
        this.text.assertTextSequence(pathLocator, "2", "New Component 1", "1", "New Component 2", "1", "New Component 3", "2", "No Component");
        this.resolveIssue("HSP-3", null);
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbycomponent']/div");
        this.text.assertTextSequence(pathLocator, "2", "New Component 1", "1", "New Component 2", "2", "No Component");
        this.tester.clickLinkWithText("New Component 1");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldcomponent", "New Component 1");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLinkWithText("New Component 2");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldcomponent", "New Component 2");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Priority descending");
    }

    public void testUnresolvedByAssignee() {
        this.administration.restoreData("TestIssuesProjectTabPanel_UnresolvedIssuesByAssignee.xml");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLink("fragunresolvedissuesbyassignee_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Assignee ascending");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/table//td");
        this.text.assertTextSequence(pathLocator, "Administrator", "1", "9%", "Big Boo", "1", "9%", "Charles", "1", "9%", "David Developer", "1", "9%", "Erik Eagle", "1", "9%", "Fred Normal", "1", "9%", "George Gray", "1", "9%", "Harry Henderson", "1", "9%", "Sleepy ZZZ", "1", "9%", "Xanadu", "1", "9%", "Unassigned", "1", "9%");
        this.assignIssue("HSP-1", "Unassigned");
        this.assignIssue("HSP-2", "Harry Henderson");
        this.assignIssue("HSP-3", "George Gray");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/table//td");
        this.text.assertTextSequence(pathLocator, "Charles", "1", "9%", "David Developer", "1", "9%", "Erik Eagle", "1", "9%", "George Gray", "2", "18%", "Harry Henderson", "2", "18%", "Sleepy ZZZ", "1", "9%", "Xanadu", "1", "9%", "Unassigned", "2", "18%");
        this.resolveIssue("HSP-3", null);
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/table//td");
        this.text.assertTextSequence(pathLocator, "Charles", "1", "10%", "David Developer", "1", "10%", "Erik Eagle", "1", "10%", "George Gray", "1", "10%", "Harry Henderson", "2", "20%", "Sleepy ZZZ", "1", "10%", "Xanadu", "1", "10%", "Unassigned", "2", "20%");
        this.tester.clickLinkWithText("Unassigned");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearcherField("fieldassignee", "Unassigned");
        this.assertSearchOrder("Priority descending");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLinkWithText("Harry Henderson");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearcherField("fieldassignee", "harry");
        this.assertSearchOrder("Priority descending");
        for (int i = 1; i <= 11; ++i) {
            this.navigation.issue().deleteIssue("HSP-" + i);
        }
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyassignee']/p"), "No issues");
        this.tester.assertLinkNotPresent("fragunresolvedissuesbyassignee_more");
        this.assertFragmentNotPresent("TestIssuesProjectTabPanel_AssigneeHiddenInFieldScheme.xml", "fragunresolvedissuesbyassignee", "Unresolved: By Assignee");
    }

    public void testUnresolvedByVersion() {
        this.administration.restoreData("TestIssuesProjectTabPanel_UnresolvedIssuesByVersion.xml");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLink("fragunresolvedissuesbyfixversion_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Fix Version/s ascending");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyfixversion']/div");
        this.text.assertTextSequence(pathLocator, "1", "New Version 1", "1", "New Version 2", "1", "New Version 3", "1", "New Version 4", "1", "New Version 5", "1", "New Version 6", "1", "New Version 7", "1", "New Version 8", "1", "New Version 9", "1", "New Version A", "1", "New Version B", "1", "Unscheduled");
        this.scheduleIssueFixVersion("HSP-1", "Unknown");
        this.scheduleIssueFixVersion("HSP-2", "New Version 9");
        this.scheduleIssueFixVersion("HSP-3", "New Version A");
        this.scheduleIssueFixVersion("HSP-4", "New Version B");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyfixversion']/div");
        this.text.assertTextSequence(pathLocator, "1", "New Version 5", "1", "New Version 6", "1", "New Version 7", "1", "New Version 8", "2", "New Version 9", "2", "New Version A", "2", "New Version B", "2", "Unscheduled");
        this.resolveIssue("HSP-5", null);
        this.resolveIssue("HSP-6", null);
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyfixversion']/div");
        this.text.assertTextSequence(pathLocator, "1", "New Version 7", "1", "New Version 8", "2", "New Version 9", "2", "New Version A", "2", "New Version B", "2", "Unscheduled");
        this.text.assertTextNotPresent(pathLocator, "New Version 5");
        this.text.assertTextNotPresent(pathLocator, "New Version 6");
        this.administration.project().releaseVersion("homosapien", "New Version 7", null);
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyfixversion']/div");
        this.text.assertTextSequence(pathLocator, "1", "New Version 7", "1", "New Version 8", "2", "New Version 9", "2", "New Version A", "2", "New Version B", "2", "Unscheduled");
        this.administration.project().archiveVersion("homosapien", "New Version 8");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        pathLocator = new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyfixversion']/div");
        this.text.assertTextSequence(pathLocator, "1", "New Version 7", "1", "New Version 8", "2", "New Version 9", "2", "New Version A", "2", "New Version B", "2", "Unscheduled");
        this.tester.clickLinkWithText("Unscheduled");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearcherField("fieldfixfor", "no versions");
        this.assertSearchOrder("Priority descending");
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.tester.clickLinkWithText("New Version A");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearcherField("fieldfixfor", "New Version A");
        this.assertSearchOrder("Priority descending");
        for (int i = 1; i <= 12; ++i) {
            this.navigation.issue().deleteIssue("HSP-" + i);
        }
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragunresolvedissuesbyfixversion']/p"), "No issues");
        this.tester.assertLinkNotPresent("fragunresolvedissuesbyfixversion_more");
        this.assertFragmentNotPresent("TestIssuesProjectTabPanel_FixVersionHiddenInFieldScheme.xml", "fragunresolvedissuesbyfixversion", "Unresolved: By Version");
    }

    private void assertSearchOrder(String expected) {
        XPathLocator pathLocator = new XPathLocator(this.tester, "//*[@id='filter-summary']/div");
        this.text.assertTextSequence(pathLocator, "Sorted by", expected);
    }

    private void assignIssue(String issueKey, String assigneeName) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("assign_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("assignee", assigneeName);
        this.tester.submit("Assign");
    }

    private void scheduleIssueFixVersion(String issueKey, String fixVersion) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("fixVersions", fixVersion);
        this.tester.submit("Update");
    }

    private void resolveIssue(String issueKey, String fixVersion) {
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("action_id_5");
        this.tester.setWorkingForm("jiraform");
        if (fixVersion != null) {
            this.tester.selectOption("fixVersions", fixVersion);
        }
        this.tester.submit("Resolve");
    }

    private void assertSearcherField(String elementId, String expectedText) {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@id='" + elementId + "']"), expectedText);
    }

    private void setPriority(String key, String priority) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("edit_issue");
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("priority", priority);
        this.tester.submit();
    }

    private void assertFragmentNotPresent(String xmlBackup, String fragId, String title) {
        this.administration.restoreData(xmlBackup);
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='" + fragId + "']/h3"), title);
    }

    private void deleteAllIssuesAndAssertNoIssues(String fragId) {
        for (String key : new String[]{"HSP-1", "HSP-2", "HSP-3", "HSP-4", "HSP-5", "HSP-6"}) {
            this.navigation.issue().deleteIssue(key);
        }
        this.navigation.browseProjectTabPanel("HSP", "issues");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='" + fragId + "']/p"), "No issues");
    }
}

