/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

public class TestValidationDoesItFit
extends AbstractJqlFuncTest {
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestValidationDoesItFit.xml");
    }

    public void testFunctionValidationDoesntFit() throws Exception {
        this.navigation.issueNavigator().loadFilter(10000L, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        TestValidationDoesItFit.assertEquals((Object)((Object)this.navigation.issueNavigator().getCurrentMode()), (Object)((Object)IssueNavigatorNavigation.NavigatorMode.EDIT));
        TestValidationDoesItFit.assertEquals((Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()), (Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.ADVANCED));
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'subTaskIssueTypes' is invalid as sub-tasks are currently disabled.");
    }

    public void testSimpleIssueNavigatorValidationDoesntFit() throws Exception {
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "pid=1232133");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '1232133' does not exist for the field 'project'.");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "type=-3");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("Function 'subTaskIssueTypes' is invalid as sub-tasks are currently disabled.");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "type=2343");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '2343' does not exist for the field 'issuetype'.");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "reporterSelect=specificuser", "reporter=sfdsf");
        this.tester.assertTextPresent("Could not find username: sfdsf");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "assigneeSelect=specificuser", "assignee=sfdsf");
        this.tester.assertTextPresent("Could not find username: sfdsf");
        this.navigation.logout();
        this.tester.gotoPage("secure");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "reporterSelect=issue_current_user");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(new String[0]);
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "assigneeSelect=issue_current_user");
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(new String[0]);
        this.navigation.login("admin");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "status=78");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '78' does not exist for the field 'status'.");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "resolution=78");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '78' does not exist for the field 'resolution'.");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "priority=78");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '78' does not exist for the field 'priority'.");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "customfield_10001=10003", "customfield_10001:1=10008");
        this.tester.assertTextPresent("The option 'Child Option 2' is an invalid option in the context 'Default Configuration for Cascading Select CF'");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "customfield_10016=23423423");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("A value with ID '23423423' does not exist for the field 'Project Picker CF'.");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "customfield_10017=Blub");
        this.tester.assertTextPresent("Invalid value 'Blub' passed for customfield 'Radio Buttons CF'. Allowed values are: Radio Option 1, Radio Option 2");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, true, "customfield_10000=Blub");
        this.tester.assertTextPresent("Invalid value 'Blub' passed for customfield 'Select List CF'. Allowed values are: option 1, option 2, option 3");
        this.executeIssueNavigatorURL(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED, true, "customfield_10018=A Version that doesn't exist");
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors("The value 'A Version that doesn't exist' does not exist for the field 'Single Version Picker CF'.");
    }
}

