/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.email.EmailKit;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.webtests.JIRAEmailTest;
import com.icegreen.greenmail.util.GreenMail;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;

public class TestUpgradeTask428
extends JIRAEmailTest {
    public void testDoUpgrade() throws Exception {
        this.administration.restoreBlankInstance();
        this.assertSendingMailIsEnabled();
        GreenMail greenMail = this.configureAndStartGreenMailSmtp();
        LinkedHashMap<String, String> replaceTokens = new LinkedHashMap<String, String>();
        replaceTokens.put("@@SMTPPORT@@", Integer.toString(greenMail.getSmtp().getPort()));
        replaceTokens.put("@@CREATED_FROM@@", TestUpgradeTask428.createDate(2009, 1, 1));
        replaceTokens.put("@@CREATED_TO@@", TestUpgradeTask428.createDate(2009, 4, 1));
        replaceTokens.put("@@UPDATED_FROM@@", TestUpgradeTask428.createDate(2009, 0, 1));
        replaceTokens.put("@@UPDATED_TO@@", TestUpgradeTask428.createDate(2009, 5, 1));
        replaceTokens.put("@@DATEPICK_FROM@@", TestUpgradeTask428.createDate(2009, 7, 1, 11, 11));
        replaceTokens.put("@@DATEPICK_TO@@", TestUpgradeTask428.createDate(2009, 8, 1, 12, 12));
        this.administration.restoreDataWithReplacedTokens("TestUpgradeTask428.xml", replaceTokens);
        this.flushMailQueueAndWait(2);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        MimeMessage currentMessage = EmailKit.findMessageAddressedTo("admin@example.com", messages);
        TestUpgradeTask428.assertNotNull((Object)currentMessage);
        String body = EmailKit.getBody((Part)currentMessage);
        this.text.assertTextSequence(body, "BadXml", "/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=10020");
        this.text.assertTextSequence(body, "NoHandler", "/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=10023");
        this.text.assertTextSequence(body, "BestGuess", "/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=10024");
        this.text.assertTextSequence(body, "FailedToMapDocConst", "/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=10025");
        this.text.assertTextNotPresent(body, "FullConvert");
        currentMessage = EmailKit.findMessageAddressedTo("fred@example.com", messages);
        TestUpgradeTask428.assertNotNull((Object)currentMessage);
        body = EmailKit.getBody((Part)currentMessage);
        this.text.assertTextSequence(body, "OrderFailNoSortEl", "/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=10026");
        this.text.assertTextSequence(body, "OrderFailNoSortField", "/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=10027");
        this.text.assertTextSequence(body, "OrderFailNoClauseName", "/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=10028");
        ArrayList<SearchResultsCondition> conditions = new ArrayList<SearchResultsCondition>();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), "HSP-2"));
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), 1));
        this.navigation.issueNavigator().loadFilter(10022L, null);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setWorkingForm("jqlform");
        String convertedJql = this.tester.getDialog().getForm().getParameterValue("jqlQuery");
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("project = HSP"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("issuetype = \"New Feature\""));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("summary ~ SOAP"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("description ~ SOAP"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("fixVersion = EMPTY"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("component = \"New Component 3\""));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("affectedVersion = EMPTY"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("reporter = currentUser()"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("assignee = admin"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("status = Open"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("resolution = Unresolved"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("priority = Major"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("created >= 2009-02-01"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("created <= 2009-05-01"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("updated >= 2009-01-01"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("updated <= 2009-06-01"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("\"custom field 1\" ~ abc"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("\"custom field 2\" ~ \"123\""));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("\"custom field 3\" in cascadeOption(10000, 10002)"));
        TestUpgradeTask428.assertTrue((boolean)convertedJql.contains("cf[10020] = HSP"));
        this.navigation.issueNavigator().clickEditModeFlipLink();
        TestUpgradeTask428.assertEquals((Object)((Object)IssueNavigatorNavigation.NavigatorEditMode.SIMPLE), (Object)((Object)this.navigation.issueNavigator().getCurrentEditMode()));
        conditions = new ArrayList();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), "HSP-2", "HSP-1"));
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), 2));
        this.navigation.issueNavigator().loadFilter(10024L, null);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
        conditions = new ArrayList();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), "HSP-2", "HSP-1"));
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), 2));
        this.navigation.issueNavigator().loadFilter(10029L, null);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
        this.assertJqlQueryInTextArea(10029, "project in (10000, 10001) order by key desc");
        this.assertJqlQueryInTextArea(10031, "issuetype in standardissuetypes() and component = empty and fixversion in unreleasedversions() and affectedversion in releasedversions()");
        this.assertJqlQueryInTextArea(10032, "issuetype in subtaskissuetypes() and fixversion = empty");
        this.assertJqlQueryInTextArea(10033, "cf[10002] ~ invisible");
        this.assertJqlQueryInTextArea(10034, "MyDateP >= \"2009-08-01 11:11\" AND MyDateP <= \"2009-09-01 12:12\"");
        this.navigation.logout();
        this.navigation.login("fred");
        this.assertJqlQueryInTextArea(10026, "project = hsp order by updated desc");
        this.assertJqlQueryInTextArea(10027, "project = hsp order by created desc");
        this.assertJqlQueryInTextArea(10028, "project = hsp");
    }

    private void assertJqlQueryInTextArea(int filterId, String expectedJqlQuery) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?navType=advanced&mode=show&requestId=" + filterId);
        this.tester.setWorkingForm("jqlform");
        String jql = this.tester.getDialog().getForm().getParameterValue("jqlQuery");
        TestUpgradeTask428.assertEquals((String)expectedJqlQuery.toLowerCase(), (String)jql.toLowerCase());
    }

    private static String createDate(int year, int month, int day) {
        return TestUpgradeTask428.createDate(year, month, day, 0, 0);
    }

    private static String createDate(int year, int month, int day, int hour, int minute) {
        Calendar instance = Calendar.getInstance();
        instance.setLenient(true);
        instance.set(year, month, day, hour, minute, 0);
        instance.set(14, 0);
        return String.valueOf(instance.getTime().getTime());
    }
}

