/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.assertions.IssueNavigatorAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

public class TestSingleProject
extends AbstractJqlFuncTest {
    public void testSingleProjectIsSelectedOnNewFilter() throws Exception {
        this.administration.restoreData("TestJqlSingleProject.xml");
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertFilterFormValue(new IssueNavigatorAssertions.FilterFormParam("pid", "10001"));
        TestSingleProject.assertTrue((String)"Project specific custom field is present", (boolean)new XPathLocator(this.tester, "//input[@id='customfield_10000']").exists());
        this.navigation.issueNavigator().createSearch("type = task");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertFilterFormValue(new IssueNavigatorAssertions.FilterFormParam("pid", "-1"));
        TestSingleProject.assertFalse((String)"Project specific custom field is NOT present", (boolean)new XPathLocator(this.tester, "//input[@id='customfield_10000']").exists());
        this.tester.clickLink("new_filter");
        this.assertFilterFormValue(new IssueNavigatorAssertions.FilterFormParam("pid", "10001"));
        TestSingleProject.assertTrue((String)"Project specific custom field is present", (boolean)new XPathLocator(this.tester, "//input[@id='customfield_10000']").exists());
    }

    public void testNewFilterInsertsProject() throws Exception {
        this.administration.restoreData("TestJqlSingleProject.xml");
        this.navigation.issueNavigator().gotoNewMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("filterform");
        this.tester.submit("show");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//textarea[@id='jqltext']"), "project = MKY");
    }

    public void testQueryFits() throws Exception {
        this.assertFitsFilterForm("type = task", new IssueNavigatorAssertions.FilterFormParam("type", "3"));
        this.assertFitsFilterForm("project = MKY and type = task", new IssueNavigatorAssertions.FilterFormParam("type", "3"), new IssueNavigatorAssertions.FilterFormParam("pid", "10001"));
    }
}

