/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.assertions.HTMLAssertionsImpl;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.meterware.httpunit.HttpUnitOptions;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSearchRequestURLsInvalidParameters
extends FuncTestCase {
    private static final String QUERY = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?tempMax=1000&";

    @Override
    public void setUpTest() {
        this.administration.restoreData("TestSearchRequestURLsInvalidParameters.xml");
    }

    @Override
    protected void setUpHttpUnitOptions() {
        HttpUnitOptions.setExceptionsThrownOnErrorStatus((boolean)false);
        super.setUpHttpUnitOptions();
    }

    public void testEverySingleField() {
        ArrayList<Scenario> urls = new ArrayList<Scenario>();
        urls.addAll(this.affectedVersion());
        urls.addAll(this.assignee());
        urls.addAll(this.comment());
        urls.addAll(this.component());
        urls.addAll(this.created());
        urls.addAll(this.dueDate());
        urls.addAll(this.updated());
        urls.addAll(this.resolutionDate());
        urls.addAll(this.description());
        urls.addAll(this.environment());
        urls.addAll(this.summary());
        urls.addAll(this.fixVersion());
        urls.addAll(this.priority());
        urls.addAll(this.project());
        urls.addAll(this.resolution());
        urls.addAll(this.status());
        urls.addAll(this.type());
        urls.addAll(this.reporter());
        urls.addAll(this.workRatio());
        urls.addAll(this.datePicker());
        urls.addAll(this.dateTime());
        urls.addAll(this.freeTextField());
        urls.addAll(this.readOnlyTextField());
        urls.addAll(this.textField());
        urls.addAll(this.groupPicker());
        urls.addAll(this.importIdExactSearcher());
        urls.addAll(this.importIdRangeSearcher());
        urls.addAll(this.cascadingSelect());
        urls.addAll(this.numberFieldExactSearcher());
        urls.addAll(this.numberFieldRangeSearcher());
        urls.addAll(this.userPicker());
        urls.addAll(this.singleVersionPicker());
        urls.addAll(this.versionPicker());
        urls.addAll(this.projectPicker());
        urls.addAll(this.multiUserPicker());
        urls.addAll(this.multiGroupPicker());
        urls.addAll(this.multiCheckboxes());
        urls.addAll(this.multiSelect());
        urls.addAll(this.selectList());
        urls.addAll(this.radioButton());
        for (Scenario url : urls) {
            this.assertErrorResponse(url);
        }
    }

    private List<Scenario> affectedVersion() {
        return this.buildIdScenarios("version", "affectedVersion", "10011");
    }

    private List<Scenario> assignee() {
        return this.buildUserScenarios("assignee", "assignee");
    }

    private List<Scenario> comment() {
        return this.buildSystemTextScenario("body", "comment");
    }

    private List<Scenario> component() {
        return this.buildIdScenarios("component", "component", "10010");
    }

    private List<Scenario> created() {
        return this.buildDateScenarios("created");
    }

    private List<Scenario> dueDate() {
        return this.buildDateScenarios("duedate", "due");
    }

    private List<Scenario> updated() {
        return this.buildDateScenarios("updated");
    }

    private List<Scenario> resolutionDate() {
        return this.buildDateScenarios("resolutiondate", "resolved");
    }

    private List<Scenario> description() {
        return this.buildSystemTextScenario("description", "description");
    }

    private List<Scenario> environment() {
        return this.buildSystemTextScenario("environment", "environment");
    }

    private List<Scenario> summary() {
        return this.buildSystemTextScenario("summary", "summary");
    }

    private List<Scenario> fixVersion() {
        return this.buildIdScenarios("fixfor", "fixVersion", "10011");
    }

    private List<Scenario> priority() {
        return this.buildIdScenarios("priority", "priority", "1");
    }

    private List<Scenario> project() {
        return this.buildIdScenarios("pid", "project", "10010");
    }

    private List<Scenario> resolution() {
        return this.buildIdScenarios("resolution", "resolution", "1");
    }

    private List<Scenario> status() {
        return this.buildIdScenarios("status", "status", "1");
    }

    private List<Scenario> type() {
        return this.buildIdScenarios("type", "issuetype", "1");
    }

    private List<Scenario> reporter() {
        return this.buildUserScenarios("reporter", "reporter");
    }

    private List<Scenario> workRatio() {
        String field = "workratio";
        return CollectionBuilder.newBuilder(new Scenario("workratio:min=20&workratio:max=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate")), new Scenario("workratio:min=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate")), new Scenario("workratio:max=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate")), new Scenario("workratio:max=20&workratio:min=baddate", ErrorType.REQUIRES_INTEGER.formatError("workratio", "baddate"))).asList();
    }

    private List<Scenario> datePicker() {
        return this.buildDateScenarios("customfield_10001", "DP");
    }

    private List<Scenario> dateTime() {
        String urlParam = "customfield_10002";
        String field = "DT";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10002:before=baddate", ErrorType.INVALID_DATE.formatError("DT", "baddate")), new Scenario("customfield_10002:after=baddate", ErrorType.INVALID_DATE.formatError("DT", "baddate")), new Scenario("customfield_10002:previous=HHH", ErrorType.INVALID_DATE.formatError("DT", "HHH")), new Scenario("customfield_10002:next=HHH", ErrorType.INVALID_DATE.formatError("DT", "HHH")), new Scenario("customfield_10002:before=11/May/08+11:34+AM&customfield_10002:after=baddate", ErrorType.INVALID_DATE.formatError("DT", "baddate")), new Scenario("customfield_10002:previous=1h&customfield_10002:next=HHH", ErrorType.INVALID_DATE.formatError("DT", "HHH"))).asList();
    }

    private List<Scenario> freeTextField() {
        return this.buildTextScenario("customfield_10003", "FTF");
    }

    private List<Scenario> readOnlyTextField() {
        return this.buildTextScenario("customfield_10013", "ROTF");
    }

    private List<Scenario> textField() {
        return this.buildTextScenario("customfield_10016", "TF");
    }

    private List<Scenario> groupPicker() {
        String urlParam = "customfield_10004";
        String field = "GP";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10004=1", ErrorType.GROUP_DOESNT_EXIST.formatError("GP", "1"))).asList();
    }

    private List<Scenario> importIdExactSearcher() {
        String urlParam = "customfield_10005";
        String field = "II exact";
        return this.buildExactNumberScenarios("customfield_10005", "II exact");
    }

    private List<Scenario> importIdRangeSearcher() {
        String urlParam = "customfield_10020";
        String field = "II range";
        return this.buildRangeNumberScenarios("customfield_10020", "II range");
    }

    private List<Scenario> cascadingSelect() {
        String urlParam = "customfield_10000";
        String field = "CSF";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10000=10010&customfield_10000:1=invalid", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "invalid")), new Scenario("customfield_10000=yes", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "yes")), new Scenario("customfield_10000=20", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "20")), new Scenario("customfield_10000:1=yes", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "yes")), new Scenario("customfield_10000:1=20", ErrorType.OPTION_DOESNT_EXIST.formatError("CSF", "20"))).asList();
    }

    private List<Scenario> numberFieldExactSearcher() {
        return this.buildExactNumberScenarios("customfield_10010", "NF exact");
    }

    private List<Scenario> numberFieldRangeSearcher() {
        return this.buildRangeNumberScenarios("customfield_10021", "NF range");
    }

    private List<Scenario> userPicker() {
        return this.buildUserScenarios("customfield_10018", "UP");
    }

    private List<Scenario> singleVersionPicker() {
        return this.buildIdScenarios("customfield_10015", "SVP", "10011");
    }

    private List<Scenario> versionPicker() {
        return this.buildIdScenarios("customfield_10019", "VP", "10011");
    }

    private List<Scenario> projectPicker() {
        String urlName = "customfield_10011";
        String field = "PP";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10011=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError("PP", "yes")), new Scenario("customfield_10011=50000", ErrorType.NUMBER_VALUE_DOESNT_EXIST.formatError("PP", "50000"))).asList();
    }

    private List<Scenario> multiGroupPicker() {
        String urlParam = "customfield_10007";
        String field = "MGP";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10007=1", ErrorType.GROUP_DOESNT_EXIST.formatError("MGP", "1"))).asList();
    }

    private List<Scenario> multiUserPicker() {
        return this.buildUserScenarios("customfield_10009", "MUP");
    }

    private List<Scenario> multiCheckboxes() {
        String urlParam = "customfield_10006";
        String field = "MC";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10006=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MC", "1")), new Scenario("customfield_10006=opt1&customfield_10006=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MC", "1"))).asList();
    }

    private List<Scenario> multiSelect() {
        String urlParam = "customfield_10008";
        String field = "MS";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10008=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MS", "1")), new Scenario("customfield_10008=select1&customfield_10008=1", ErrorType.OPTION_DOESNT_EXIST.formatError("MS", "1"))).asList();
    }

    private List<Scenario> selectList() {
        String urlParam = "customfield_10014";
        String field = "SL";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10014=1", ErrorType.OPTION_DOESNT_EXIST.formatError("SL", "1"))).asList();
    }

    private List<Scenario> radioButton() {
        String urlParam = "customfield_10012";
        String field = "RB";
        return CollectionBuilder.newBuilder(new Scenario("customfield_10012=1", ErrorType.OPTION_DOESNT_EXIST.formatError("RB", "1"))).asList();
    }

    private List<Scenario> buildUserScenarios(String urlParam, String field) {
        return CollectionBuilder.newBuilder(new Scenario(urlParam + "=1", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError(field, "1"))).asList();
    }

    private List<Scenario> buildSystemTextScenario(String urlParam, String field) {
        return CollectionBuilder.newBuilder(new Scenario("query=%3Fbadtextquery&" + urlParam + "=true", ErrorType.TEXT_START_CHAR.formatError(field, "?badtextquery"))).asList();
    }

    private List<Scenario> buildTextScenario(String urlParam, String field) {
        return CollectionBuilder.newBuilder(new Scenario(urlParam + "=%3Fbadtextquery", ErrorType.TEXT_START_CHAR.formatError(field, "?badtextquery"))).asList();
    }

    private List<Scenario> buildDateScenarios(String field) {
        return this.buildDateScenarios(field, field);
    }

    private List<Scenario> buildDateScenarios(String urlParam, String field) {
        return CollectionBuilder.newBuilder(new Scenario(urlParam + ":before=baddate", ErrorType.INVALID_DATE.formatError(field, "baddate")), new Scenario(urlParam + ":after=baddate", ErrorType.INVALID_DATE.formatError(field, "baddate")), new Scenario(urlParam + ":previous=HHH", ErrorType.INVALID_DATE.formatError(field, "HHH")), new Scenario(urlParam + ":next=HHH", ErrorType.INVALID_DATE.formatError(field, "HHH")), new Scenario(urlParam + ":before=11/May/08&" + urlParam + ":after=baddate", ErrorType.INVALID_DATE.formatError(field, "baddate")), new Scenario(urlParam + ":previous=1h&" + urlParam + ":next=HHH", ErrorType.INVALID_DATE.formatError(field, "HHH"))).asList();
    }

    private List<Scenario> buildIdScenarios(String urlName, String field, String validId) {
        return CollectionBuilder.newBuilder(new Scenario(urlName + "=yes", ErrorType.STRING_VALUE_DOESNT_EXIST.formatError(field, "yes")), new Scenario(urlName + "=50000", ErrorType.NUMBER_VALUE_DOESNT_EXIST.formatError(field, "50000")), new Scenario(urlName + "=" + validId + "&" + urlName + "=50000", ErrorType.NUMBER_VALUE_DOESNT_EXIST.formatError(field, "50000"))).asList();
    }

    private List<Scenario> buildExactNumberScenarios(String urlParam, String field) {
        return CollectionBuilder.newBuilder(new Scenario(urlParam + "=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber"))).asList();
    }

    private List<Scenario> buildRangeNumberScenarios(String urlParam, String field) {
        return CollectionBuilder.newBuilder(new Scenario(urlParam + ":greaterThan=20&" + urlParam + ":lessThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")), new Scenario(urlParam + ":greaterThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")), new Scenario(urlParam + ":lessThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber")), new Scenario(urlParam + ":lessThan=20&" + urlParam + ":greaterThan=badnumber", ErrorType.REQUIRES_NUMBER.formatError(field, "badnumber"))).asList();
    }

    private void assertErrorResponse(Scenario scenario) {
        this.log(QUERY + scenario.urlParams);
        this.tester.gotoPage(QUERY + scenario.urlParams);
        TestSearchRequestURLsInvalidParameters.assertEquals((int)400, (int)this.tester.getDialog().getResponse().getResponseCode());
        new HTMLAssertionsImpl().assertResponseContains(this.tester, scenario.msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ErrorType {
        TEXT_START_CHAR{

            String formatError(String fieldName, String value) {
                return String.format("The text query '%s' for field '%s' is not allowed to start with ", value, fieldName);
            }
        }
        ,
        INVALID_DATE{

            String formatError(String fieldName, String value) {
                return String.format("Date value '%s' for field '%s' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.", value, fieldName);
            }
        }
        ,
        GROUP_DOESNT_EXIST{

            String formatError(String fieldName, String value) {
                return String.format("The group '%s' for field '%s' does not exist.", value, fieldName);
            }
        }
        ,
        STRING_VALUE_DOESNT_EXIST{

            String formatError(String fieldName, String value) {
                return String.format("The value '%s' does not exist for the field '%s'.", value, fieldName);
            }
        }
        ,
        NUMBER_VALUE_DOESNT_EXIST{

            String formatError(String fieldName, String value) {
                return String.format("A value with ID '%s' does not exist for the field '%s'.", value, fieldName);
            }
        }
        ,
        REQUIRES_INTEGER{

            String formatError(String fieldName, String value) {
                return String.format("The value '%s' for field '%s' is invalid - please specify an integer.", value, fieldName);
            }
        }
        ,
        REQUIRES_NUMBER{

            String formatError(String fieldName, String value) {
                return String.format("Value '%s' for the '%s' field is not a valid number.", value, fieldName);
            }
        }
        ,
        OPTION_DOESNT_EXIST{

            String formatError(String fieldName, String value) {
                return String.format("The option '%s' for field '%s' does not exist.", value, fieldName);
            }
        };


        abstract String formatError(String var1, String var2);
    }

    private static class Scenario {
        private final String urlParams;
        private final String msg;

        private Scenario(String urlParams, String msg) {
            this.urlParams = urlParams;
            this.msg = msg;
        }
    }
}

