/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

public class TestNestedSavedFilters
extends AbstractJqlFuncTest {
    private static final int FILTER_HOMOSAPIENS = 10000;
    private static final int FILTER_1 = 10002;
    private static final int FILTER_HOMOSAPIENS_AND_MONKEYS = 10004;

    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestNestedSavedFilters.xml");
    }

    public void testNestedSavedFilters() throws Exception {
        this.navigation.issueNavigator().loadFilter(10002L, IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.tester.setFormElement("jqlQuery", "status = \"open\" and filter = \"Filter 2\"");
        this.tester.submit();
        this.tester.assertTextPresent("Field 'filter' with value 'Filter 2' matches filter 'Filter 2' and causes a cyclical reference, this query can not be executed and should be edited.");
    }

    public void testReferencedFilterInvalid() throws Exception {
        this._loadFilter(10004);
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filterForm']"), "Edit", "the current filter to correct errors");
    }

    public void testReferencedFilterBecomesInvalid() throws Exception {
        this._loadFilter(10000);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults("HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1");
        this.administration.permissionSchemes().getPermissionScheme("Default Permission Scheme").removePermission(10, "jira-administrators");
        this._loadFilter(10000);
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='filterForm']"), "Edit", "the current filter to correct errors");
    }

    private void _loadFilter(int filterId) {
        this.tester.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=" + filterId);
    }
}

